/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.gmf.runtime.common.ui.dialogs.SelectedType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class SelectableElement {
    private String id;
    private String name;
    private ImageDescriptor icon;
    private Vector children = new Vector();
    private SelectedType selectedType;
    private SelectableElement parent;
    private Object hint;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.dialogs.SelectableElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void addChild(SelectableElement element) {
        this.children.add(element);
        element.setParent(this);
    }

    public void removeAllChildren() {
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            ((SelectableElement)i.next()).setParent(null);
        }
        this.children = new Vector();
    }

    public SelectableElement(String aName, ImageDescriptor anIcon, Object aHint) {
        this(aName, aName, anIcon, aHint);
    }

    public SelectableElement(String anID, String aName, ImageDescriptor anIcon, Object aHint) {
        this.id = anID;
        this.name = aName;
        this.icon = anIcon;
        this.hint = aHint;
        this.selectedType = SelectedType.UNSELECTED;
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    public SelectableElement getChild(int i) {
        if (!($assertionsDisabled || i >= 0 && i < this.children.size())) {
            throw new AssertionError();
        }
        return (SelectableElement)this.children.get(i);
    }

    public ImageDescriptor getIconImageDescriptor() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public void setIconImageDescriptor(ImageDescriptor anIcon) {
        this.icon = anIcon;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public SelectableElement getParent() {
        return this.parent;
    }

    public void setParent(SelectableElement aParent) {
        this.parent = aParent;
    }

    public SelectableElement[] getChildren() {
        SelectableElement[] elements = new SelectableElement[this.getNumberOfChildren()];
        int i = 0;
        while (i < this.getNumberOfChildren()) {
            elements[i] = (SelectableElement)this.children.elementAt(i);
            ++i;
        }
        return elements;
    }

    public SelectedType getSelectedType() {
        return this.selectedType;
    }

    public void setSelectedType(SelectedType aSelectedType) {
        this.selectedType = aSelectedType;
    }

    public Object getHint() {
        return this.hint;
    }

    public static void setSelectedTypeForSelecteableElementAndChildren(SelectableElement parent, SelectedType selectedType) {
        int i = 0;
        while (i < parent.getNumberOfChildren()) {
            SelectableElement.setSelectedTypeForSelecteableElementAndChildren(parent.getChild(i), selectedType);
            ++i;
        }
        parent.setSelectedType(selectedType);
    }

    public static void setSelectedTypeForMatchingSelecteableElementAndChildren(SelectableElement parent, SelectedType selectedType, List list) {
        int i = 0;
        while (i < parent.getNumberOfChildren()) {
            SelectableElement.setSelectedTypeForMatchingSelecteableElementAndChildren(parent.getChild(i), selectedType, list);
            ++i;
        }
        if (list.contains(parent.getId())) {
            SelectableElement.setSelectedTypeForSelecteableElementAndChildren(parent, selectedType);
        }
    }

    public static int calculateLongestStringLength(SelectableElement selectableElement, Control control) {
        int INITIAL_LONGEST_STRING_LENGTH = 0;
        int INITIAL_ITERATION_LEVEL = -1;
        if (!$assertionsDisabled && selectableElement.getParent() != null) {
            throw new AssertionError();
        }
        GC gc = new GC((Drawable)control);
        int longestStringLength = SelectableElement.calculateLongestStringLength(selectableElement, gc, INITIAL_LONGEST_STRING_LENGTH, INITIAL_ITERATION_LEVEL);
        gc.dispose();
        return longestStringLength;
    }

    private static int calculateLongestStringLength(SelectableElement selectableElement, GC gc, int longestStringLength, int iterationLevel) {
        int ICON_WIDTH = 32;
        Point size = gc.textExtent(selectableElement.getName());
        if (size.x + iterationLevel * ICON_WIDTH > longestStringLength) {
            longestStringLength = size.x + iterationLevel * ICON_WIDTH;
        }
        int i = 0;
        while (i < selectableElement.getNumberOfChildren()) {
            longestStringLength = SelectableElement.calculateLongestStringLength(selectableElement.getChild(i), gc, longestStringLength, iterationLevel + 1);
            ++i;
        }
        return longestStringLength;
    }

    public static int calculateNumberOfChildren(SelectableElement selectableElement) {
        int numberOfChildren = 0;
        int i = 0;
        while (i < selectableElement.getNumberOfChildren()) {
            numberOfChildren += SelectableElement.calculateNumberOfChildren(selectableElement.getChild(i));
            ++i;
        }
        return numberOfChildren + 1;
    }

    private void getMatchingElementTypes(List matchingElements, SelectedType typeToMatch) {
        int i = 0;
        while (i < this.getNumberOfChildren()) {
            this.getChild(i).getMatchingElementTypes(matchingElements, typeToMatch);
            ++i;
        }
        if (this.getSelectedType() == typeToMatch && this.getHint() != null) {
            if (this.getHint() instanceof Collection) {
                matchingElements.addAll((Collection)this.getHint());
            } else {
                matchingElements.add(this.getHint());
            }
        }
    }

    public List getSelectedElementTypes() {
        Vector selectedElements = new Vector();
        this.getMatchingElementTypes(selectedElements, SelectedType.SELECTED);
        return selectedElements;
    }

    public List getUnSelectedElementTypes() {
        Vector unselectedElements = new Vector();
        this.getMatchingElementTypes(unselectedElements, SelectedType.UNSELECTED);
        return unselectedElements;
    }

    public List getLeaveElementTypes() {
        Vector leaveElements = new Vector();
        this.getMatchingElementTypes(leaveElements, SelectedType.LEAVE);
        return leaveElements;
    }

    public String getId() {
        return this.id;
    }

    public void getHints(List stringRepresentations, Set hints) {
        if (stringRepresentations.contains(this.getId())) {
            this.getAllHints(hints);
        } else {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                ((SelectableElement)i.next()).getHints(stringRepresentations, hints);
            }
        }
    }

    public void getAllHints(Set hints) {
        if (this.hint instanceof List) {
            hints.addAll((List)this.hint);
        } else if (this.hint != null) {
            hints.add(this.hint);
        }
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            ((SelectableElement)i.next()).getAllHints(hints);
        }
    }

    public static void addHintsToList(List list, SelectableElement selectableElement) {
        if (!$assertionsDisabled && list == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && selectableElement == null) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < selectableElement.getNumberOfChildren()) {
            SelectableElement.addHintsToList(list, selectableElement.getChild(i));
            ++i;
        }
        Object hint = selectableElement.getHint();
        if (hint != null) {
            if (hint instanceof List) {
                Iterator it = ((List)hint).iterator();
                while (it.hasNext()) {
                    Object nestedHint = it.next();
                    if (list.contains(nestedHint)) continue;
                    list.add(nestedHint);
                }
            } else if (!list.contains(hint)) {
                list.add(hint);
            }
        }
    }

    public static boolean doAllChildrenHaveSelectedType(SelectableElement parent, SelectedType selectType) {
        int i = 0;
        while (i < parent.getNumberOfChildren()) {
            if (parent.getChild(i).getSelectedType() != selectType) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void getAllChildrenOfType(SelectableElement parent, SelectedType selectType, List list) {
        if (!$assertionsDisabled && list == null) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < parent.getNumberOfChildren()) {
            if (parent.getChild(i).getSelectedType() == selectType) {
                list.add(parent.getChild(i));
            }
            SelectableElement.getAllChildrenOfType(parent.getChild(i), selectType, list);
            ++i;
        }
    }

    public List getSelectedElementIds() {
        ArrayList list = new ArrayList();
        this.getMatchingElementIds(list, SelectedType.SELECTED);
        return list;
    }

    private void getMatchingElementIds(List matchingIds, SelectedType typeToMatch) {
        int i = 0;
        while (i < this.getNumberOfChildren()) {
            this.getChild(i).getMatchingElementIds(matchingIds, typeToMatch);
            ++i;
        }
        if (this.getSelectedType() == typeToMatch) {
            matchingIds.add(this.getId());
        }
    }

    public SelectableElement makeCopy() {
        SelectableElement selectableElement = this.immediateCopy(this);
        this.copyChildren(this, selectableElement);
        return selectableElement;
    }

    private SelectableElement immediateCopy(SelectableElement src) {
        SelectableElement selectableElement = new SelectableElement(src.getId(), src.getName(), src.getIconImageDescriptor(), src.getHint());
        selectableElement.setSelectedType(src.getSelectedType());
        return selectableElement;
    }

    private void copyChildren(SelectableElement src, SelectableElement dest) {
        int i = 0;
        while (i < src.getNumberOfChildren()) {
            dest.addChild(this.immediateCopy(src.getChild(i)));
            this.copyChildren(src.getChild(i), dest.getChild(i));
            ++i;
        }
    }

    private void collectChildrenHints(List list) {
        Object aHint = this.getHint();
        if (aHint instanceof List) {
            Iterator it = ((List)aHint).iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (list.contains(obj)) continue;
                list.add(obj);
            }
        } else if (aHint != null && !list.contains(aHint)) {
            list.add(aHint);
        }
        int i = 0;
        while (i < this.getChildren().length) {
            this.getChild(i).collectChildrenHints(list);
            ++i;
        }
    }

    public void getHintsThatMatchTheseIds(List list, List ids) {
        int i = 0;
        while (i < this.getNumberOfChildren()) {
            if (ids.contains(this.getChild(i).getId())) {
                this.getChild(i).collectChildrenHints(list);
            } else {
                this.getChild(i).getHintsThatMatchTheseIds(list, ids);
            }
            ++i;
        }
    }

    public static SelectableElement findById(List selectableElements, String id) {
        if (!$assertionsDisabled && selectableElements == null) {
            throw new AssertionError();
        }
        Iterator it = selectableElements.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!$assertionsDisabled && !(obj instanceof SelectableElement)) {
                throw new AssertionError();
            }
            SelectableElement selectableElement = (SelectableElement)obj;
            if (!id.equals(selectableElement.getId())) continue;
            return selectableElement;
        }
        return null;
    }

    public SelectableElement findById(String theId) {
        if (!$assertionsDisabled && theId == null) {
            throw new AssertionError();
        }
        if (theId.equals(this.getId())) {
            return this;
        }
        int i = 0;
        while (i < this.getNumberOfChildren()) {
            SelectableElement element = this.getChild(i).findById(theId);
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }
}

