/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.internal.xpand.Activator;
import org.eclipse.gmf.internal.xpand.BufferOutput;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.StreamsHolder;
import org.eclipse.gmf.internal.xpand.model.AmbiguousDefinitionException;
import org.eclipse.gmf.internal.xpand.model.EvaluationException;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.gmf.internal.xpand.model.Scope;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.util.BundleResourceManager;
import org.eclipse.gmf.internal.xpand.xtend.ast.QvtResource;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.OCLEnvironmentWithQVTAccessFactory;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XpandFacade {
    private static final String IMPLICIT_VAR_NAME = "self";
    private static final String IMPLICIT_VAR_NAME_BACKWARD_COMPATIBILITY = "this";
    private final LinkedList<org.eclipse.gmf.internal.xpand.model.Variable> myGlobals = new LinkedList();
    private final LinkedList<URL> myLocations = new LinkedList();
    private final LinkedList<String> myImportedModels = new LinkedList();
    private final LinkedList<String> myExtensionFiles = new LinkedList();
    private boolean myEnforceReadOnlyNamedStreamsAfterAccess = false;
    private ExecutionContext myXpandCtx;
    private BufferOutput myBufferOut;
    private HashMap<Object, StreamsHolder> myStreamsHolders;
    private final StringBuilder myOut = new StringBuilder();
    private Map<String, URI> myMetamodelURI2LocationMap = new HashMap<String, URI>();
    private final ResourceSet myResourceSet;
    private Map<String, URI> mySchemaLocations;

    public XpandFacade(ResourceSet resourceSet) {
        this.myResourceSet = resourceSet;
    }

    public XpandFacade(XpandFacade chain) {
        assert (chain != null);
        this.myGlobals.addAll(chain.myGlobals);
        this.myLocations.addAll(chain.myLocations);
        this.myImportedModels.addAll(chain.myImportedModels);
        this.myExtensionFiles.addAll(chain.myExtensionFiles);
        this.myXpandCtx = chain.myXpandCtx;
        this.myResourceSet = chain.myResourceSet;
        this.myMetamodelURI2LocationMap = chain.myMetamodelURI2LocationMap;
        this.mySchemaLocations = chain.mySchemaLocations;
    }

    public void setEnforceReadOnlyNamedStreamsAfterAccess(boolean value) {
        this.myEnforceReadOnlyNamedStreamsAfterAccess = value;
    }

    public void addGlobal(String name, Object value) {
        assert (name != null);
        ListIterator it = this.myGlobals.listIterator();
        while (it.hasNext()) {
            if (!((org.eclipse.gmf.internal.xpand.model.Variable)it.next()).getName().equals(name)) continue;
            it.remove();
        }
        if (name == null || value == null) {
            return;
        }
        this.myGlobals.addFirst(new org.eclipse.gmf.internal.xpand.model.Variable(name, null, value));
        this.clearAllContexts();
    }

    public void addLocation(String url) throws MalformedURLException {
        this.addLocation(new URL(url));
    }

    public void addLocation(URL url) {
        assert (url != null);
        this.myLocations.addLast(url);
        this.clearAllContexts();
    }

    public void registerMetamodel(String nsUri, URI location) {
        if (!this.myMetamodelURI2LocationMap.containsKey(nsUri)) {
            this.myMetamodelURI2LocationMap.put(nsUri, location);
        }
    }

    public void setSchemaLocations(Map<String, URI> schemaLocations) {
        this.mySchemaLocations = schemaLocations;
    }

    @Deprecated
    public void addClassLoadContext(ClassLoader loader) {
    }

    @Deprecated
    public void addClassLoadContext(Bundle bundle) {
    }

    public void addMetamodel(String metamodel) {
        if (this.myImportedModels.contains(metamodel)) {
            return;
        }
        this.myImportedModels.add(metamodel);
    }

    public void addExtensionFile(String extensionFile) {
        if (this.myExtensionFiles.contains(extensionFile)) {
            return;
        }
        this.myExtensionFiles.add(extensionFile);
    }

    public <T> T evaluate(String expression, Object target) {
        return this.evaluate(expression, Collections.singletonMap(IMPLICIT_VAR_NAME, target));
    }

    public <T> T evaluate(String expression, Map<String, ?> context) {
        Object result;
        org.eclipse.ocl.ecore.OCLExpression exp;
        BundleResourceManager rm;
        assert (context != null);
        if (this.myLocations.isEmpty()) {
            try {
                rm = new BundleResourceManager(new URL[]{new File(".").getCanonicalFile().toURI().toURL()});
            }
            catch (IOException iOException) {
                rm = null;
            }
        } else {
            rm = new BundleResourceManager(this.myLocations.toArray(new URL[this.myLocations.size()]));
        }
        Set<Module> importedModules = this.getImportedModules((ResourceManager)rm);
        OCLEnvironmentWithQVTAccessFactory factory = new OCLEnvironmentWithQVTAccessFactory(importedModules, this.getAllVisibleModels());
        OCL ocl = OCL.newInstance((EnvironmentFactory)factory);
        Object thisValue = null;
        if (context != null) {
            for (Map.Entry<String, ?> nextEntry : context.entrySet()) {
                String varName = nextEntry.getKey();
                Object varValue = nextEntry.getValue();
                if (IMPLICIT_VAR_NAME.equals(varName) || IMPLICIT_VAR_NAME_BACKWARD_COMPATIBILITY.equals(varName)) {
                    assert (thisValue == null);
                    thisValue = varValue;
                    continue;
                }
                EClassifier varType = BuiltinMetaModel.getType((ExecutionContext)this.getXpandContext(), varValue);
                Variable oclVar = EcoreFactory.eINSTANCE.createVariable();
                oclVar.setName(varName);
                oclVar.setType((Object)varType);
                ocl.getEnvironment().addElement(varName, (org.eclipse.ocl.expressions.Variable)oclVar, true);
            }
        }
        OCL.Helper oclHelper = ocl.createOCLHelper();
        if (thisValue != null) {
            oclHelper.setContext((Object)BuiltinMetaModel.getType((ExecutionContext)this.getXpandContext(), thisValue));
        } else {
            oclHelper.setContext((Object)((EClassifier)ocl.getEnvironment().getOCLStandardLibrary().getOclVoid()));
        }
        try {
            exp = oclHelper.createQuery(expression);
        }
        catch (ParserException e) {
            throw new EvaluationException((Throwable)e);
        }
        OCL.Query query = ocl.createQuery((OCLExpression)exp);
        EcoreEvaluationEnvironment ee = (EcoreEvaluationEnvironment)query.getEvaluationEnvironment();
        if (context != null) {
            for (Map.Entry<String, ?> nextEntry : context.entrySet()) {
                String varName = nextEntry.getKey();
                Object varValue = nextEntry.getValue();
                if (IMPLICIT_VAR_NAME.equals(varName) || IMPLICIT_VAR_NAME_BACKWARD_COMPATIBILITY.equals(varName)) continue;
                ee.add(varName, varValue);
            }
        }
        if ((result = thisValue != null ? query.evaluate(thisValue) : query.evaluate()) == ocl.getEnvironment().getOCLStandardLibrary().getOclInvalid()) {
            return null;
        }
        return (T)result;
    }

    private Set<Module> getImportedModules(ResourceManager rm) {
        HashSet<Module> result = new HashSet<Module>();
        for (String extensionFile : this.myExtensionFiles) {
            QvtResource qvtResource = rm.loadQvtResource(extensionFile);
            result.addAll(qvtResource.getModules());
        }
        return result;
    }

    private EPackage.Registry getAllVisibleModels() {
        assert (this.myImportedModels != null);
        EPackageRegistryImpl result = new EPackageRegistryImpl();
        for (String namespace : this.myImportedModels) {
            EPackage pkg = Activator.findMetaModel((String)namespace);
            if (pkg == null) continue;
            result.put((Object)namespace, (Object)pkg);
        }
        if (result.isEmpty()) {
            result.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        }
        return result;
    }

    public String xpand(String templateName, Object target, Object ... arguments) {
        if (target == null) {
            return null;
        }
        this.clearOut();
        ExecutionContext ctx = this.getXpandContext();
        try {
            new org.eclipse.gmf.internal.xpand.XpandFacade(ctx).evaluate(templateName, target, arguments);
        }
        catch (AmbiguousDefinitionException e) {
            throw new EvaluationException(e);
        }
        return this.myOut.toString();
    }

    public Map<Object, String> xpand(String templateName, Collection<?> target, Object ... arguments) {
        boolean invokeForCollection;
        LinkedHashMap<Object, String> inputToResult = new LinkedHashMap<Object, String>();
        boolean bl = invokeForCollection = this.findDefinition(templateName, target, arguments) != null;
        if (invokeForCollection) {
            inputToResult.put(target, this.xpand(templateName, (Object)target, arguments));
            return inputToResult;
        }
        this.myStreamsHolders = new HashMap();
        for (Object nextInput : target) {
            if (nextInput == null) continue;
            String result = this.xpand(templateName, nextInput, arguments);
            inputToResult.put(nextInput, result);
            this.myStreamsHolders.put(nextInput, this.myBufferOut.getNamedStreams());
        }
        return inputToResult;
    }

    public Collection<String> getNamedStreams() {
        assert (this.myStreamsHolders == null);
        if (this.myBufferOut == null) {
            return Collections.emptyList();
        }
        return this.myBufferOut.getNamedStreams().getSlotNames();
    }

    public String getNamedStreamContents(String streamName) {
        assert (this.myStreamsHolders == null);
        if (this.myBufferOut == null) {
            throw new UnsupportedOperationException("Stream with the given name does not exist", null);
        }
        return this.myBufferOut.getNamedStreams().getStreamContents(streamName);
    }

    public Collection<String> getNamedStreams(Object input) {
        if (this.myStreamsHolders == null) {
            return this.getNamedStreams();
        }
        StreamsHolder streamsHolder = this.myStreamsHolders.get(input);
        if (streamsHolder == null) {
            return Collections.emptyList();
        }
        return streamsHolder.getSlotNames();
    }

    public String getNamedStreamContents(Object input, String streamName) {
        if (this.myStreamsHolders == null) {
            return this.getNamedStreamContents(streamName);
        }
        StreamsHolder streamsHolder = this.myStreamsHolders.get(input);
        if (streamsHolder == null) {
            throw new UnsupportedOperationException("Stream with the given name does not exist", null);
        }
        return streamsHolder.getStreamContents(streamName);
    }

    private XpandDefinition findDefinition(String templateName, Object target, Object[] arguments) {
        EClassifier targetType = BuiltinMetaModel.getType((ExecutionContext)this.getXpandContext(), (Object)target);
        EClassifier[] paramTypes = new EClassifier[arguments == null ? 0 : arguments.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramTypes[i] = BuiltinMetaModel.getType((ExecutionContext)this.getXpandContext(), (Object)arguments[i]);
            ++i;
        }
        try {
            return this.getXpandContext().findDefinition(templateName, targetType, paramTypes);
        }
        catch (AmbiguousDefinitionException ambiguousDefinitionException) {
            return null;
        }
    }

    private void clearAllContexts() {
        this.myXpandCtx = null;
    }

    private void clearOut() {
        this.myOut.setLength(200);
        this.myOut.trimToSize();
        this.myOut.setLength(0);
        this.myXpandCtx = null;
        this.myBufferOut = null;
    }

    private ExecutionContext getXpandContext() {
        if (this.myXpandCtx == null) {
            BundleResourceManager rm = new BundleResourceManager(this.myLocations.toArray(new URL[this.myLocations.size()])){

                protected ResourceSet getMetamodelResourceSet() {
                    return XpandFacade.this.myResourceSet;
                }
            };
            this.myBufferOut = new BufferOutput(this.myOut, this.myEnforceReadOnlyNamedStreamsAfterAccess);
            Scope scope = new Scope((ResourceManager)rm, this.myGlobals, (Output)this.myBufferOut){

                public EPackage.Registry createPackageRegistry(String[] metamodelURIs) {
                    if (!$assertionsDisabled && metamodelURIs == null) {
                        throw new AssertionError();
                    }
                    EPackageRegistryImpl result = new EPackageRegistryImpl();
                    String[] stringArray = metamodelURIs;
                    int n = metamodelURIs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object pkg;
                        String namespace = stringArray[n2];
                        if (XpandFacade.this.myMetamodelURI2LocationMap.containsKey(namespace)) {
                            pkg = XpandFacade.this.loadMainEPackage((URI)XpandFacade.this.myMetamodelURI2LocationMap.get(namespace));
                        } else if (EPackage.Registry.INSTANCE.containsKey((Object)namespace)) {
                            pkg = EPackage.Registry.INSTANCE.getEPackage(namespace);
                        } else {
                            URI metamodelURI = (URI)XpandFacade.this.mySchemaLocations.get(namespace);
                            Resource resource = XpandFacade.this.myResourceSet.getResource(metamodelURI, true);
                            pkg = resource.getContents().size() > 0 && resource.getContents().get(0) instanceof EPackage ? (EPackage)resource.getContents().get(0) : null;
                        }
                        if (pkg != null) {
                            result.put((Object)namespace, pkg);
                        }
                        ++n2;
                    }
                    return result;
                }
            };
            this.myXpandCtx = new ExecutionContextImpl(scope);
        }
        return this.myXpandCtx;
    }

    private EPackage loadMainEPackage(URI uri) {
        Resource resource = this.myResourceSet.getResource(uri, true);
        if (resource.getContents().size() > 0 && resource.getContents().get(0) instanceof EPackage) {
            return (EPackage)resource.getContents().get(0);
        }
        return null;
    }
}

