/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.validate;

import junit.framework.TestCase;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.tests.validate.AnnotationUtil;
import org.eclipse.gmf.tests.validate.DynamicModelHelper;
import org.eclipse.gmf.validate.GMFValidator;

public abstract class MetaExpressionDefTestBase
extends TestCase {
    protected EClass constraintMetaClass;
    protected EStructuralFeature languageAttr;
    protected EStructuralFeature bodyAttr;
    protected EReference constraintRefFeatureCtx;
    protected EReference constraintRefWithOCLCtx;
    protected EClass containerClass;
    protected EStructuralFeature ctxClassRef;
    protected EStructuralFeature ctxTypeRef;
    protected final String metaDefinitionAnnotationKey;

    MetaExpressionDefTestBase(String name, String metaDefKey) {
        super(name);
        this.metaDefinitionAnnotationKey = metaDefKey;
    }

    protected void setUp() throws Exception {
        super.setUp();
        EPackage model = DynamicModelHelper.createMetaModel();
        this.containerClass = DynamicModelHelper.createMetaClass(model);
        this.ctxClassRef = DynamicModelHelper.createFeature(this.containerClass, (EClassifier)EcorePackage.eINSTANCE.getEClass());
        this.ctxTypeRef = DynamicModelHelper.createFeature(this.containerClass, (EClassifier)EcorePackage.eINSTANCE.getEDataType());
        this.constraintMetaClass = DynamicModelHelper.createMetaClass(model);
        this.languageAttr = DynamicModelHelper.createFeature(this.constraintMetaClass, (EClassifier)EcorePackage.eINSTANCE.getEString());
        this.bodyAttr = DynamicModelHelper.createFeature(this.constraintMetaClass, (EClassifier)EcorePackage.eINSTANCE.getEString());
        EAnnotation eAnnotation = AnnotationUtil.createAnnotation((EModelElement)this.constraintMetaClass, "http://www.eclipse.org/gmf/2005/constraints/meta");
        eAnnotation.getDetails().put((Object)"def", (Object)this.metaDefinitionAnnotationKey);
        EcoreUtil.setAnnotation((EModelElement)this.languageAttr, (String)"http://www.eclipse.org/gmf/2005/constraints/meta", (String)"def", (String)"lang");
        EcoreUtil.setAnnotation((EModelElement)this.bodyAttr, (String)"http://www.eclipse.org/gmf/2005/constraints/meta", (String)"def", (String)"body");
        this.constraintRefFeatureCtx = (EReference)DynamicModelHelper.createFeature(this.containerClass, (EClassifier)this.constraintMetaClass);
        this.constraintRefFeatureCtx.setContainment(true);
        AnnotationUtil.addContextDefAnnotation((EModelElement)this.constraintRefFeatureCtx, this.ctxClassRef.getName());
        this.constraintRefWithOCLCtx = (EReference)DynamicModelHelper.createFeature(this.containerClass, (EClassifier)this.constraintMetaClass);
        this.constraintRefWithOCLCtx.setContainment(true);
        AnnotationUtil.addContextDefAnnotation((EModelElement)this.constraintRefWithOCLCtx, this.ctxTypeRef.getName());
    }

    public void testValidOCLConstraint() throws Exception {
        EObject constraintInstance = EcoreUtil.create((EClass)this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"eParameters->size() > 0");
        this.bindToNewContextInstance(constraintInstance);
        Diagnostic status = GMFValidator.validate((EObject)constraintInstance);
        MetaExpressionDefTestBase.assertEquals((int)0, (int)status.getSeverity());
    }

    public void testNoContextAvailable() throws Exception {
        EObject constraintInstance = EcoreUtil.create((EClass)this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"true");
        EObject owner = this.bindToNewContextInstance(constraintInstance);
        owner.eUnset(this.ctxClassRef);
        Diagnostic status = GMFValidator.validate((EObject)owner);
        MetaExpressionDefTestBase.assertEquals((int)4, (int)status.getSeverity());
        MetaExpressionDefTestBase.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.NO_VALUESPEC_CONTEXT_AVAILABLE);
    }

    public void testInvalidBody() throws Exception {
        EObject constraintInstance = EcoreUtil.create((EClass)this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"true...");
        this.bindToNewContextInstance(constraintInstance);
        Diagnostic status = GMFValidator.validate((EObject)this.bindToNewContextInstance(constraintInstance));
        MetaExpressionDefTestBase.assertEquals((int)4, (int)status.getSeverity());
        MetaExpressionDefTestBase.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.INVALID_CONSTRAINT_EXPRESSION);
    }

    public void testWrongContextTypeDef() throws Exception {
        this.ctxClassRef.setEType((EClassifier)this.containerClass);
        EObject constraintInstance = EcoreUtil.create((EClass)this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"true");
        EObject owner = this.bindToNewContextInstance(constraintInstance);
        Diagnostic status = GMFValidator.validate((EObject)owner);
        MetaExpressionDefTestBase.assertEquals((int)4, (int)status.getSeverity());
        MetaExpressionDefTestBase.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.NO_VALUESPEC_CONTEXT_AVAILABLE);
    }

    public void testRegExpLikeConstraint() throws Exception {
        this._testValidRegExpConstraint("regexp");
        this._testValidRegExpConstraint("nregexp");
    }

    private void _testValidRegExpConstraint(String regexpLang) throws Exception {
        EObject constraintInstance = EcoreUtil.create((EClass)this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)regexpLang);
        constraintInstance.eSet(this.bodyAttr, (Object)"[.]");
        EObject owner = this.bindToNewContextInstance(constraintInstance);
        Diagnostic status = GMFValidator.validate((EObject)owner);
        MetaExpressionDefTestBase.assertEquals((int)4, (int)status.getSeverity());
        MetaExpressionDefTestBase.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.INVALID_CONSTRAINT_EXPRESSION);
        EObject containerInstance = EcoreUtil.create((EClass)this.containerClass);
        containerInstance.eSet(this.ctxTypeRef, (Object)EcorePackage.eINSTANCE.getEString());
        containerInstance.eSet((EStructuralFeature)this.constraintRefWithOCLCtx, (Object)constraintInstance);
        status = GMFValidator.validate((EObject)containerInstance);
        MetaExpressionDefTestBase.assertEquals((int)0, (int)status.getSeverity());
    }

    public void testDefinitionInheritance() throws Exception {
        EClass intermConstraintSubClass = DynamicModelHelper.createMetaClass(this.constraintMetaClass.getEPackage());
        intermConstraintSubClass.getESuperTypes().add((Object)this.constraintMetaClass);
        EClass finalConstraintSubClass = DynamicModelHelper.createMetaClass(this.constraintMetaClass.getEPackage());
        finalConstraintSubClass.getESuperTypes().add((Object)intermConstraintSubClass);
        EObject constraintInstance = EcoreUtil.create((EClass)finalConstraintSubClass);
        EObject owner = this.bindToNewContextInstance(constraintInstance);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"true...");
        Diagnostic status = GMFValidator.validate((EObject)owner);
        MetaExpressionDefTestBase.assertEquals((int)4, (int)status.getSeverity());
        MetaExpressionDefTestBase.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.INVALID_CONSTRAINT_EXPRESSION);
        constraintInstance.eSet(this.bodyAttr, (Object)"true");
        status = GMFValidator.validate((EObject)owner);
        MetaExpressionDefTestBase.assertEquals((int)0, (int)status.getSeverity());
    }

    public void testMissingBodyAnnotation() throws Exception {
        this.bodyAttr.getEAnnotations().clear();
        EObject constraintInstance = EcoreUtil.create((EClass)this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        Diagnostic status = GMFValidator.validate((EObject)this.bindToNewContextInstance(constraintInstance));
        MetaExpressionDefTestBase.assertEquals((int)4, (int)status.getSeverity());
        MetaExpressionDefTestBase.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.MISSING_VALUESPEC_BODY_ANNOTATION);
    }

    protected EObject bindToNewContextInstance(EObject constraintInstance) {
        EObject ownerInstance = EcoreUtil.create((EClass)this.containerClass);
        ownerInstance.eSet(this.ctxClassRef, (Object)EcorePackage.eINSTANCE.getEOperation());
        ownerInstance.eSet((EStructuralFeature)this.constraintRefFeatureCtx, (Object)constraintInstance);
        return ownerInstance;
    }
}

