/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.io.IOException;
import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.mappings.AuditContainer;
import org.eclipse.gmf.mappings.AuditRule;
import org.eclipse.gmf.mappings.Auditable;
import org.eclipse.gmf.mappings.AuditedMetricTarget;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.Constraint;
import org.eclipse.gmf.mappings.DiagramElementTarget;
import org.eclipse.gmf.mappings.DomainAttributeTarget;
import org.eclipse.gmf.mappings.DomainElementTarget;
import org.eclipse.gmf.mappings.ElementInitializer;
import org.eclipse.gmf.mappings.FeatureSeqInitializer;
import org.eclipse.gmf.mappings.FeatureValueSpec;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.Language;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.Measurable;
import org.eclipse.gmf.mappings.MetricContainer;
import org.eclipse.gmf.mappings.MetricRule;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.Severity;
import org.eclipse.gmf.tests.EPath;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.DiaGenSetup;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.DomainModelFileSetup;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.MapSetup;
import org.eclipse.gmf.tests.setup.SessionSetup;
import org.eclipse.gmf.tests.setup.ToolDefSetup;
import org.eclipse.gmf.tests.setup.ToolDefSource;

public class LinksSessionSetup
extends SessionSetup {
    private static String modelURI = "/models/links/links.ecore";

    protected LinksSessionSetup() {
    }

    public static SessionSetup newInstance() {
        if (factoryClosed) {
            return null;
        }
        return new LinksSessionSetup();
    }

    protected DomainModelSource createDomainModel() {
        DomainModelFileSetup modelSetup = new DomainModelFileSetup(){

            public EClass getDiagramElement() {
                return (EClass)EPath.ECORE.lookup((EObject)this.getModel(), "Root");
            }

            public DomainModelSource.NodeData getNodeA() {
                EClass n = (EClass)EPath.ECORE.lookup((EObject)this.getModel(), "Container");
                EReference c = (EReference)EPath.ECORE.lookup((EObject)this.getModel(), "Root::elements");
                return new DomainModelSource.NodeData(n, null, c);
            }

            public DomainModelSource.NodeData getNodeB() {
                EClass n = (EClass)EPath.ECORE.lookup((EObject)this.getModel(), "Node");
                EReference c = (EReference)EPath.ECORE.lookup((EObject)this.getModel(), "Root::elements");
                return new DomainModelSource.NodeData(n, null, c);
            }

            public DomainModelSource.LinkData getLinkAsClass() {
                EClass l = (EClass)EPath.ECORE.lookup((EObject)this.getModel(), "Link");
                EReference t = (EReference)EPath.ECORE.lookup((EObject)this.getModel(), "Link::target");
                EReference c = (EReference)EPath.ECORE.lookup((EObject)this.getModel(), "Container::childNodes");
                return new DomainModelSource.LinkData(l, (EStructuralFeature)t, c);
            }

            public EReference getLinkAsRef() {
                return (EReference)EPath.ECORE.lookup((EObject)this.getModel(), "Container::referenceOnlyLink");
            }
        };
        try {
            modelSetup.init(Plugin.createURI(modelURI));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to setup the domain model. " + e.getLocalizedMessage()));
        }
        return modelSetup;
    }

    protected DiaGenSource createGenModel() {
        DiaGenSetup diaGenSetup = new DiaGenSetup().init(this.getMapModel());
        diaGenSetup.getGenDiagram().setValidationEnabled(true);
        diaGenSetup.getGenDiagram().setValidationDecorators(true);
        GenModel genModel = diaGenSetup.getGenDiagram().getDiagram().getDomainDiagramElement().getGenModel();
        Iterator it = genModel.getAllGenPackagesWithClassifiers().iterator();
        while (it.hasNext()) {
            GenPackage nextGenPackage = (GenPackage)it.next();
            if (nextGenPackage.getPrefix() != null && nextGenPackage.getPrefix().length() != 0) continue;
            StringBuffer buf = new StringBuffer(nextGenPackage.getPackageName());
            buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
            nextGenPackage.setPrefix(buf.toString());
        }
        return diaGenSetup;
    }

    protected MapDefSource createMapModel() {
        LinksMapSetup mapDefSource = new LinksMapSetup();
        return ((MapSetup)mapDefSource).init(new DiaDefSetup().init(), this.getDomainModel(), new ToolDefSetup());
    }

    private static final class LinksMapSetup
    extends MapSetup {
        private DomainModelSource domainSource;

        private LinksMapSetup() {
        }

        public MapSetup init(DiaDefSource ddSource, DomainModelSource domainSource, ToolDefSource toolDef) {
            this.domainSource = domainSource;
            super.init(ddSource, domainSource, toolDef);
            EClass invalidNodeMetaClass = (EClass)EPath.ECORE.lookup((EObject)domainSource.getModel(), "InvalidNode");
            this.createNodeMapping(ddSource.getNodeDef(), invalidNodeMetaClass, null, null, (EReference)EPath.findFeature((EObject)domainSource.getModel(), "Root::elements"), true);
            this.initMetricContainer(domainSource);
            this.initAudits();
            return this;
        }

        protected void setupNodeMapping(NodeMapping nme) {
            if ("Container".equals(nme.getDomainContext().getName())) {
                String[][] data = new String[][]{{"Container::enumAttr_Init", "TestEnum::LIT1"}, {"Container::manyEnumAttr_Init", "Sequence { TestEnum::LIT0, TestEnum::LIT1 }"}, {"Container::reference_Init", "Bag { self }"}, {"Container::manyRealAttr_Init", "Sequence { 1, 1.5 }"}};
                this.setupInitializers(nme, data);
                Constraint selector = GMFMapFactory.eINSTANCE.createConstraint();
                selector.setBody("true");
                nme.setDomainSpecialization(selector);
            } else if ("Node".equals(nme.getDomainContext().getName())) {
                String[][] data = new String[][]{{"Node::integers_Init", "Sequence { 10, 20 }"}, {"Node::name", "setNodeName", "java"}};
                this.setupInitializers(nme, data);
                this.createReusedChildNodes(nme, new String[]{"Node::nestedNodes1", "Node::nestedNodes2"});
            } else if ("InvalidNode".equals(nme.getDomainContext().getName())) {
                String[][] data = new String[][]{{"Node::name", "'\"Quated-name tests literal escaping\"'"}, {"Node::multiValPrimitive", "multiValPrimitive", "java"}, {"Node::multiValObj", "multiValObj", "java"}, {"Node::multiRef", "multiRef", "java"}, {"Node::singleValPrimitive", "singleValPrimitive", "java"}, {"Node::singleValObj", "singleValObj", "java"}, {"Node::singleRef", "singleRef", "java"}};
                this.setupInitializers(nme, data);
                Constraint selector = GMFMapFactory.eINSTANCE.createConstraint();
                selector.setLanguage(Language.JAVA_LITERAL);
                selector.setBody("myNodeSelector");
                nme.setDomainSpecialization(selector);
                this.createReusedChildNodes(nme, new String[]{"InvalidNode::nestedNodes1"});
            }
        }

        private void createReusedChildNodes(NodeMapping topNode, String[] containmentFeatures) {
            int i = 0;
            while (i < containmentFeatures.length) {
                ChildReference childRef = GMFMapFactory.eINSTANCE.createChildReference();
                childRef.setContainmentFeature((EReference)EPath.findFeature((EObject)this.domainSource.getModel(), containmentFeatures[i]));
                childRef.setReferencedChild(topNode);
                topNode.getChildren().add((Object)childRef);
                ++i;
            }
        }

        private void setupInitializers(NodeMapping nme, String[][] data) {
            FeatureSeqInitializer initializer = GMFMapFactory.eINSTANCE.createFeatureSeqInitializer();
            int i = 0;
            while (i < data.length) {
                FeatureValueSpec featureValueSpec = GMFMapFactory.eINSTANCE.createFeatureValueSpec();
                EStructuralFeature feature = (EStructuralFeature)EPath.ECORE.lookup((EObject)nme.getDomainContext().getEPackage(), data[i][0]);
                featureValueSpec.setFeature(feature);
                featureValueSpec.setBody(data[i][1]);
                if (data[i].length > 2) {
                    Language lang = Language.getByName((String)data[i][2]);
                    Assert.assertNotNull((String)("Could not find language enumerator for :" + data[i][2]), (Object)lang);
                    featureValueSpec.setLanguage(lang);
                }
                initializer.getInitializers().add((Object)featureValueSpec);
                ++i;
            }
            nme.setDomainInitializer((ElementInitializer)initializer);
        }

        protected void initAudits() {
            AuditContainer auditContainer = this.createAuditContainer(String.valueOf(Plugin.getPluginID()) + ".<category1>" + System.currentTimeMillis());
            this.getMapping().setAudits(auditContainer);
            DomainElementTarget classA = GMFMapFactory.eINSTANCE.createDomainElementTarget();
            classA.setElement(this.getNodeA().getDomainMetaElement());
            DomainElementTarget classB = GMFMapFactory.eINSTANCE.createDomainElementTarget();
            classB.setElement((EClass)EPath.ECORE.lookup((EObject)this.domainSource.getModel(), "nestedPckg::ClassA"));
            String constraintId1 = "<constraint.id1>";
            auditContainer.getAudits().add((Object)this.createAudit(constraintId1, "false", (Auditable)classA, Severity.WARNING_LITERAL, false));
            auditContainer.getAudits().add((Object)this.createAudit("constraint.id2", "false and nestedPckg::ClassA.allInstances()->size() > 0", (Auditable)classB, Severity.ERROR_LITERAL, true));
            AuditContainer subCat = this.createAuditContainer("category2");
            DiagramElementTarget nodeTarget = GMFMapFactory.eINSTANCE.createDiagramElementTarget();
            nodeTarget.setElement((MappingEntry)this.getNodeB());
            auditContainer.getChildContainers().add((Object)subCat);
            subCat.getAudits().add((Object)this.createAudit("constraint.id3", "''='Foo'", (Auditable)nodeTarget, Severity.INFO_LITERAL, false));
            AuditContainer attrAuditContainer = this.createAuditContainer("audit_container.attributeTarget");
            auditContainer.getChildContainers().add((Object)attrAuditContainer);
            DomainAttributeTarget attrTarget1 = GMFMapFactory.eINSTANCE.createDomainAttributeTarget();
            attrTarget1.setAttribute((EAttribute)EPath.ECORE.lookup((EObject)this.getMapping().getDiagram().getDomainModel(), "Node::name"));
            attrTarget1.setNullAsError(true);
            attrAuditContainer.getAudits().add((Object)this.createAudit("audit.attributeTarget.id1", "self = ''", (Auditable)attrTarget1, Severity.ERROR_LITERAL, false));
            DomainAttributeTarget attrTarget2 = GMFMapFactory.eINSTANCE.createDomainAttributeTarget();
            attrTarget2.setAttribute((EAttribute)EPath.ECORE.lookup((EObject)this.getMapping().getDiagram().getDomainModel(), "Node::acceptLinkKind"));
            attrTarget2.setNullAsError(false);
            AuditRule regexpRule = this.createAudit("audit.attributeTarget.id2", "a*b", (Auditable)attrTarget2, Severity.ERROR_LITERAL, false);
            regexpRule.getRule().setLanguage(Language.REGEXP_LITERAL);
            attrAuditContainer.getAudits().add((Object)regexpRule);
            DomainAttributeTarget attrTarget3 = GMFMapFactory.eINSTANCE.createDomainAttributeTarget();
            attrTarget3.setAttribute((EAttribute)EPath.ECORE.lookup((EObject)this.getMapping().getDiagram().getDomainModel(), "Node::acceptLinkKind"));
            AuditRule javaRule1 = this.createAudit("audit.attributeTarget.id3", "myJavaAudit1", (Auditable)attrTarget3, Severity.ERROR_LITERAL, false);
            javaRule1.getRule().setLanguage(Language.JAVA_LITERAL);
            attrAuditContainer.getAudits().add((Object)javaRule1);
            DomainAttributeTarget attrTarget4 = GMFMapFactory.eINSTANCE.createDomainAttributeTarget();
            attrTarget4.setAttribute((EAttribute)EPath.ECORE.lookup((EObject)this.getMapping().getDiagram().getDomainModel(), "Container::enumAttr_Init"));
            AuditRule javaRule2 = this.createAudit("audit.attributeTarget.id4", "myJavaAudit2", (Auditable)attrTarget4, Severity.ERROR_LITERAL, false);
            javaRule2.getRule().setLanguage(Language.JAVA_LITERAL);
            attrAuditContainer.getAudits().add((Object)javaRule2);
            DomainAttributeTarget attrTarget5 = GMFMapFactory.eINSTANCE.createDomainAttributeTarget();
            attrTarget5.setAttribute((EAttribute)EPath.ECORE.lookup((EObject)this.getMapping().getDiagram().getDomainModel(), "Node::multiValObj"));
            attrTarget5.setNullAsError(false);
            AuditRule nregexpRule = this.createAudit("audit.attributeTarget.nregexp.id", "a*b", (Auditable)attrTarget5, Severity.ERROR_LITERAL, false);
            nregexpRule.getRule().setLanguage(Language.NREGEXP_LITERAL);
            attrAuditContainer.getAudits().add((Object)nregexpRule);
            AuditedMetricTarget metricTarget = GMFMapFactory.eINSTANCE.createAuditedMetricTarget();
            Assert.assertTrue((String)"Requires at least one metric definition", (this.getMapping().getMetrics() != null && this.getMapping().getMetrics().getMetrics().size() > 0 ? 1 : 0) != 0);
            metricTarget.setMetric((MetricRule)this.getMapping().getMetrics().getMetrics().get(0));
            AuditRule metricAuditRule = this.createAudit("audit.metricTarget.id", "self > 0 and false", (Auditable)metricTarget, Severity.INFO_LITERAL, false);
            auditContainer.getAudits().add((Object)metricAuditRule);
        }

        protected void setupClassLinkMapping(LinkMapping lme) {
            this.addCreationConstraints(lme, null, "self.acceptLinkKind = oppositeEnd.acceptLinkKind");
        }

        protected void setupReferenceLinkMapping(LinkMapping lme) {
            this.addCreationConstraints(lme, "not self.acceptLinkKind.oclIsUndefined()", "self.acceptLinkKind = oppositeEnd.acceptLinkKind");
        }

        private void initMetricContainer(DomainModelSource domainModel) {
            MetricContainer container = GMFMapFactory.eINSTANCE.createMetricContainer();
            MetricRule domainElementRule = LinksMapSetup.createMetric("\"dom1\"", "1.2", null, null);
            DomainElementTarget domainElementTarget = GMFMapFactory.eINSTANCE.createDomainElementTarget();
            domainElementRule.setName(null);
            domainElementRule.setDescription(null);
            domainElementTarget.setElement(domainModel.getNodeA().getEClass());
            domainElementRule.setTarget((Measurable)domainElementTarget);
            container.getMetrics().add((Object)domainElementRule);
            MetricRule reusedDiagramElementRule = LinksMapSetup.createMetric("reused.node.mapping.diagramElement", "150", new Double(100.0), new Double(200.0));
            reusedDiagramElementRule.setDescription("A diagram metric with reused diagram element mapping");
            DiagramElementTarget reusedDiagramElementTarget = GMFMapFactory.eINSTANCE.createDiagramElementTarget();
            reusedDiagramElementTarget.setElement((MappingEntry)this.getNodeB());
            reusedDiagramElementRule.setTarget((Measurable)reusedDiagramElementTarget);
            container.getMetrics().add((Object)reusedDiagramElementRule);
            MetricRule diagramElementRule = LinksMapSetup.createMetric("node.mapping.diagramElement", "15", new Double(10.0), new Double(20.0));
            DiagramElementTarget diagramElementTarget = GMFMapFactory.eINSTANCE.createDiagramElementTarget();
            diagramElementTarget.setElement((MappingEntry)this.getNodeA());
            diagramElementRule.setTarget((Measurable)diagramElementTarget);
            container.getMetrics().add((Object)diagramElementRule);
            this.getMapping().setMetrics(container);
        }

        private static MetricRule createMetric(String key, String oclBody, Double low, Double high) {
            MetricRule rule = GMFMapFactory.eINSTANCE.createMetricRule();
            rule.setKey(key);
            rule.setName("Name of \"" + key + "\"");
            rule.setDescription("Description of \"" + key + "\"");
            rule.setRule(GMFMapFactory.eINSTANCE.createValueExpression());
            rule.getRule().setBody(oclBody);
            rule.setLowLimit(low);
            rule.setHighLimit(high);
            return rule;
        }
    }
}

