/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand.migration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import junit.framework.TestCase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.migration.MigrationException;
import org.eclipse.gmf.internal.xpand.migration.MigrationExecutionContext;
import org.eclipse.gmf.internal.xpand.migration.MigrationExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.migration.XtendMigrationFacade;
import org.eclipse.gmf.tests.xpand.TestsResourceManager;
import org.eclipse.gmf.tests.xpand.migration.testModel.MigrationTestsPackage;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;

public class XtendMigrationTest
extends TestCase {
    private static final String LF = System.getProperty("line.separator");
    private TestsResourceManager testResourceManager;

    protected void setUp() throws Exception {
        super.setUp();
        this.testResourceManager = new TestsResourceManager();
    }

    public void testPrimitiveTypeParameters() throws IOException, MigrationException, MdaException {
        String resourceName = "PrimitiveTypeParameters";
        String resourceContent = this.checkMigration(resourceName);
        this.checkQVTCompilation(resourceName, resourceContent);
    }

    public void testImportedModels() throws IOException, MigrationException {
        this.checkMigration("ImportedModels");
    }

    public void testImportedModelsWithUnusedImports() throws IOException, MigrationException {
        this.checkMigration(new XtendMigrationFacade((ResourceManager)this.testResourceManager, XtendMigrationTest.getResourceName("ImportedModels"), true), "ImportedModelsWithUnusedImports");
    }

    public void testImportedExtensions() throws IOException, MigrationException {
        this.checkMigration("ImportedExtensions");
    }

    public void testImportedExtensionsWReexport() throws IOException, MigrationException {
        this.checkMigration("ImportedExtensionsWReexport");
    }

    public void testFeatureCall() throws IOException, MigrationException {
        String resourceName = "FeatureCall";
        this.checkMigration(new XtendMigrationFacade((ResourceManager)this.testResourceManager, XtendMigrationTest.getResourceName(resourceName), (MigrationExecutionContext)new MigrationExecutionContextImpl((ResourceManager)this.testResourceManager, new EPackage[]{MigrationTestsPackage.eINSTANCE})), resourceName);
    }

    public void testOperationCall() throws IOException, MigrationException {
        String resourceName = "OperationCall";
        this.checkMigration(new XtendMigrationFacade((ResourceManager)this.testResourceManager, XtendMigrationTest.getResourceName(resourceName), (MigrationExecutionContext)new MigrationExecutionContextImpl((ResourceManager)this.testResourceManager, new EPackage[]{MigrationTestsPackage.eINSTANCE})), resourceName);
    }

    public void testCollectionOperations() throws IOException, MigrationException {
        this.checkMigration("OperationCall_CollectionOperations");
    }

    public void testCollectionOperationsAdd() throws IOException, MigrationException {
        this.checkMigration("OperationCall_CollectionOperations_Add");
    }

    public void testCollectionOperationsAddAll() throws IOException, MigrationException {
        this.checkMigration("OperationCall_CollectionOperations_AddAll");
    }

    public void testCollectionOperations_ToSet() throws IOException, MigrationException {
        String resourceName = "OperationCall_CollectionOperations_ToSet";
        this.checkMigration(new XtendMigrationFacade((ResourceManager)this.testResourceManager, XtendMigrationTest.getResourceName(resourceName), (MigrationExecutionContext)new MigrationExecutionContextImpl((ResourceManager)this.testResourceManager, new EPackage[]{GenModelPackage.eINSTANCE, MigrationTestsPackage.eINSTANCE})), resourceName);
    }

    public void testCollectionExpression() throws IOException, MigrationException {
        this.checkMigration("CollectionExpression");
    }

    public void testTypeSelect() throws IOException, MigrationException {
        this.checkMigration("TypeSelect");
    }

    public void testCast() throws IOException, MigrationException {
        this.checkMigration("Cast");
    }

    public void testBooleanOperation() throws IOException, MigrationException {
        this.checkMigration("BooleanOperation");
    }

    public void testChainExpression() throws IOException, MigrationException {
        this.checkMigration("ChainExpression");
    }

    public void testConstructorCallExpression() throws IOException, MigrationException {
        this.checkMigration("ConstructorCallExpression");
    }

    public void testIfExpression() throws IOException, MigrationException {
        this.checkMigration("IfExpression");
    }

    public void testLetExpression() throws IOException, MigrationException {
        this.checkMigration("LetExpression");
    }

    public void testListLiteral() throws IOException, MigrationException {
        this.checkMigration("ListLiteral");
    }

    public void testBooleanLiteral() throws IOException, MigrationException {
        this.checkMigration("BooleanLiteral");
    }

    public void testIntegerLiteral() throws IOException, MigrationException {
        this.checkMigration("IntegerLiteral");
    }

    public void testNullLiteral() throws IOException, MigrationException {
        this.checkMigration("NullLiteral");
    }

    public void testRealLiteral() throws IOException, MigrationException {
        this.checkMigration("RealLiteral");
    }

    public void testIteratorVariableUniqueness() throws IOException, MigrationException {
        this.checkMigration("IteratorVariableUniqueness");
    }

    public void testFixedProblems() throws IOException, MigrationException {
        this.checkMigration("FixedProblems");
    }

    public void testStringLiteral() throws IOException, MigrationException {
        String resourceName = "StringLiteral";
        XtendMigrationFacade migrationFacade = new XtendMigrationFacade((ResourceManager)this.testResourceManager, XtendMigrationTest.getResourceName(resourceName));
        String content = migrationFacade.migrateXtendResource().toString();
        XtendMigrationTest.assertTrue((content.length() > 0 ? 1 : 0) != 0);
        String etalon = this.readStringContent(new InputStreamReader(this.testResourceManager.loadFile(XtendMigrationTest.getResourceName(resourceName), "qvto"), Charset.forName("ISO-8859-1")));
        XtendMigrationTest.assertEquals((String)etalon, (String)content);
    }

    public void testStringOperations() throws IOException, MigrationException {
        this.checkMigration("OperationCall_StringOperations");
    }

    public void testOclAnyOperations() throws IOException, MigrationException {
        String resourceName = "OperationCall_OclAnyOperations";
        this.checkMigration(new XtendMigrationFacade((ResourceManager)this.testResourceManager, XtendMigrationTest.getResourceName(resourceName), true), resourceName);
    }

    public void testBooleanOperations() throws IOException, MigrationException {
        this.checkMigration("OperationCall_BooleanOperations");
    }

    public void testIntegerOperations() throws IOException, MigrationException {
        this.checkMigration("OperationCall_IntegerOperations");
    }

    public void testDoubleOperations() throws IOException, MigrationException {
        this.checkMigration("OperationCall_DoubleOperations");
    }

    public void testJavaExtensionsContainer() throws IOException, MigrationException {
        this.checkMigration("JavaExtensionsContainer");
    }

    public void testJavaExtensionsCaller() throws IOException, MigrationException {
        this.checkMigration("JavaExtensionsCaller");
    }

    public void testJavaExtensionClassBody() throws MigrationException, IOException {
        String fileName = "JavaExtensionsContainer";
        XtendMigrationFacade facade = new XtendMigrationFacade((ResourceManager)this.testResourceManager, XtendMigrationTest.getResourceName(fileName));
        facade.migrateXtendResource();
        XtendMigrationTest.assertNotNull((Object)facade.getNativeLibraryClassName());
        XtendMigrationTest.assertNotNull((Object)facade.getNativeLibraryPackageName());
        String classBody = facade.getNativeLibraryClassBody().toString();
        XtendMigrationTest.assertNotNull((Object)classBody);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.testResourceManager.loadFile(XtendMigrationTest.getResourceName(fileName), "java_"), Charset.forName("ISO-8859-1")));
        StringBuilder sb = new StringBuilder();
        String nextLine = reader.readLine();
        while (nextLine != null) {
            if (sb.length() > 0) {
                sb.append(LF);
            }
            sb.append(nextLine);
            nextLine = reader.readLine();
        }
        String etalon = XtendMigrationTest.normalize(sb.toString());
        classBody = XtendMigrationTest.normalize(classBody);
        XtendMigrationTest.assertEquals((String)etalon, (String)classBody);
    }

    public void testJavaExtensionXmlDeclaration() throws MigrationException, IOException {
        String fileName = "JavaExtensionsContainer";
        XtendMigrationFacade facade = new XtendMigrationFacade((ResourceManager)this.testResourceManager, XtendMigrationTest.getResourceName(fileName));
        facade.migrateXtendResource();
        String xmlDeclaration = facade.getNativeLibraryXmlDeclaration().toString();
        XtendMigrationTest.assertNotNull((Object)xmlDeclaration);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.testResourceManager.loadFile(XtendMigrationTest.getResourceName(fileName), "xml"), Charset.forName("ISO-8859-1")));
        StringBuilder sb = new StringBuilder();
        String nextLine = reader.readLine();
        while (nextLine != null) {
            if (sb.length() > 0) {
                sb.append(LF);
            }
            sb.append(nextLine);
            nextLine = reader.readLine();
        }
        String etalon = XtendMigrationTest.normalize(sb.toString());
        xmlDeclaration = XtendMigrationTest.normalize(xmlDeclaration);
        XtendMigrationTest.assertEquals((String)etalon, (String)xmlDeclaration);
    }

    public void testSwitchExpression() throws IOException, MigrationException {
        this.checkMigration("SwitchExpression");
    }

    public void testReturnCollectionTypeTransformation() throws IOException, MigrationException {
        String resourceName = "ReturnCollectionTypeTransformation";
        this.checkMigration(new XtendMigrationFacade((ResourceManager)this.testResourceManager, XtendMigrationTest.getResourceName(resourceName), (MigrationExecutionContext)new MigrationExecutionContextImpl((ResourceManager)this.testResourceManager, new EPackage[]{GenModelPackage.eINSTANCE, MigrationTestsPackage.eINSTANCE})), resourceName);
    }

    public void testInfixOperationsPrecenence() throws IOException, MigrationException {
        this.checkMigration("InfixOperationsPrecenence");
    }

    public void testWorkflowSlot() throws IOException, MigrationException {
        this.checkMigration("WorkflowSlot");
    }

    public void testInstanceOf() throws IOException, MigrationException {
        this.checkMigration("Instanceof");
    }

    private String readStringContent(InputStreamReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean isInString = false;
        boolean lastSymbolCR = false;
        char nextChar = (char)reader.read();
        while (nextChar != '\uffff') {
            switch (nextChar) {
                case '\r': {
                    if (!isInString) {
                        lastSymbolCR = true;
                        sb.append(LF);
                        break;
                    }
                }
                case '\n': {
                    if (!isInString && lastSymbolCR) {
                        lastSymbolCR = false;
                        break;
                    }
                }
                case '\'': {
                    isInString = !isInString;
                }
                default: {
                    if (lastSymbolCR) {
                        lastSymbolCR = false;
                    }
                    sb.append(nextChar);
                }
            }
            nextChar = (char)reader.read();
        }
        return sb.toString();
    }

    private String checkMigration(String xtendResourceName) throws IOException, MigrationException {
        return this.checkMigration(new XtendMigrationFacade((ResourceManager)this.testResourceManager, XtendMigrationTest.getResourceName(xtendResourceName)), xtendResourceName);
    }

    private String checkMigration(XtendMigrationFacade facade, String xtendResourceName) throws IOException, MigrationException {
        String content = facade.migrateXtendResource().toString();
        XtendMigrationTest.assertTrue((content.length() > 0 ? 1 : 0) != 0);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.testResourceManager.loadFile(XtendMigrationTest.getResourceName(xtendResourceName), "qvto"), Charset.forName("ISO-8859-1")));
        StringBuilder sb = new StringBuilder();
        String nextLine = reader.readLine();
        while (nextLine != null) {
            if (sb.length() > 0) {
                sb.append(LF);
            }
            sb.append(nextLine);
            nextLine = reader.readLine();
        }
        String etalon = XtendMigrationTest.normalize(sb.toString());
        content = XtendMigrationTest.normalize(content);
        XtendMigrationTest.assertEquals((String)etalon, (String)content);
        return content;
    }

    private void checkQVTCompilation(final String resourceName, final String resourceContent) throws MdaException, UnsupportedEncodingException {
        UnitResolver resolver = new UnitResolver(){

            public UnitProxy resolveUnit(String qualifiedName) {
                URI uri = URI.createURI((String)"platform:/plugin/foo").appendSegment(resourceName);
                return ResolverUtils.createUnitProxy((String)resourceName, (URI)uri, (String)resourceContent, (UnitResolver)this);
            }
        };
        QVTOCompiler qvtCompiler = new QVTOCompiler(resolver);
        QvtCompilerOptions options = new QvtCompilerOptions();
        options.setGenerateCompletionData(false);
        options.setShowAnnotations(false);
        CompiledUnit unit = qvtCompiler.compile(resourceName, options, null);
        XtendMigrationTest.assertTrue((unit.getErrors().size() == 0 ? 1 : 0) != 0);
    }

    private static String normalize(String text) {
        text = text.replaceAll(" +", " ");
        text = text.replaceAll(" +" + LF, LF);
        text = text.trim();
        return text;
    }

    private static String getResourceName(String shortName) {
        return "org::eclipse::gmf::tests::xpand::migration::" + shortName;
    }
}

