/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.clipboard.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardUtil;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupport;
import org.eclipse.gmf.tests.runtime.emf.clipboard.core.BaseClipboardTest;

public class RegressionTest
extends BaseClipboardTest {
    public RegressionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(RegressionTest.class, "Clipboard Regression Tests");
    }

    public void test_copyRoot_bugzilla107880() {
        if (this.writing()) {
            ArrayList<Library> objects = new ArrayList<Library>();
            objects.add(this.root1);
            String result = this.copy(objects, Collections.EMPTY_MAP);
            RegressionTest.assertNotNull((Object)result);
            RegressionTest.assertFalse((result.length() == 0 ? 1 : 0) != 0);
            int length = result.length();
            objects.add(this.root2);
            result = this.copy(objects, Collections.EMPTY_MAP);
            RegressionTest.assertNotNull((Object)result);
            RegressionTest.assertTrue((result.length() > length ? 1 : 0) != 0);
        }
    }

    public void test_copyPasteRoot_bugzilla107880() {
        if (this.writing()) {
            ArrayList<Library> objects = new ArrayList<Library>();
            RegressionTest.assertTrue((this.level12.getBranches().size() == 0 ? 1 : 0) != 0);
            objects.add(this.root3);
            String copyStr = this.copy(objects, Collections.EMPTY_MAP);
            RegressionTest.assertNotNull((Object)copyStr);
            RegressionTest.assertFalse((copyStr.length() == 0 ? 1 : 0) != 0);
            Collection eObjects = this.paste(copyStr, this.level12, Collections.EMPTY_MAP);
            RegressionTest.assertEquals((int)eObjects.size(), (int)objects.size());
            RegressionTest.assertTrue((this.level12.getBranches().size() == 1 ? 1 : 0) != 0);
        }
    }

    public void test_copyPasteRootToItself_bugzilla107880() {
        if (this.writing()) {
            ArrayList<Library> objects = new ArrayList<Library>();
            RegressionTest.assertEquals((int)this.root3.getBranches().size(), (int)0);
            objects.add(this.root3);
            String copyStr = this.copy(objects, Collections.EMPTY_MAP);
            RegressionTest.assertNotNull((Object)copyStr);
            RegressionTest.assertFalse((copyStr.length() == 0 ? 1 : 0) != 0);
            Collection eObjects = this.paste(copyStr, this.root3, Collections.EMPTY_MAP);
            RegressionTest.assertTrue((eObjects.size() == objects.size() ? 1 : 0) != 0);
            RegressionTest.assertTrue((this.root3.getBranches().size() == 1 ? 1 : 0) != 0);
        }
    }

    public void test_copyPasteMultipleRoots_bugzilla107880() {
        if (this.writing()) {
            ArrayList<Object> objects = new ArrayList<Object>();
            RegressionTest.assertTrue((this.root3.getBranches().size() == 0 ? 1 : 0) != 0);
            objects.add(this.root1);
            objects.add(this.level2writer);
            objects.add(this.level2book);
            objects.add(this.root3);
            String copyStr = this.copy(objects, Collections.EMPTY_MAP);
            RegressionTest.assertNotNull((Object)copyStr);
            RegressionTest.assertFalse((copyStr.length() == 0 ? 1 : 0) != 0);
            Collection eObjects = this.paste(copyStr, this.root3, Collections.EMPTY_MAP);
            RegressionTest.assertTrue((eObjects.size() == objects.size() ? 1 : 0) != 0);
            RegressionTest.assertTrue((this.root3.getWriters().size() == 1 ? 1 : 0) != 0);
            RegressionTest.assertTrue((this.root3.getBooks().size() == 1 ? 1 : 0) != 0);
            RegressionTest.assertTrue((this.root3.getBranches().size() == 2 ? 1 : 0) != 0);
        }
    }

    public void test_pasteRootToInvalidTarget_bugzilla107880() {
        if (this.writing()) {
            ArrayList<Library> objects = new ArrayList<Library>();
            objects.add(this.root3);
            String copyStr = this.copy(objects, Collections.EMPTY_MAP);
            RegressionTest.assertNotNull((Object)copyStr);
            RegressionTest.assertFalse((copyStr.length() == 0 ? 1 : 0) != 0);
            Collection eObjects = this.paste(copyStr, this.level1writer, Collections.EMPTY_MAP);
            RegressionTest.assertTrue((eObjects.size() == 0 ? 1 : 0) != 0);
        }
    }

    public void test_pasteToResource_bugzilla107880() {
        if (this.writing()) {
            ArrayList<Object> objects = new ArrayList<Object>();
            RegressionTest.assertTrue((this.testResource.getContents().size() == 3 ? 1 : 0) != 0);
            objects.add(this.root3);
            objects.add(this.level1book);
            String copyStr = this.copy(objects, Collections.EMPTY_MAP);
            RegressionTest.assertNotNull((Object)copyStr);
            RegressionTest.assertFalse((copyStr.length() == 0 ? 1 : 0) != 0);
            Collection eObjects = this.paste(copyStr, this.testResource, Collections.EMPTY_MAP);
            RegressionTest.assertEquals((int)eObjects.size(), (int)objects.size());
            RegressionTest.assertTrue((this.testResource.getContents().size() == 5 ? 1 : 0) != 0);
        }
    }

    public void test_pasteIntoNonContainmentFeature() {
        if (this.writing()) {
            ArrayList<Writer> objects = new ArrayList<Writer>();
            RegressionTest.assertNull((Object)this.level2book.getAuthor());
            objects.add(this.level2writer);
            String copyStr = this.copy(objects, Collections.EMPTY_MAP);
            RegressionTest.assertNotNull((Object)copyStr);
            RegressionTest.assertFalse((copyStr.length() == 0 ? 1 : 0) != 0);
            Collection eObjects = this.paste(copyStr, this.level2book, Collections.EMPTY_MAP);
            RegressionTest.assertTrue((eObjects.size() == 0 ? 1 : 0) != 0);
            RegressionTest.assertNull((Object)this.level2book.getAuthor());
        }
    }

    public void test_resolvingContainerFeature_129046() {
        if (this.writing()) {
            ArrayList<Library> objects = new ArrayList<Library>();
            Library level1a = EXTLibraryFactory.eINSTANCE.createLibrary();
            level1a.setName("level1a");
            this.level1.getBranches().add((Object)level1a);
            Library level1b = EXTLibraryFactory.eINSTANCE.createLibrary();
            level1b.setName("level1b");
            this.level1.getBranches().add((Object)level1b);
            Library level1c = EXTLibraryFactory.eINSTANCE.createLibrary();
            level1c.setName("level1c");
            this.level1.getBranches().add((Object)level1c);
            XMLResource xml = (XMLResource)this.testResource;
            if (xml.getID((EObject)level1a) == null) {
                xml.setID((EObject)level1a, EcoreUtil.generateUUID());
                xml.setID((EObject)level1b, EcoreUtil.generateUUID());
                xml.setID((EObject)level1c, EcoreUtil.generateUUID());
            }
            RegressionTest.assertSame((Object)this.level1, (Object)level1a.getParentBranch());
            RegressionTest.assertSame((Object)this.level1, (Object)level1b.getParentBranch());
            RegressionTest.assertSame((Object)this.level1, (Object)level1c.getParentBranch());
            objects.add(this.level1);
            String copyStr = this.copy(objects, Collections.EMPTY_MAP);
            RegressionTest.assertNotNull((Object)copyStr);
            RegressionTest.assertFalse((copyStr.length() == 0 ? 1 : 0) != 0);
            Collection eObjects = this.paste(copyStr, this.root3, Collections.EMPTY_MAP);
            RegressionTest.assertEquals((int)1, (int)eObjects.size());
            Object pasted = eObjects.iterator().next();
            RegressionTest.assertTrue((boolean)(pasted instanceof Library));
            Library pastedLibrary = (Library)pasted;
            RegressionTest.assertSame((Object)this.root3, (Object)pastedLibrary.getParentBranch());
            RegressionTest.assertEquals((int)4, (int)pastedLibrary.getBranches().size());
            RegressionTest.assertSame((Object)pastedLibrary, (Object)((Library)pastedLibrary.getBranches().get(0)).getParentBranch());
            RegressionTest.assertSame((Object)pastedLibrary, (Object)((Library)pastedLibrary.getBranches().get(1)).getParentBranch());
            RegressionTest.assertSame((Object)pastedLibrary, (Object)((Library)pastedLibrary.getBranches().get(2)).getParentBranch());
            RegressionTest.assertSame((Object)pastedLibrary, (Object)((Library)pastedLibrary.getBranches().get(3)).getParentBranch());
            RegressionTest.assertSame((Object)this.level1, (Object)level1a.getParentBranch());
            RegressionTest.assertSame((Object)this.level1, (Object)level1b.getParentBranch());
            RegressionTest.assertSame((Object)this.level1, (Object)level1c.getParentBranch());
        }
    }

    public void test_escapeURI_218307() {
        if (this.writing()) {
            ArrayList<Library> objects = new ArrayList<Library>();
            String name = "/clipboardTests/test&escapes.extlibrary";
            this.testResource.setURI(URI.createPlatformResourceURI((String)name, (boolean)true));
            RegressionTest.assertTrue((this.level12.getBranches().size() == 0 ? 1 : 0) != 0);
            objects.add(this.root3);
            String copyStr = this.copy(objects, Collections.EMPTY_MAP);
            RegressionTest.assertNotNull((Object)copyStr);
            RegressionTest.assertFalse((copyStr.length() == 0 ? 1 : 0) != 0);
            Collection eObjects = this.paste(copyStr, this.level12, Collections.EMPTY_MAP);
            RegressionTest.assertEquals((int)eObjects.size(), (int)objects.size());
            RegressionTest.assertTrue((this.level12.getBranches().size() == 1 ? 1 : 0) != 0);
        }
    }

    public void test_createClipboardSupportMethods() {
        if (this.writing()) {
            IClipboardSupport clipboardSupport = ClipboardUtil.createClipboardSupport((EClass)this.level12book.eClass());
            IClipboardSupport clipboardSupport2 = ClipboardUtil.createClipboardSupport((EObject)this.level12book);
            RegressionTest.assertEquals((Object)clipboardSupport, (Object)clipboardSupport2);
        }
    }
}

