/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.CircuitEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.LEDEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.LogicGateEditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.providers.GeoshapeType;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.DiagramNotationType;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.AbstractPresentationTestFixture;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class LogicCreationTests
extends AbstractTestBase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicCreationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite s = new TestSuite((Class)clazz);
        return s;
    }

    public LogicCreationTests() {
        super("Logic Shape Creation Test Suite");
    }

    protected void setTestFixture() {
        this.testFixture = new LogicTestFixture();
    }

    protected AbstractPresentationTestFixture getLogicTestFixture() {
        return (AbstractPresentationTestFixture)this.getTestFixture();
    }

    public void test_createLogicShapes() {
        Rectangle rect = new Rectangle(this.getDiagramEditPart().getFigure().getBounds());
        this.getDiagramEditPart().getFigure().translateToAbsolute((Translatable)rect);
        IElementType typeLED = ElementTypeRegistry.getInstance().getType("logic.led");
        IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
        IElementType typeAndGate = ElementTypeRegistry.getInstance().getType("logic.andgate");
        IElementType typeXorGate = ElementTypeRegistry.getInstance().getType("logic.xorgate");
        IElementType typeFlowContainer = ElementTypeRegistry.getInstance().getType("logic.flowcontainer");
        IElementType typeOrGate = ElementTypeRegistry.getInstance().getType("logic.orgate");
        Point createPt = new Point(100, 100);
        LEDEditPart ledEP = (LEDEditPart)this.getLogicTestFixture().createShapeUsingTool(typeLED, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(ledEP.getFigure().getSize().getExpanded(100, 100));
        CircuitEditPart circuitEP = (CircuitEditPart)this.getLogicTestFixture().createShapeUsingTool(typeCircuit, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(circuitEP.getFigure().getSize().getExpanded(100, 100));
        LogicGateEditPart andGateEP = (LogicGateEditPart)this.getLogicTestFixture().createShapeUsingTool(typeAndGate, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(andGateEP.getFigure().getSize().getExpanded(100, 100));
        LogicGateEditPart orGateEP = (LogicGateEditPart)this.getLogicTestFixture().createShapeUsingTool(typeOrGate, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(orGateEP.getFigure().getSize().getExpanded(100, 100));
        LogicGateEditPart xorGateEP = (LogicGateEditPart)this.getLogicTestFixture().createShapeUsingTool(typeXorGate, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(xorGateEP.getFigure().getSize().getExpanded(100, 100));
        this.getLogicTestFixture().createShapeUsingTool(typeFlowContainer, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
    }

    public void test_bugzilla124678() {
        final Command cc = this.getLongProgressCommand();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ((DiagramCommandStack)LogicCreationTests.this.getCommandStack()).execute(cc, monitor);
            }
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            LogicCreationTests.assertTrue((boolean)false);
        }
        catch (InterruptedException interruptedException) {
            LogicCreationTests.assertTrue((boolean)false);
        }
    }

    private Command getLongProgressCommand() {
        CompoundCommand cc = new CompoundCommand("Add Multiple Octagons");
        ArrayList<Object> newViews = new ArrayList<Object>();
        DiagramEditPart containerEditPart = this.getDiagramEditPart();
        int x = 0;
        while (x < 500) {
            int y = 0;
            while (y < 500) {
                CreateViewRequest createOctagon = CreateViewRequestFactory.getCreateShapeRequest((IElementType)GeoshapeType.OCTAGON, (PreferencesHint)PreferencesHint.USE_DEFAULTS);
                createOctagon.setLocation(new Point(x, y));
                Command createCmd = containerEditPart.getCommand((Request)createOctagon);
                cc.add(createCmd);
                Object obj = createOctagon.getNewObject();
                if (obj instanceof Collection) {
                    Iterator iter = ((Collection)obj).iterator();
                    while (iter.hasNext()) {
                        newViews.add(iter.next());
                    }
                } else {
                    newViews.add(createOctagon.getNewObject());
                }
                y += 55;
            }
            x += 55;
        }
        ArrangeRequest arrangeRequest = new ArrangeRequest("arrange_deferred");
        arrangeRequest.setViewAdaptersToArrange(newViews);
        Command arrangeCommand = containerEditPart.getCommand((Request)arrangeRequest);
        cc.add(arrangeCommand);
        return cc;
    }

    public void test_reorientingNoteAttachments() {
        IElementType typeLED = ElementTypeRegistry.getInstance().getType("logic.led");
        LEDEditPart led1 = (LEDEditPart)this.getLogicTestFixture().createShapeUsingTool(typeLED, new Point(100, 10), (IGraphicalEditPart)this.getDiagramEditPart());
        LEDEditPart led2 = (LEDEditPart)this.getLogicTestFixture().createShapeUsingTool(typeLED, new Point(200, 10), (IGraphicalEditPart)this.getDiagramEditPart());
        NoteEditPart note1 = (NoteEditPart)this.getLogicTestFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(100, 100), (IGraphicalEditPart)this.getDiagramEditPart());
        NoteEditPart note2 = (NoteEditPart)this.getLogicTestFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(200, 100), (IGraphicalEditPart)this.getDiagramEditPart());
        ConnectionEditPart noteAttachment = this.getLogicTestFixture().createConnectorUsingTool((IGraphicalEditPart)note1, (IGraphicalEditPart)led1, (IElementType)DiagramNotationType.NOTE_ATTACHMENT);
        this.reorientConnectionTarget((org.eclipse.gef.ConnectionEditPart)noteAttachment, (IGraphicalEditPart)led2, true);
        this.reorientConnectionSource((org.eclipse.gef.ConnectionEditPart)noteAttachment, (IGraphicalEditPart)note2, true);
        this.reorientConnectionSource((org.eclipse.gef.ConnectionEditPart)noteAttachment, (IGraphicalEditPart)led1, false);
        noteAttachment = this.getLogicTestFixture().createConnectorUsingTool((IGraphicalEditPart)led1, (IGraphicalEditPart)note1, (IElementType)DiagramNotationType.NOTE_ATTACHMENT);
        this.reorientConnectionSource((org.eclipse.gef.ConnectionEditPart)noteAttachment, (IGraphicalEditPart)led2, true);
        this.reorientConnectionTarget((org.eclipse.gef.ConnectionEditPart)noteAttachment, (IGraphicalEditPart)note2, true);
        this.reorientConnectionTarget((org.eclipse.gef.ConnectionEditPart)noteAttachment, (IGraphicalEditPart)led1, false);
    }
}

