/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.notation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class JumpLinkStatus
extends AbstractEnumerator {
    public static final int NONE = 0;
    public static final int ALL = 1;
    public static final int BELOW = 2;
    public static final int ABOVE = 3;
    public static final JumpLinkStatus NONE_LITERAL = new JumpLinkStatus(0, "None", "None");
    public static final JumpLinkStatus ALL_LITERAL = new JumpLinkStatus(1, "All", "All");
    public static final JumpLinkStatus BELOW_LITERAL = new JumpLinkStatus(2, "Below", "Below");
    public static final JumpLinkStatus ABOVE_LITERAL = new JumpLinkStatus(3, "Above", "Above");
    private static final JumpLinkStatus[] VALUES_ARRAY = new JumpLinkStatus[]{NONE_LITERAL, ALL_LITERAL, BELOW_LITERAL, ABOVE_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static JumpLinkStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JumpLinkStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JumpLinkStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JumpLinkStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JumpLinkStatus get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return ALL_LITERAL;
            }
            case 2: {
                return BELOW_LITERAL;
            }
            case 3: {
                return ABOVE_LITERAL;
            }
        }
        return null;
    }

    private JumpLinkStatus(int value, String name, String literal) {
        super(value, name, literal);
    }
}

