/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.notation.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.gmf.runtime.notation.Alignment;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.CanonicalStyle;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.DescriptionStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.DiagramStyle;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.Filtering;
import org.eclipse.gmf.runtime.notation.FilteringStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.Guide;
import org.eclipse.gmf.runtime.notation.GuideStyle;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Image;
import org.eclipse.gmf.runtime.notation.ImageBufferStyle;
import org.eclipse.gmf.runtime.notation.ImageStyle;
import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.JumpLinkType;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.PageStyle;
import org.eclipse.gmf.runtime.notation.Ratio;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.Smoothness;
import org.eclipse.gmf.runtime.notation.Sorting;
import org.eclipse.gmf.runtime.notation.SortingDirection;
import org.eclipse.gmf.runtime.notation.SortingStyle;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.gmf.runtime.notation.impl.BoundsImpl;
import org.eclipse.gmf.runtime.notation.impl.CanonicalStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.ConnectorStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.DescriptionStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.DiagramImpl;
import org.eclipse.gmf.runtime.notation.impl.DiagramStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.DrawerStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.EdgeImpl;
import org.eclipse.gmf.runtime.notation.impl.FillStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.FilteringStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.FontStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.GuideImpl;
import org.eclipse.gmf.runtime.notation.impl.GuideStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.IdentityAnchorImpl;
import org.eclipse.gmf.runtime.notation.impl.ImageBufferStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.ImageImpl;
import org.eclipse.gmf.runtime.notation.impl.ImageStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.LineStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.LocationImpl;
import org.eclipse.gmf.runtime.notation.impl.NodeEntryImpl;
import org.eclipse.gmf.runtime.notation.impl.NodeImpl;
import org.eclipse.gmf.runtime.notation.impl.PageStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.RatioImpl;
import org.eclipse.gmf.runtime.notation.impl.RelativeBendpointsImpl;
import org.eclipse.gmf.runtime.notation.impl.RoutingStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.ShapeStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.SizeImpl;
import org.eclipse.gmf.runtime.notation.impl.SortingStyleImpl;
import org.eclipse.gmf.runtime.notation.impl.TitleStyleImpl;

public class NotationFactoryImpl
extends EFactoryImpl
implements NotationFactory {
    public static NotationFactory init() {
        try {
            NotationFactory theNotationFactory = (NotationFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/gmf/runtime/1.0.0/notation");
            if (theNotationFactory != null) {
                return theNotationFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new NotationFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createEdge();
            }
            case 1: {
                return this.createNode();
            }
            case 3: {
                return this.createFillStyle();
            }
            case 4: {
                return this.createLineStyle();
            }
            case 5: {
                return this.createFontStyle();
            }
            case 6: {
                return this.createTitleStyle();
            }
            case 7: {
                return this.createSortingStyle();
            }
            case 8: {
                return this.createDescriptionStyle();
            }
            case 10: {
                return this.createSize();
            }
            case 11: {
                return this.createLocation();
            }
            case 12: {
                return this.createBounds();
            }
            case 13: {
                return this.createRatio();
            }
            case 16: {
                return this.createIdentityAnchor();
            }
            case 17: {
                return this.createRoutingStyle();
            }
            case 19: {
                return this.createRelativeBendpoints();
            }
            case 20: {
                return this.createDiagram();
            }
            case 21: {
                return this.createImage();
            }
            case 22: {
                return this.createCanonicalStyle();
            }
            case 23: {
                return this.createShapeStyle();
            }
            case 24: {
                return this.createConnectorStyle();
            }
            case 25: {
                return this.createPageStyle();
            }
            case 26: {
                return this.createDrawerStyle();
            }
            case 27: {
                return this.createGuideStyle();
            }
            case 28: {
                return this.createGuide();
            }
            case 29: {
                return (EObject)this.createNodeEntry();
            }
            case 30: {
                return this.createFilteringStyle();
            }
            case 31: {
                return this.createDiagramStyle();
            }
            case 32: {
                return this.createImageStyle();
            }
            case 33: {
                return this.createImageBufferStyle();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 34: {
                return this.createSortingFromString(eDataType, initialValue);
            }
            case 35: {
                return this.createFilteringFromString(eDataType, initialValue);
            }
            case 36: {
                return this.createRoutingFromString(eDataType, initialValue);
            }
            case 37: {
                return this.createSmoothnessFromString(eDataType, initialValue);
            }
            case 38: {
                return this.createJumpLinkStatusFromString(eDataType, initialValue);
            }
            case 39: {
                return this.createJumpLinkTypeFromString(eDataType, initialValue);
            }
            case 40: {
                return this.createAlignmentFromString(eDataType, initialValue);
            }
            case 41: {
                return this.createSortingDirectionFromString(eDataType, initialValue);
            }
            case 42: {
                return this.createMeasurementUnitFromString(eDataType, initialValue);
            }
            case 43: {
                return this.createRelativeBendpointListFromString(eDataType, initialValue);
            }
            case 44: {
                return this.createFilterKeyListFromString(eDataType, initialValue);
            }
            case 45: {
                return this.createSortKeyMapFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 34: {
                return this.convertSortingToString(eDataType, instanceValue);
            }
            case 35: {
                return this.convertFilteringToString(eDataType, instanceValue);
            }
            case 36: {
                return this.convertRoutingToString(eDataType, instanceValue);
            }
            case 37: {
                return this.convertSmoothnessToString(eDataType, instanceValue);
            }
            case 38: {
                return this.convertJumpLinkStatusToString(eDataType, instanceValue);
            }
            case 39: {
                return this.convertJumpLinkTypeToString(eDataType, instanceValue);
            }
            case 40: {
                return this.convertAlignmentToString(eDataType, instanceValue);
            }
            case 41: {
                return this.convertSortingDirectionToString(eDataType, instanceValue);
            }
            case 42: {
                return this.convertMeasurementUnitToString(eDataType, instanceValue);
            }
            case 43: {
                return this.convertRelativeBendpointListToString(eDataType, instanceValue);
            }
            case 44: {
                return this.convertFilterKeyListToString(eDataType, instanceValue);
            }
            case 45: {
                return this.convertSortKeyMapToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Edge createEdge() {
        EdgeImpl edge = new EdgeImpl();
        return edge;
    }

    public Node createNode() {
        NodeImpl node = new NodeImpl();
        return node;
    }

    public FillStyle createFillStyle() {
        FillStyleImpl fillStyle = new FillStyleImpl();
        return fillStyle;
    }

    public LineStyle createLineStyle() {
        LineStyleImpl lineStyle = new LineStyleImpl();
        return lineStyle;
    }

    public FontStyle createFontStyle() {
        FontStyleImpl fontStyle = new FontStyleImpl();
        return fontStyle;
    }

    public TitleStyle createTitleStyle() {
        TitleStyleImpl titleStyle = new TitleStyleImpl();
        return titleStyle;
    }

    public SortingStyle createSortingStyle() {
        SortingStyleImpl sortingStyle = new SortingStyleImpl();
        return sortingStyle;
    }

    public DescriptionStyle createDescriptionStyle() {
        DescriptionStyleImpl descriptionStyle = new DescriptionStyleImpl();
        return descriptionStyle;
    }

    public Size createSize() {
        SizeImpl size = new SizeImpl();
        return size;
    }

    public Location createLocation() {
        LocationImpl location = new LocationImpl();
        return location;
    }

    public Bounds createBounds() {
        BoundsImpl bounds = new BoundsImpl();
        return bounds;
    }

    public Ratio createRatio() {
        RatioImpl ratio = new RatioImpl();
        return ratio;
    }

    public IdentityAnchor createIdentityAnchor() {
        IdentityAnchorImpl identityAnchor = new IdentityAnchorImpl();
        return identityAnchor;
    }

    public RoutingStyle createRoutingStyle() {
        RoutingStyleImpl routingStyle = new RoutingStyleImpl();
        return routingStyle;
    }

    public RelativeBendpoints createRelativeBendpoints() {
        RelativeBendpointsImpl relativeBendpoints = new RelativeBendpointsImpl();
        return relativeBendpoints;
    }

    public CanonicalStyle createCanonicalStyle() {
        CanonicalStyleImpl canonicalStyle = new CanonicalStyleImpl();
        return canonicalStyle;
    }

    public ShapeStyle createShapeStyle() {
        ShapeStyleImpl shapeStyle = new ShapeStyleImpl();
        return shapeStyle;
    }

    public ConnectorStyle createConnectorStyle() {
        ConnectorStyleImpl connectorStyle = new ConnectorStyleImpl();
        return connectorStyle;
    }

    public Diagram createDiagram() {
        DiagramImpl diagram = new DiagramImpl();
        return diagram;
    }

    public Image createImage() {
        ImageImpl image = new ImageImpl();
        return image;
    }

    public PageStyle createPageStyle() {
        PageStyleImpl pageStyle = new PageStyleImpl();
        return pageStyle;
    }

    public DrawerStyle createDrawerStyle() {
        DrawerStyleImpl drawerStyle = new DrawerStyleImpl();
        return drawerStyle;
    }

    public GuideStyle createGuideStyle() {
        GuideStyleImpl guideStyle = new GuideStyleImpl();
        return guideStyle;
    }

    public Guide createGuide() {
        GuideImpl guide = new GuideImpl();
        return guide;
    }

    public Map.Entry createNodeEntry() {
        NodeEntryImpl nodeEntry = new NodeEntryImpl();
        return nodeEntry;
    }

    public FilteringStyle createFilteringStyle() {
        FilteringStyleImpl filteringStyle = new FilteringStyleImpl();
        return filteringStyle;
    }

    public DiagramStyle createDiagramStyle() {
        DiagramStyleImpl diagramStyle = new DiagramStyleImpl();
        return diagramStyle;
    }

    public ImageStyle createImageStyle() {
        ImageStyleImpl imageStyle = new ImageStyleImpl();
        return imageStyle;
    }

    public ImageBufferStyle createImageBufferStyle() {
        ImageBufferStyleImpl imageBufferStyle = new ImageBufferStyleImpl();
        return imageBufferStyle;
    }

    public Sorting createSortingFromString(EDataType eDataType, String initialValue) {
        Sorting result = Sorting.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSortingToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Filtering createFilteringFromString(EDataType eDataType, String initialValue) {
        Filtering result = Filtering.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFilteringToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Routing createRoutingFromString(EDataType eDataType, String initialValue) {
        Routing result = Routing.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRoutingToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Smoothness createSmoothnessFromString(EDataType eDataType, String initialValue) {
        Smoothness result = Smoothness.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSmoothnessToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public JumpLinkStatus createJumpLinkStatusFromString(EDataType eDataType, String initialValue) {
        JumpLinkStatus result = JumpLinkStatus.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertJumpLinkStatusToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public JumpLinkType createJumpLinkTypeFromString(EDataType eDataType, String initialValue) {
        JumpLinkType result = JumpLinkType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertJumpLinkTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Alignment createAlignmentFromString(EDataType eDataType, String initialValue) {
        Alignment result = Alignment.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertAlignmentToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public SortingDirection createSortingDirectionFromString(EDataType eDataType, String initialValue) {
        SortingDirection result = SortingDirection.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSortingDirectionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public MeasurementUnit createMeasurementUnitFromString(EDataType eDataType, String initialValue) {
        MeasurementUnit result = MeasurementUnit.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertMeasurementUnitToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public List createRelativeBendpointListFromString(EDataType eDataType, String initialValue) {
        StringTokenizer st = new StringTokenizer(initialValue, "$");
        ArrayList<RelativeBendpoint> newList = new ArrayList<RelativeBendpoint>(st.countTokens());
        while (st.hasMoreTokens()) {
            newList.add(new RelativeBendpoint(st.nextToken().trim()));
        }
        return newList;
    }

    public String convertRelativeBendpointListToString(EDataType eDataType, Object instanceValue) {
        StringBuffer sb = new StringBuffer();
        Iterator i = ((List)instanceValue).iterator();
        while (i.hasNext()) {
            RelativeBendpoint point = (RelativeBendpoint)i.next();
            if (sb.length() != 0) {
                sb.append('$');
            }
            sb.append(point.convertToString());
        }
        return sb.toString();
    }

    public List createFilterKeyListFromString(EDataType eDataType, String initialValue) {
        StringTokenizer st = new StringTokenizer(initialValue, ",");
        ArrayList<String> newList = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            newList.add(st.nextToken().trim());
        }
        return newList;
    }

    public String convertFilterKeyListToString(EDataType eDataType, Object instanceValue) {
        StringBuffer sb = new StringBuffer();
        Iterator i = ((List)instanceValue).iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(key);
        }
        return sb.toString();
    }

    public Map createSortKeyMapFromString(EDataType eDataType, String initialValue) {
        StringTokenizer st = new StringTokenizer(initialValue, ",");
        LinkedHashMap<String, SortingDirection> newMap = new LinkedHashMap<String, SortingDirection>(st.countTokens());
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            int i = s.indexOf(58);
            newMap.put(s.substring(0, i).trim(), SortingDirection.get(s.substring(i + 1).trim()));
        }
        return newMap;
    }

    public String convertSortKeyMapToString(EDataType eDataType, Object instanceValue) {
        StringBuffer sb = new StringBuffer();
        Map keyMap = (Map)instanceValue;
        Iterator i = keyMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            SortingDirection direction = (SortingDirection)((Object)keyMap.get(key));
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(String.valueOf(key) + ":" + direction.getName());
        }
        return sb.toString();
    }

    public NotationPackage getNotationPackage() {
        return (NotationPackage)this.getEPackage();
    }

    public static NotationPackage getPackage() {
        return NotationPackage.eINSTANCE;
    }
}

