/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.ruler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.DiagramGuide;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.DiagramRuler;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.commands.CreateGuideCommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.commands.DeleteGuideCommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.commands.MoveGuideCommand;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Guide;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramRulerProvider
extends RulerProvider {
    private NotificationListener rulerListener = new NotificationListener(){

        public void notifyChanged(Notification evt) {
            this.handleNotificationEvent(evt);
        }

        private void handleNotificationEvent(Notification event) {
            Object feature = event.getFeature();
            if (feature == NotationPackage.eINSTANCE.getGuideStyle_HorizontalGuides() && !DiagramRulerProvider.this.theRuler.isHorizontal() || feature == NotationPackage.eINSTANCE.getGuideStyle_VerticalGuides() && DiagramRulerProvider.this.theRuler.isHorizontal()) {
                Guide guide = null;
                if (event.getNewValue() != null && event.getOldValue() == null) {
                    guide = (Guide)event.getNewValue();
                    DiagramEventBroker.getInstance((TransactionalEditingDomain)DiagramRulerProvider.this.editingDomain).addNotificationListener((EObject)guide, DiagramRulerProvider.this.guideListener);
                }
                if (event.getNewValue() == null && event.getOldValue() != null) {
                    guide = (Guide)event.getOldValue();
                    DiagramEventBroker.getInstance((TransactionalEditingDomain)DiagramRulerProvider.this.editingDomain).removeNotificationListener((EObject)guide, DiagramRulerProvider.this.guideListener);
                }
                int i = 0;
                while (i < DiagramRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)DiagramRulerProvider.this.listeners.get(i)).notifyGuideReparented((Object)guide);
                    ++i;
                }
            }
        }
    };
    private NotificationListener guideListener = new NotificationListener(){

        public void notifyChanged(Notification evt) {
            this.handleNotificationEvent(evt);
        }

        private void handleNotificationEvent(Notification event) {
            int i;
            Object feature = event.getFeature();
            if (feature == NotationPackage.eINSTANCE.getGuide_Position()) {
                i = 0;
                while (i < DiagramRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)DiagramRulerProvider.this.listeners.get(i)).notifyGuideMoved(event.getNotifier());
                    ++i;
                }
            }
            if (feature == NotationPackage.eINSTANCE.getGuide_NodeMap()) {
                DiagramRulerProvider.this.refreshMap();
                i = 0;
                while (i < DiagramRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)DiagramRulerProvider.this.listeners.get(i)).notifyPartAttachmentChanged(event.getNewValue(), event.getNotifier());
                    ++i;
                }
            }
        }
    };
    private DiagramRuler theRuler;
    private IMapMode mm;
    private final TransactionalEditingDomain editingDomain;

    public DiagramRulerProvider(TransactionalEditingDomain editingDomain, DiagramRuler ruler, IMapMode mm) {
        this.theRuler = ruler;
        this.mm = mm;
        this.editingDomain = editingDomain;
    }

    private IMapMode getMapMode() {
        return this.mm;
    }

    public void init() {
        this.theRuler.addNotificationListener(this.editingDomain, this.rulerListener);
        Iterator iter = this.getGuides().iterator();
        while (iter.hasNext()) {
            Guide guide = (Guide)iter.next();
            DiagramEventBroker.getInstance((TransactionalEditingDomain)this.editingDomain).addNotificationListener((EObject)guide, this.guideListener);
        }
        this.refreshMap();
    }

    public void uninit() {
        this.theRuler.removeNotificationListener(this.editingDomain, this.rulerListener);
    }

    public Object getRuler() {
        return this.theRuler;
    }

    public List getAttachedModelObjects(Object guide) {
        Guide toGet = (Guide)guide;
        if (toGet.getNodeMap().size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Node> toReturn = new ArrayList<Node>();
        Iterator iter = toGet.getNodeMap().keySet().iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (node == null) continue;
            toReturn.add(node);
        }
        return toReturn;
    }

    public Command getCreateGuideCommand(int position) {
        return new ICommandProxy((ICommand)new CreateGuideCommand(this.editingDomain, this.theRuler, position));
    }

    public Command getDeleteGuideCommand(Object guide) {
        return new ICommandProxy((ICommand)new DeleteGuideCommand(this.editingDomain, (Guide)guide));
    }

    public Command getMoveGuideCommand(Object guide, int pDelta) {
        CompoundCommand cmd = new CompoundCommand(DiagramUIMessages.Command_moveGuide);
        cmd.add((Command)new ICommandProxy((ICommand)new MoveGuideCommand(this.editingDomain, (Guide)guide, pDelta)));
        Iterator iter = this.getAttachedModelObjects(guide).iterator();
        while (iter.hasNext()) {
            View part = (View)iter.next();
            int x = (Integer)ViewUtil.getStructuralFeatureValue((View)part, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            int y = (Integer)ViewUtil.getStructuralFeatureValue((View)part, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            SetPropertyCommand spc = ((DiagramRuler)this.getRuler()).isHorizontal() ? new SetPropertyCommand(this.editingDomain, (IAdaptable)new EObjectAdapter((EObject)part), Properties.ID_POSITIONX, Properties.ID_POSITIONX, (Object)new Integer(x += this.getMapMode().DPtoLP(pDelta))) : new SetPropertyCommand(this.editingDomain, (IAdaptable)new EObjectAdapter((EObject)part), Properties.ID_POSITIONY, Properties.ID_POSITIONY, (Object)new Integer(y += this.getMapMode().DPtoLP(pDelta)));
            cmd.add((Command)new ICommandProxy((ICommand)spc));
        }
        return cmd.unwrap();
    }

    public Object getGuideAt(int position) {
        List guides = this.getGuides();
        int i = 0;
        while (i < guides.size()) {
            Object guide = guides.get(i);
            if (position >= this.getGuidePosition(guide) - 2 && position <= this.getGuidePosition(guide) + 2) {
                return guide;
            }
            ++i;
        }
        return null;
    }

    public int[] getGuidePositions() {
        List guides = this.getGuides();
        int[] result = new int[guides.size()];
        int i = 0;
        while (i < guides.size()) {
            result[i] = ((Guide)guides.get(i)).getPosition();
            ++i;
        }
        return result;
    }

    public int getUnit() {
        return this.theRuler.getUnit();
    }

    public void setUnit(int newUnit) {
        this.theRuler.setUnit(newUnit);
    }

    public int getGuidePosition(Object guide) {
        return ((Guide)guide).getPosition();
    }

    public List getGuides() {
        return this.theRuler.getGuides();
    }

    public void refreshMap() {
        if (this.theRuler.isHorizontal()) {
            this.refreshVerticalGuideMap();
        } else {
            this.refreshHorizontalGuideMap();
        }
    }

    private void refreshHorizontalGuideMap() {
        List guideList = this.getGuides();
        List viewList = DiagramGuide.getInstance().getViews();
        Iterator iter = guideList.iterator();
        while (iter.hasNext()) {
            View view;
            Guide guide = (Guide)iter.next();
            List attachedViewsList = this.getAttachedModelObjects(guide);
            Iterator viewIter = attachedViewsList.iterator();
            while (viewIter.hasNext()) {
                view = (View)viewIter.next();
                if (viewList.contains(view)) {
                    viewList.remove(view);
                    continue;
                }
                DiagramGuide.getInstance().setHorizontalGuide(view, guide);
            }
            viewIter = viewList.iterator();
            while (viewIter.hasNext()) {
                view = (View)viewIter.next();
                DiagramGuide.getInstance().setHorizontalGuide(view, null);
            }
        }
    }

    private void refreshVerticalGuideMap() {
        List guideList = this.getGuides();
        List viewList = DiagramGuide.getInstance().getViews();
        Iterator iter = guideList.iterator();
        while (iter.hasNext()) {
            View view;
            Guide guide = (Guide)iter.next();
            List attachedViewsList = this.getAttachedModelObjects(guide);
            Iterator viewIter = attachedViewsList.iterator();
            while (viewIter.hasNext()) {
                view = (View)viewIter.next();
                if (viewList.contains(view)) {
                    viewList.remove(view);
                    continue;
                }
                DiagramGuide.getInstance().setVerticalGuide(view, guide);
            }
            viewIter = viewList.iterator();
            while (viewIter.hasNext()) {
                view = (View)viewIter.next();
                DiagramGuide.getInstance().setVerticalGuide(view, null);
            }
        }
    }
}

