/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DeselectAllTracker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ContainerEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ContainerNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.PopupBarEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ShapeCompartmentDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ISurfaceEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.DiagramLinkDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.RubberbandDragTracker;
import org.eclipse.gmf.runtime.diagram.ui.layout.FreeFormLayoutEx;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Display;

public abstract class ShapeCompartmentEditPart
extends ResizableCompartmentEditPart
implements ISurfaceEditPart,
PropertyChangeListener {
    private ConnectionRefreshMgr _crMgr;
    private boolean _refreshQueued = false;
    private boolean isSupportingViewActions = false;
    private EditPartListener editpartListener = new EditPartListener.Stub(){
        private FigureListener childFigureListener = new FigureListener(this){
            final /* synthetic */ 1 this$1;
            {
                this.this$1 = var1_1;
            }

            public void figureMoved(IFigure source) {
                1.access$0(this.this$1).refreshConnections();
            }
        };

        public void childAdded(EditPart child, int index) {
            ((GraphicalEditPart)child).getFigure().addFigureListener(this.childFigureListener);
        }

        public void removingChild(EditPart child, int index) {
            ((GraphicalEditPart)child).getFigure().removeFigureListener(this.childFigureListener);
        }

        static /* synthetic */ ShapeCompartmentEditPart access$0(1 var0) {
            return var0.ShapeCompartmentEditPart.this;
        }
    };
    static /* synthetic */ Class class$0;

    public ShapeCompartmentEditPart(View view) {
        super((EObject)view);
    }

    protected final ConnectionRefreshMgr getConnectionRefreshMgr() {
        if (this._crMgr == null) {
            this._crMgr = this.createConnectionRefreshMgr();
        }
        return this._crMgr;
    }

    protected ConnectionRefreshMgr createConnectionRefreshMgr() {
        return new ConnectionRefreshMgr();
    }

    protected LayoutManager getLayoutManager() {
        return new FreeFormLayoutEx();
    }

    protected IFigure createFigure() {
        ShapeCompartmentFigure scf = new ShapeCompartmentFigure(this.getCompartmentName(), this.getMapMode());
        scf.getContentPane().setLayoutManager(this.getLayoutManager());
        scf.getContentPane().addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        return scf;
    }

    public ShapeCompartmentFigure getShapeCompartmentFigure() {
        return (ShapeCompartmentFigure)this.getCompartmentFigure();
    }

    public IFigure getContentPane() {
        return this.getShapeCompartmentFigure().getContentPane();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new XYLayoutEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ContainerEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DiagramLinkDragDropEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ContainerNodeEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new ShapeCompartmentDropEditPolicy());
        this.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new PopupBarEditPolicy());
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        String pName = event.getPropertyName();
        if ("extent".equals(pName) || "value".equals(pName)) {
            this.refreshConnections();
        }
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getSize_Width().equals(feature) || NotationPackage.eINSTANCE.getSize_Height().equals(feature)) {
            this.refreshConnections();
        } else {
            super.handleNotificationEvent(event);
        }
        if (NotificationUtil.isElementAddedToSlot((Notification)event) || NotificationUtil.isElementRemovedFromSlot((Notification)event)) {
            this.refreshConnections();
        }
    }

    protected void refreshConnections() {
        if (!this._refreshQueued) {
            this._refreshQueued = true;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ShapeCompartmentEditPart.this.forceRefreshConnections();
                }
            });
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void forceRefreshConnections() {
        try {
            if (this.isActive()) {
                this.getConnectionRefreshMgr().refreshConnections(this);
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this._refreshQueued = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this._refreshQueued = false;
            return;
        }
    }

    protected void unregister() {
        super.unregister();
        this.getShapeCompartmentFigure().removePropertyChangeListener(this);
        EditPartViewer viewer = this.getViewer();
        if (viewer != null && viewer.getControl() instanceof FigureCanvas) {
            FigureCanvas figureCanvas = (FigureCanvas)viewer.getControl();
            figureCanvas.getViewport().getVerticalRangeModel().removePropertyChangeListener((PropertyChangeListener)this);
            figureCanvas.getViewport().getHorizontalRangeModel().removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected void registerVisuals() {
        super.registerVisuals();
        this.getShapeCompartmentFigure().addPropertyChangeListener(this);
        EditPartViewer viewer = this.getViewer();
        if (viewer != null && viewer.getControl() instanceof FigureCanvas) {
            FigureCanvas figureCanvas = (FigureCanvas)viewer.getControl();
            figureCanvas.getViewport().getVerticalRangeModel().addPropertyChangeListener((PropertyChangeListener)this);
            figureCanvas.getViewport().getHorizontalRangeModel().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected boolean supportsDragSelection() {
        return true;
    }

    public DragTracker getDragTracker(Request req) {
        if (!this.supportsDragSelection()) {
            return super.getDragTracker(req);
        }
        if (req instanceof SelectionRequest && ((SelectionRequest)req).getLastButtonPressed() == 3) {
            return new DeselectAllTracker((EditPart)this){

                protected boolean handleButtonDown(int button) {
                    this.getCurrentViewer().select((EditPart)ShapeCompartmentEditPart.this);
                    return true;
                }
            };
        }
        return new RubberbandDragTracker(){

            protected void handleFinished() {
                if (ShapeCompartmentEditPart.this.getViewer().getSelectedEditParts().isEmpty()) {
                    ShapeCompartmentEditPart.this.getViewer().select((EditPart)ShapeCompartmentEditPart.this);
                }
            }
        };
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.SnapToHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((org.eclipse.gef.GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((org.eclipse.gef.GraphicalEditPart)((GraphicalEditPart)this.getParent())));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(adapter);
    }

    protected void refreshVisibility() {
        super.refreshVisibility();
        View view = this.getNotationView();
        if (view != null && !view.isVisible()) {
            this.forceRefreshConnections();
        } else {
            this.refreshConnections();
        }
    }

    public boolean isSupportingViewActions() {
        return this.isSupportingViewActions;
    }

    public void setIsSupportingViewActions(boolean supportsViewActions) {
        this.isSupportingViewActions = supportsViewActions;
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if (this.isActive()) {
            this.handlePropertyChangeEvent(event);
        }
    }

    public List getPrimaryEditParts() {
        ArrayList<ConnectionEditPart> connections = new ArrayList<ConnectionEditPart>();
        Object diagramEditPart = this.getViewer().getEditPartRegistry().get(this.getDiagramView());
        List shapes = this.getChildren();
        HashSet connectableEditParts = new HashSet(shapes);
        Iterator iter = shapes.iterator();
        while (iter.hasNext()) {
            this.getBorderItemEditParts((EditPart)iter.next(), connectableEditParts);
        }
        if (diagramEditPart instanceof DiagramEditPart) {
            Iterator diagramConnections = ((DiagramEditPart)diagramEditPart).getConnections().iterator();
            while (diagramConnections.hasNext()) {
                ConnectionEditPart connection = (ConnectionEditPart)diagramConnections.next();
                if (!connectableEditParts.contains(connection.getSource()) && !connectableEditParts.contains(connection.getTarget())) continue;
                connections.add(connection);
            }
        }
        if (connections.size() > 0 || shapes.size() > 0) {
            ArrayList<ConnectionEditPart> primaryEditParts = new ArrayList<ConnectionEditPart>();
            primaryEditParts.addAll(shapes);
            primaryEditParts.addAll(connections);
            return primaryEditParts;
        }
        return Collections.EMPTY_LIST;
    }

    private void getBorderItemEditParts(EditPart parent, Set retval) {
        Iterator iter = parent.getChildren().iterator();
        while (iter.hasNext()) {
            EditPart child = (EditPart)iter.next();
            if (child instanceof IBorderItemEditPart) {
                retval.add(child);
                retval.addAll(child.getChildren());
            }
            this.getBorderItemEditParts(child, retval);
        }
    }

    public void addNotify() {
        this.addEditPartListener(this.editpartListener);
        super.addNotify();
    }

    public void removeNotify() {
        this.removeEditPartListener(this.editpartListener);
        super.removeNotify();
    }

    public static class ConnectionRefreshMgr {
        protected void refreshConnections(ShapeCompartmentEditPart scep) {
            Iterator connectionNodes = this.getConnectionNodes(scep).iterator();
            while (connectionNodes.hasNext()) {
                ShapeCompartmentFigure fig;
                ConnectionNodeEditPart cep = (ConnectionNodeEditPart)connectionNodes.next();
                Connection connection = (Connection)cep.getFigure();
                IGraphicalEditPart source = (IGraphicalEditPart)this.getSourceEditPart((ConnectionEditPart)cep);
                IGraphicalEditPart target = (IGraphicalEditPart)this.getTargetEditPart((ConnectionEditPart)cep);
                ShapeCompartmentEditPart sContainer = this.getOwningShapeCompartment((EditPart)source);
                ShapeCompartmentEditPart tContainer = this.getOwningShapeCompartment((EditPart)target);
                if (sContainer == null && tContainer == null) continue;
                boolean sfVisible = source != null;
                boolean tfVisible = target != null;
                ConnectionAnchor sc = cep.getSourceConnectionAnchor();
                ConnectionAnchor tc = cep.getTargetConnectionAnchor();
                Point sLoc = sc.getLocation(tc.getReferencePoint());
                Point tLoc = tc.getLocation(sc.getReferencePoint());
                Diagram diagram = ((View)scep.getModel()).getDiagram();
                Map registry = scep.getViewer().getEditPartRegistry();
                IGraphicalEditPart dep = (IGraphicalEditPart)registry.get(diagram);
                IFigure stopFigure = dep == null ? null : dep.getContentPane();
                boolean noSource = false;
                boolean noTarget = false;
                if (sContainer != null) {
                    fig = sContainer.getShapeCompartmentFigure();
                    noSource = !fig.isVisible();
                    sfVisible = this.isFigureVisible((IFigure)fig, sLoc, stopFigure);
                    if (!sfVisible) {
                        sfVisible = this.isBorderItem(sContainer, source);
                    }
                }
                if (tContainer != null) {
                    fig = tContainer.getShapeCompartmentFigure();
                    noTarget = !fig.isVisible();
                    tfVisible = this.isFigureVisible((IFigure)fig, tLoc, stopFigure);
                    if (!tfVisible) {
                        tfVisible = this.isBorderItem(tContainer, target);
                    }
                }
                if (noSource || noTarget) {
                    if (noSource && cep.getTarget() != null) {
                        cep.getTarget().refresh();
                    }
                    if (!noTarget || cep.getSource() == null) continue;
                    cep.getSource().refresh();
                    continue;
                }
                connection.setVisible(sfVisible && tfVisible);
                this.refreshConnectionEnds((ConnectionEditPart)cep);
            }
        }

        private void refreshConnectionEnds(ConnectionEditPart cEP) {
            EditPart srcEditPart = cEP.getSource();
            EditPart trgEditPart = cEP.getTarget();
            Object model = cEP.getModel();
            if (model instanceof Edge) {
                Edge edge = (Edge)model;
                View source = edge.getSource();
                View target = edge.getTarget();
                if (srcEditPart == null) {
                    this.refreshEditPart(cEP.getViewer(), source);
                }
                if (trgEditPart == null) {
                    this.refreshEditPart(cEP.getViewer(), target);
                }
            }
        }

        private void refreshEditPart(EditPartViewer viewer, View view) {
            EditPart ep = (EditPart)viewer.getEditPartRegistry().get(view);
            if (ep != null) {
                ep.refresh();
            }
        }

        protected Set getConnectionNodes(ShapeCompartmentEditPart scep) {
            HashSet endPoints = new HashSet();
            Object modelObject = scep.getModel();
            if (scep.getViewer() == null || modelObject == null || !(modelObject instanceof View)) {
                return endPoints;
            }
            if (((View)modelObject).getDiagram() == null) {
                return endPoints;
            }
            Diagram diagram = ((View)modelObject).getDiagram();
            Map registry = scep.getViewer().getEditPartRegistry();
            EList edges = diagram.getEdges();
            Iterator edgesIterator = edges.iterator();
            while (edgesIterator.hasNext()) {
                Object cep;
                Edge edge = (Edge)edgesIterator.next();
                EditPart endPoint = (EditPart)registry.get(edge.getSource());
                if (this.isChildOf((EditPart)scep, endPoint)) {
                    cep = registry.get(edge);
                    if (cep == null) continue;
                    endPoints.add(cep);
                    continue;
                }
                endPoint = (EditPart)registry.get(edge.getTarget());
                if (!this.isChildOf((EditPart)scep, endPoint) || (cep = registry.get(edge)) == null) continue;
                endPoints.add(cep);
            }
            return endPoints;
        }

        protected boolean isChildOf(EditPart parent, EditPart child) {
            EditPart walker = child;
            while (walker != null && walker != parent) {
                walker = walker.getParent();
            }
            return walker != null;
        }

        protected ShapeCompartmentEditPart getOwningShapeCompartment(EditPart ep) {
            EditPart walker = ep;
            while (walker != null && !(walker instanceof ShapeCompartmentEditPart)) {
                walker = walker.getParent();
            }
            return (ShapeCompartmentEditPart)walker;
        }

        protected boolean isBorderItem(ShapeCompartmentEditPart scep, IGraphicalEditPart itemEditPart) {
            return false;
        }

        protected EditPart getSourceEditPart(ConnectionEditPart connectionEditPart) {
            return connectionEditPart.getSource();
        }

        protected EditPart getTargetEditPart(ConnectionEditPart connectionEditPart) {
            return connectionEditPart.getTarget();
        }

        protected List getSourceConnections(IGraphicalEditPart editPart) {
            return editPart.getSourceConnections();
        }

        protected List getTargetConnections(IGraphicalEditPart editPart) {
            return editPart.getTargetConnections();
        }

        protected boolean isFigureVisible(IFigure figure, Point loc) {
            return this.isFigureVisible(figure, loc, null);
        }

        protected boolean isFigureVisible(IFigure figure, Point loc, IFigure stopFigure) {
            if (!figure.isVisible()) {
                return false;
            }
            Rectangle bounds = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)bounds);
            if (!bounds.contains(loc)) {
                return false;
            }
            IFigure parent = figure.getParent();
            if (parent != null && parent != stopFigure) {
                return this.isFigureVisible(parent, loc, stopFigure);
            }
            return true;
        }
    }
}

