/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.marker;

import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.internal.CommonUIServicesDebugOptions;
import org.eclipse.gmf.runtime.common.ui.services.internal.CommonUIServicesPlugin;
import org.eclipse.gmf.runtime.common.ui.services.internal.marker.IMarkerNavigationProvider;
import org.eclipse.gmf.runtime.common.ui.services.marker.GotoMarkerOperation;
import org.eclipse.ui.IEditorPart;

public class MarkerNavigationService
extends Service
implements IMarkerNavigationProvider {
    private static final MarkerNavigationService instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.services.marker.MarkerNavigationService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instance = new MarkerNavigationService();
        instance.configureProviders(CommonUIServicesPlugin.getPluginId(), "markerNavigationProviders");
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new MarkerNavigationProviderDescriptor(element);
    }

    protected MarkerNavigationService() {
        super(true);
    }

    public static MarkerNavigationService getInstance() {
        return instance;
    }

    private void execute(GotoMarkerOperation operation) {
        this.execute(ExecutionStrategy.FIRST, operation);
    }

    public void gotoMarker(IEditorPart editor, IMarker marker) {
        if (!$assertionsDisabled && editor == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && marker == null) {
            throw new AssertionError();
        }
        if (marker.exists()) {
            this.execute(new GotoMarkerOperation(editor, marker));
        }
    }

    protected static class MarkerNavigationProviderDescriptor
    extends Service.ProviderDescriptor {
        protected static final String A_NAME = "name";
        protected static final String E_MARKER_TYPE = "MarkerType";
        private Vector markerTypes = new Vector();

        protected MarkerNavigationProviderDescriptor(IConfigurationElement element) {
            super(element);
            IConfigurationElement[] elements = this.getElement().getChildren(E_MARKER_TYPE);
            int i = 0;
            while (i < elements.length) {
                String markerType = elements[i].getAttribute(A_NAME);
                if (markerType != null) {
                    this.markerTypes.add(markerType);
                }
                ++i;
            }
        }

        public boolean provides(IOperation operation) {
            boolean doesProvide = false;
            if (operation instanceof GotoMarkerOperation) {
                try {
                    String markerType = ((GotoMarkerOperation)operation).getMarker().getType();
                    if (this.markerTypes.contains(markerType)) {
                        doesProvide = super.provides(operation);
                    }
                }
                catch (Exception e) {
                    Trace.catching((Plugin)CommonUIServicesPlugin.getDefault(), (String)CommonUIServicesDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"provides", (Throwable)e);
                    Log.error((Plugin)CommonUIServicesPlugin.getDefault(), (int)1, (String)e.getLocalizedMessage(), (Throwable)e);
                    doesProvide = false;
                }
            }
            return doesProvide;
        }
    }
}

