/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.part;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gmf.map.editor.part.GMFMapCreationWizard;
import org.eclipse.gmf.map.editor.part.GMFMapDiagramFileCreator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class GMFMapCreationWizardPage
extends WizardNewFileCreationPage {
    private GMFMapDiagramFileCreator creator;

    public GMFMapCreationWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    protected String getDefaultFileName() {
        return "default";
    }

    public String getFileName() {
        String fileName = super.getFileName();
        if (fileName != null) {
            fileName = this.getDiagramFileCreator().appendExtensionToFileName(fileName);
        }
        return fileName;
    }

    public InputStream getInitialContents() {
        return new ByteArrayInputStream(new byte[0]);
    }

    public GMFMapDiagramFileCreator getDiagramFileCreator() {
        if (this.creator == null) {
            this.creator = new GMFMapDiagramFileCreator((GMFMapCreationWizard)this.getWizard());
        }
        return this.creator;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        IPath path = this.getContainerFullPath();
        if (path != null) {
            String fileName = this.getDiagramFileCreator().getUniqueFileName(path, this.getDefaultFileName());
            this.setFileName(fileName);
        }
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        if (super.validatePage()) {
            String fileName = this.getFileName();
            if (fileName == null) {
                return false;
            }
            IPath path = this.getContainerFullPath().append(this.getDiagramFileCreator().appendExtensionToFileName(fileName));
            if (GMFMapDiagramFileCreator.exists(path = path.removeFileExtension().addFileExtension("gmfmap"))) {
                this.setErrorMessage("Model file already exists: " + path.lastSegment());
                return false;
            }
            return true;
        }
        return false;
    }
}

