/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies;

import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.graphdef.editor.edit.policies.BorderLayoutEditPolicy;
import org.eclipse.gmf.graphdef.editor.edit.policies.GridLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.swt.graphics.Color;

public abstract class InnerFigureDragDropEditPolicy
extends DragDropEditPolicy {
    private static final Color GRAY = new Color(null, 200, 200, 200);
    private Integer alpha;

    public EditPart getTargetEditPart(Request request) {
        EditPolicy layoutEditPolicy;
        if (this.getHost().getParent() != null && ((layoutEditPolicy = this.getHost().getParent().getEditPolicy((Object)"LayoutEditPolicy")) instanceof BorderLayoutEditPolicy || layoutEditPolicy instanceof GridLayoutEditPolicy) && "drop".equals(request.getType()) && !this.isDeepInFigure((ChangeBoundsRequest)request)) {
            return null;
        }
        return super.getTargetEditPart(request);
    }

    private boolean isDeepInFigure(ChangeBoundsRequest request) {
        Point location = request.getLocation().getCopy();
        this.getActualFigure().translateToRelative((Translatable)location);
        Point figureCenter = this.getActualFigure().getBounds().getCenter();
        int dx = location.x - figureCenter.x;
        dx = (int)((double)Math.signum(dx) * Math.min(0.3 * (double)Math.abs(dx), 10.0));
        int dy = location.y - figureCenter.y;
        dy = (int)((double)Math.signum(dy) * Math.min(0.3 * (double)Math.abs(dy), 10.0));
        location.translate(dx, dy);
        return this.getActualFigure().containsPoint(location);
    }

    public void showTargetFeedback(Request request) {
        Command c = this.getCommand(request);
        if (c != null && c.canExecute() && this.revertColor == null) {
            this.revertColor = this.getActualFigure().getBackgroundColor();
            this.opacity = this.getActualFigure().isOpaque();
            this.alpha = this.getActualFigure().getAlpha();
            this.getActualFigure().setBackgroundColor(FigureUtilities.mixColors((Color)GRAY, (Color)this.revertColor));
            this.getActualFigure().setOpaque(true);
            this.getActualFigure().setAlpha(this.alpha == null ? 128 : this.alpha / 2);
        }
    }

    public void eraseTargetFeedback(Request request) {
        if (this.revertColor != null) {
            this.getActualFigure().setBackgroundColor(this.revertColor);
            this.getActualFigure().setOpaque(this.opacity);
            this.getActualFigure().setAlpha(this.alpha);
            this.revertColor = null;
        }
    }

    protected abstract Shape getActualFigure();
}

