/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.codegen;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.common.codegen.ImportAssistant;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.gmf.internal.xpand.BufferOutput;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.XpandFacade;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.util.ContextFactory;

public class XpandTextEmitter
implements TextEmitter {
    private final ResourceManager myResourceManager;
    private final String myTemplateFQN;
    private final ClassLoader myContext;

    public XpandTextEmitter(ResourceManager manager, String templateFQN, ClassLoader context) {
        assert (manager != null && templateFQN != null);
        this.myResourceManager = manager;
        this.myTemplateFQN = templateFQN;
        this.myContext = context;
    }

    public String generate(IProgressMonitor monitor, Object[] arguments) throws InterruptedException, InvocationTargetException {
        if (monitor != null && monitor.isCanceled()) {
            throw new InterruptedException();
        }
        try {
            StringBuilder result = new StringBuilder();
            new XpandFacade(this.createContext(result)).evaluate(this.myTemplateFQN, this.extractTarget(arguments), this.extractArguments(arguments));
            return result.toString();
        }
        catch (EvaluationException ex) {
            throw new InvocationTargetException(ex);
        }
    }

    protected Object extractTarget(Object[] arguments) {
        assert (arguments != null && arguments.length > 0);
        return arguments[0];
    }

    protected Object[] extractArguments(Object[] arguments) {
        assert (arguments != null && arguments.length > 0);
        ArrayList<Object> res = new ArrayList<Object>(arguments.length);
        int i = 1;
        while (i < arguments.length) {
            if (!(arguments[i] instanceof ImportAssistant)) {
                res.add(arguments[i]);
            }
            ++i;
        }
        return res.toArray();
    }

    private XpandExecutionContext createContext(StringBuilder result) {
        BufferOutput output = new BufferOutput(result);
        return ContextFactory.createXpandContext((ResourceManager)this.myResourceManager, (Output)output, (Collection)Collections.emptyList(), (ClassLoader)this.myContext);
    }
}

