/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import java.text.MessageFormat;
import junit.framework.TestCase;
import org.eclipse.gmf.internal.common.codegen.ManifestFileMerge;

public class ManifestMergeTest
extends TestCase {
    private final ManifestFileMerge manifestMerge = new ManifestFileMerge("\n");

    public ManifestMergeTest(String name) {
        super(name);
    }

    public void testHeaderOldOnly() {
        MessageFormat pattern = ManifestMergeTest.newPattern();
        String oldText = ManifestMergeTest.format(pattern, "Bundle-ClassPath: .\n");
        String newText = ManifestMergeTest.format(pattern, "");
        String result = this.manifestMerge.process(oldText, newText);
        ManifestMergeTest.assertEquals((String)oldText, (String)result);
    }

    public void testHeaderNewOnly() {
        MessageFormat pattern = ManifestMergeTest.newPattern();
        String oldText = ManifestMergeTest.format(pattern, "");
        String newText = ManifestMergeTest.format(pattern, "Bundle-ClassPath: .\n");
        String result = this.manifestMerge.process(oldText, newText);
        String expected = String.valueOf(oldText) + "Bundle-ClassPath: .\n";
        ManifestMergeTest.assertEquals((String)"New header should get inserted", (String)expected, (String)result);
        oldText = String.valueOf(oldText) + "GMF-IgnoreMerge: Bundle-ClassPath\n";
        result = this.manifestMerge.process(oldText, newText);
        ManifestMergeTest.assertEquals((String)"...unless it's explicitly ignored", (String)oldText, (String)result);
    }

    public void testPreserve() {
        MessageFormat pattern = ManifestMergeTest.newPattern();
        String oldText = ManifestMergeTest.format(pattern, "Bundle-ClassPath: bin/\n");
        String newText = ManifestMergeTest.format(pattern, "Bundle-ClassPath: .\n");
        oldText = String.valueOf(oldText) + "GMF-IgnoreMerge: Bundle-ClassPath\n";
        String result = this.manifestMerge.process(oldText, newText);
        ManifestMergeTest.assertEquals((String)oldText, (String)result);
    }

    public void testAppendMultivalued() {
        MessageFormat pattern = ManifestMergeTest.newPattern();
        String valueTail = ";directive:=one;attr=\"two\"";
        String oldText = ManifestMergeTest.format(pattern, "Bundle-ClassPath: bin/" + valueTail + ",\n runtime/\n");
        String newText = ManifestMergeTest.format(pattern, "Bundle-ClassPath: runtime/, out/" + valueTail + "\n");
        String expected = ManifestMergeTest.format(pattern, "Bundle-ClassPath: bin/" + valueTail + ",\n runtime/,\n out/" + valueTail + "\n");
        String result = this.manifestMerge.process(oldText, newText);
        ManifestMergeTest.assertEquals((String)expected, (String)result);
    }

    public void testPreserveMultivaluedAttributes() {
        MessageFormat pattern = ManifestMergeTest.newPattern();
        String valueTail = ";directive:=one;attr=\"two\"";
        String oldText = ManifestMergeTest.format(pattern, "Bundle-ClassPath: bin/" + valueTail + ",runtime/\n");
        String newText = ManifestMergeTest.format(pattern, "Bundle-ClassPath: bin/, runtime/\n");
        String result = this.manifestMerge.process(oldText, newText);
        ManifestMergeTest.assertEquals((String)oldText, (String)result);
    }

    public void testPreserveAttributeWithComma() {
        MessageFormat pattern = ManifestMergeTest.newPattern();
        String valueTail = ";attr=\"[1.0,2.0)\"";
        String oldText = ManifestMergeTest.format(pattern, "Bundle-ClassPath: bin/" + valueTail + ",runtime/\n");
        String newText = ManifestMergeTest.format(pattern, "Bundle-ClassPath: bin/, runtime/\n");
        String result = this.manifestMerge.process(oldText, newText);
        ManifestMergeTest.assertEquals((String)oldText, (String)result);
    }

    public void testOverwrite() {
        MessageFormat pattern = ManifestMergeTest.newPattern();
        String oldText = ManifestMergeTest.format(pattern, "Bundle-ClassPath: bin/\n");
        String newText = ManifestMergeTest.format(pattern, "Bundle-ClassPath: .\n");
        String result = this.manifestMerge.process(oldText, newText);
        ManifestMergeTest.assertEquals((String)newText, (String)result);
    }

    private static MessageFormat newPattern() {
        return new MessageFormat("Bundle-Name: %pluginName\n{0}Require-Bundle: org.eclipse.core.runtime,\n org.eclipse.core.resources;visibility:=reexport,\n org.eclipse.ui.views\n");
    }

    private static String format(MessageFormat pattern, String ... args) {
        return pattern.format(args);
    }
}

