/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.TextAlignmentAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.type.GeoshapeType;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.type.DiagramNotationType;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.TextAlignment;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.ITestActionCallback;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TextAlignmentTests
extends AbstractTestBase {
    protected ShapeEditPart noteEditPart;
    protected ShapeEditPart squareEditPart;
    protected View noteView;
    protected View squareView;

    public static Test suite() {
        TestSuite s = new TestSuite(TextAlignmentTests.class);
        return s;
    }

    public TextAlignmentTests() {
        super("Group Tests");
    }

    protected void setTestFixture() {
        this.testFixture = new TextAlignmentTestFixture();
    }

    protected LogicTestFixture getFixture() {
        return (LogicTestFixture)this.testFixture;
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void setupShapes() {
        this.squareEditPart = this.getFixture().createShapeUsingTool((IElementType)GeoshapeType.RECTANGLE, new Point(10, 10), new Dimension(-1, -1), (IGraphicalEditPart)this.getDiagramEditPart());
        this.squareView = (View)this.squareEditPart.getModel();
        this.testProperty(this.squareView, Properties.ID_DESCRIPTION, "Text align this text\nThe quick brown fox\njumps over\nthe lazy\ndog");
        this.noteEditPart = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(200, 200), new Dimension(-1, -1), (IGraphicalEditPart)this.getDiagramEditPart());
        this.noteView = (View)this.noteEditPart.getModel();
        this.testProperty(this.noteView, Properties.ID_DESCRIPTION, "Text align this text\nThe quick brown fox\njumps over\nthe lazy\ndog");
        this.flushEventQueue();
    }

    public void testSetTextAlignmentCenterAction() throws Exception {
        this.setupShapes();
        this.getDiagramEditPart().getViewer().setSelection((ISelection)new StructuredSelection((Object)this.squareEditPart));
        TextAlignmentAction action = TextAlignmentAction.createTextAlignmentCenterAction((IWorkbenchPage)this.getWorkbenchPage());
        this.testAction((IDisposableAction)action, new ITestActionCallback(){

            public void onRunExecution() {
                TextAlignmentTests.assertEquals((Object)TextAlignment.CENTER_LITERAL, (Object)TextAlignmentTests.this.squareEditPart.getStructuralFeatureValue((EStructuralFeature)PackageUtil.getElement((String)Properties.ID_TEXT_ALIGNMENT)));
            }
        });
        this.getCommandStack().undo();
        TextAlignmentTests.assertEquals((Object)TextAlignment.LEFT_LITERAL, (Object)this.squareEditPart.getStructuralFeatureValue((EStructuralFeature)PackageUtil.getElement((String)Properties.ID_TEXT_ALIGNMENT)));
    }

    public void testSetTextAlignmentRightAction() throws Exception {
        this.setupShapes();
        this.getDiagramEditPart().getViewer().setSelection((ISelection)new StructuredSelection((Object)this.noteEditPart));
        TextAlignmentAction action = TextAlignmentAction.createTextAlignmentRightAction((IWorkbenchPage)this.getWorkbenchPage());
        this.testAction((IDisposableAction)action, new ITestActionCallback(){

            public void onRunExecution() {
                TextAlignmentTests.assertEquals((Object)TextAlignment.RIGHT_LITERAL, (Object)TextAlignmentTests.this.noteEditPart.getStructuralFeatureValue((EStructuralFeature)PackageUtil.getElement((String)Properties.ID_TEXT_ALIGNMENT)));
            }
        });
        this.getCommandStack().undo();
        TextAlignmentTests.assertEquals((Object)TextAlignment.LEFT_LITERAL, (Object)this.noteEditPart.getStructuralFeatureValue((EStructuralFeature)PackageUtil.getElement((String)Properties.ID_TEXT_ALIGNMENT)));
    }

    public void testSetTextAlignmentProperty() throws Exception {
        this.setupShapes();
        this.testProperty(this.squareView, Properties.ID_TEXT_ALIGNMENT, TextAlignment.RIGHT_LITERAL);
        this.testProperty(this.squareView, Properties.ID_TEXT_ALIGNMENT, TextAlignment.CENTER_LITERAL);
        this.testProperty(this.squareView, Properties.ID_TEXT_ALIGNMENT, TextAlignment.LEFT_LITERAL);
        this.testProperty(this.noteView, Properties.ID_TEXT_ALIGNMENT, TextAlignment.RIGHT_LITERAL);
        this.testProperty(this.noteView, Properties.ID_TEXT_ALIGNMENT, TextAlignment.CENTER_LITERAL);
        this.testProperty(this.noteView, Properties.ID_TEXT_ALIGNMENT, TextAlignment.LEFT_LITERAL);
    }

    public class TextAlignmentTestFixture
    extends LogicTestFixture {
        public void setup() throws Exception {
            this.closeWelcome();
            super.setup();
        }

        public void closeWelcome() {
            IWorkbenchPartSite workbenchPartSite;
            IWorkbenchPart workbenchPart;
            IWorkbenchPage workbenchPage;
            IWorkbenchWindow workbenchWindow;
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (workbenchPage = workbenchWindow.getActivePage()) != null && (workbenchPart = workbenchPage.getActivePart()) != null && (workbenchPartSite = workbenchPart.getSite()) != null && workbenchPartSite.getId().equals("org.eclipse.ui.internal.introview")) {
                IViewPart welcomeView = (IViewPart)workbenchPart;
                workbenchPage.hideView(welcomeView);
            }
        }

        protected void createShapesAndConnectors() throws Exception {
        }
    }
}

