/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.internal.codegen.popup.actions.TransformToGenModelOperation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class TransformToGenModelAction
implements IObjectActionDelegate {
    private IWorkbenchPart myPart;
    private IFile mapFile;
    private IFile genFile;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mapFile = (IFile)((IStructuredSelection)selection).getFirstElement();
    }

    public void run(IAction action) {
        this.initDestinationFile();
        if (this.genFile == null) {
            return;
        }
        TransformToGenModelOperation op = new TransformToGenModelOperation();
        op.setName(action.getText());
        op.setShell(this.getShell());
        op.setMapModelURI(URI.createPlatformResourceURI((String)this.mapFile.getFullPath().toString(), (boolean)true));
        op.setGenModelURI(URI.createPlatformResourceURI((String)this.genFile.getFullPath().toString(), (boolean)true));
        if (Platform.getBundle((String)"org.eclipse.gmf.codegen.lite") == null) {
            op.setUseRuntimeFigures(true);
            op.setUseMapMode(true);
            op.setRCP(false);
        }
        op.run();
    }

    private void initDestinationFile() {
        this.genFile = null;
        IPath destPath = this.mapFile.getFullPath().removeFileExtension().addFileExtension("gmfgen");
        final IPath destLocation = destPath.removeLastSegments(1);
        String defFileName = destPath.lastSegment();
        InputDialog dlg = new InputDialog(this.getShell(), "Target model file", "Please specify name of the file to save diagram genmodel to", defFileName, new IInputValidator(){

            public String isValid(String newText) {
                IStatus s = ResourcesPlugin.getWorkspace().validatePath(destLocation.append(newText).toOSString(), 1);
                return s.isOK() ? null : s.getMessage();
            }
        });
        if (dlg.open() != 0) {
            return;
        }
        this.genFile = ResourcesPlugin.getWorkspace().getRoot().getFile(destLocation.append(dlg.getValue()));
    }

    public IFile getGenModelFile() {
        return this.genFile;
    }

    private Shell getShell() {
        return this.myPart.getSite().getShell();
    }
}

