/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.core.resources;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.gmf.runtime.emf.core.internal.util.Util;
import org.eclipse.gmf.runtime.emf.core.resources.GMFHelper;
import org.eclipse.gmf.runtime.emf.core.resources.GMFLoad;

public class GMFResource
extends XMIResourceImpl {
    public static final String OPTION_ABORT_ON_ERROR = "ABORT_ON_ERROR";
    private boolean useIDAttributes = false;

    public GMFResource(URI uri) {
        super(uri);
        this.setTrackingModification(true);
    }

    protected boolean useUUIDs() {
        return true;
    }

    public void setUseIDAttributes(boolean b) {
        this.useIDAttributes = b;
    }

    protected boolean useIDAttributes() {
        return this.useIDAttributes;
    }

    protected XMLHelper createXMLHelper() {
        return new GMFHelper((XMLResource)this);
    }

    protected XMLLoad createXMLLoad() {
        return new GMFLoad(this.createXMLHelper());
    }

    protected XMLSave createXMLSave() {
        return new XMISaveImpl(this.createXMLHelper());
    }

    public EObject getEObject(String uriFragment) {
        int index = uriFragment.indexOf(63);
        if (index != -1) {
            uriFragment = uriFragment.substring(0, index);
        }
        return super.getEObject(uriFragment);
    }

    public static String getSavedID(EObject eObject) {
        return (String)DETACHED_EOBJECT_TO_ID_MAP.get(eObject);
    }

    public void setURI(URI uri) {
        if (this.getResourceSet() != null) {
            this.setRawURI(Util.denormalizeURI(uri, this.getResourceSet()));
        }
    }

    public NotificationChain basicSetResourceSet(ResourceSet rset, NotificationChain notifications) {
        if (rset != null) {
            this.setURI(this.getURI());
        }
        return super.basicSetResourceSet(rset, notifications);
    }

    public void setRawURI(URI uri) {
        URI oldURI = this.getURI();
        if (uri == oldURI || uri != null && uri.equals((Object)oldURI)) {
            return;
        }
        super.setURI(uri);
    }

    protected Adapter createModificationTrackingAdapter() {
        return new ResourceImpl.ModificationTrackingAdapter((ResourceImpl)this){

            public void notifyChanged(Notification notification) {
                if (!GMFResource.this.isModified() && !this.isTransient(notification.getNotifier(), notification.getFeature())) {
                    super.notifyChanged(notification);
                }
            }

            private boolean isTransient(Object notifier, Object feature) {
                if (feature instanceof EStructuralFeature) {
                    if (((EStructuralFeature)feature).isTransient()) {
                        return true;
                    }
                    return this.isTransient((EObject)notifier);
                }
                return false;
            }

            private boolean isTransient(EObject eObject) {
                EReference containmentFeature = eObject.eContainmentFeature();
                while (containmentFeature != null) {
                    if (containmentFeature.isTransient()) {
                        return true;
                    }
                    if ((eObject = eObject.eContainer()) == null) break;
                    containmentFeature = eObject.eContainmentFeature();
                }
                return false;
            }
        };
    }
}

