/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.internal.bridge.resolver.ContainmentClosure;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Plugin
extends AbstractUIPlugin {
    public static final String CHECKED_ICON = "/icons/cview16/checked.gif";
    public static final String UNCHECKED_ICON = "/icons/cview16/unchecked.gif";
    public static final String GRAYED_ICON = "/icons/cview16/grayed.gif";
    public static final String NODE_ICON = "/icons/cview16/node.gif";
    public static final String LINK_ICON = "/icons/cview16/link.gif";
    public static final String LABEL_ICON = "/icons/cview16/label.gif";
    private static Plugin plugin;
    private ContainmentClosure myContainmentClosure;

    public Plugin() {
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.myContainmentClosure != null) {
            this.myContainmentClosure = null;
        }
        super.stop(context);
        plugin = null;
    }

    public ContainmentClosure getContaintmentClosure() {
        if (this.myContainmentClosure == null) {
            this.myContainmentClosure = new ContainmentClosure();
        }
        return this.myContainmentClosure;
    }

    public static IStatus createStatus(int statusCode, String message, Throwable ex) {
        return new Status(statusCode, Plugin.getPluginID(), 0, message, ex);
    }

    public static IStatus createError(String message, Throwable ex) {
        return Plugin.createStatus(4, message, ex);
    }

    public static IStatus createWarning(String message) {
        return Plugin.createStatus(2, message, null);
    }

    public static IStatus createInfo(String message) {
        return Plugin.createStatus(1, message, null);
    }

    public static IStatus createCancel(String message) {
        return Plugin.createStatus(8, message, null);
    }

    public static Plugin getDefault() {
        return plugin;
    }

    public static String getBundleString(String key) {
        return Platform.getResourceBundle((Bundle)Plugin.getDefault().getBundle()).getString(key);
    }

    public static String getBundleString(String key, Object[] args) {
        String val = Plugin.getBundleString(key);
        if (val == null) {
            return key;
        }
        return MessageFormat.format(val, args);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.loadImage(reg, CHECKED_ICON);
        this.loadImage(reg, UNCHECKED_ICON);
        this.loadImage(reg, GRAYED_ICON);
        this.loadImage(reg, NODE_ICON);
        this.loadImage(reg, LINK_ICON);
        this.loadImage(reg, LABEL_ICON);
    }

    protected void loadImage(ImageRegistry registry, String id) {
        this.loadImage(registry, id, this.getBundle().getSymbolicName());
    }

    protected void loadImage(ImageRegistry registry, String id, String bundleId) {
        ImageDescriptor descriptor = Plugin.imageDescriptorFromPlugin((String)bundleId, (String)id);
        if (descriptor != null) {
            registry.put(id, descriptor);
        }
    }

    public static void log(CoreException ex) {
        Plugin.log(ex.getStatus());
    }

    public static void log(Exception ex) {
        if (ex instanceof CoreException) {
            Plugin.log((CoreException)((Object)ex));
        } else {
            Plugin.log(Plugin.createError(ex.getMessage(), ex));
        }
    }

    public static String getPluginID() {
        return Plugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus s) {
        Plugin.getDefault().getLog().log(s);
    }

    public static boolean needsReconcile() {
        return !Boolean.FALSE.toString().equals(Platform.getDebugOption((String)(String.valueOf(Plugin.getPluginID()) + "/reconcile")));
    }

    public static boolean ignoreDanglingHrefOnSave() {
        String v = Platform.getDebugOption((String)(String.valueOf(Plugin.getPluginID()) + "/transform/ignore-dangling-on-save"));
        return v != null && !Boolean.FALSE.toString().equals(v);
    }

    public static boolean printTransformationConsole() {
        String v = Platform.getDebugOption((String)(String.valueOf(Plugin.getPluginID()) + "/transform/print-qvto-console"));
        return v != null && !Boolean.FALSE.toString().equals(v);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)Plugin.getPluginID(), (String)path);
    }
}

