/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.codegen.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.codegen.gmfgen.ElementType;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GMFGenPackage;
import org.eclipse.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.gmf.codegen.gmfgen.GenChildContainer;
import org.eclipse.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.gmf.codegen.gmfgen.GenCustomPropertyTab;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenLanguage;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.gmf.codegen.gmfgen.GenNavigatorChildReference;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenPropertyTab;
import org.eclipse.gmf.codegen.gmfgen.MetamodelType;
import org.eclipse.gmf.codegen.gmfgen.OpenDiagramBehaviour;
import org.eclipse.gmf.codegen.gmfgen.SpecializationType;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.codegen.util.CodegenEmitters;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.common.codegen.GeneratorBase;
import org.eclipse.gmf.internal.common.codegen.ImportUtil;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.gmf.internal.common.codegen.TextMerger;

public class Generator
extends GeneratorBase
implements Runnable {
    private final GenEditorGenerator myEditorGen;
    private final GenDiagram myDiagram;
    private final CodegenEmitters myEmitters;

    public Generator(GenEditorGenerator genModel, CodegenEmitters emitters) {
        assert (genModel != null && emitters != null);
        this.myEditorGen = genModel;
        this.myDiagram = genModel.getDiagram();
        this.myEmitters = emitters;
    }

    protected TextMerger createMergeService() {
        TextMerger service = this.myEmitters.createMergeService();
        if (service != null) {
            return service;
        }
        return super.createMergeService();
    }

    protected void customRun() throws InterruptedException, UnexpectedBehaviourException {
        String pluginID = this.myEditorGen.getPlugin().getID();
        this.initializeEditorProject(pluginID, this.guessProjectLocation(pluginID));
        this.generateExternalizationSupport();
        this.generateReorientConnectionViewCommand();
        this.generateBaseEditHelper();
        this.generateAbstractParser();
        this.generateStructuralFeatureParser();
        this.generateStructuralFeaturesParser();
        this.generateBaseItemSemanticEditPolicy();
        this.generateBehaviours(this.myDiagram);
        if (this.myDiagram.needsCanonicalEditPolicy()) {
            this.generateDiagramCanonicalEditPolicy();
        }
        this.generateDiagramItemSemanticEditPolicy();
        this.generateTextSelectionEditPolicy();
        this.generateTextNonResizableEditPolicy();
        for (GenNode node : this.myDiagram.getTopLevelNodes()) {
            this.generateNode(node);
        }
        for (GenNode node : this.myDiagram.getChildNodes()) {
            if (node instanceof GenChildLabelNode) {
                this.generateChildLabelNode((GenChildLabelNode)node);
                continue;
            }
            this.generateNode(node);
        }
        for (GenCompartment compartment : this.myDiagram.getCompartments()) {
            this.generateCompartmentEditPart(compartment);
            this.generateCompartmentItemSemanticEditPolicy(compartment);
            this.generateViewFactory(compartment);
            if (!compartment.needsCanonicalEditPolicy()) continue;
            this.generateChildContainerCanonicalEditPolicy(compartment);
        }
        for (GenLink next : this.myDiagram.getLinks()) {
            this.generateViewFactory(next);
            this.generateEditSupport(next);
            this.generateLinkEditPart(next);
            this.generateBehaviours(next);
            this.generateLinkItemSemanticEditPolicy(next);
            this.generateLinkCreateCommand(next);
            if (next.getModelFacet() instanceof TypeLinkModelFacet) {
                this.generateReorientLinkCommand(next);
            } else if (next.getModelFacet() instanceof FeatureLinkModelFacet) {
                this.generateReorientRefLinkCommand(next);
            }
            for (GenLinkLabel label : next.getLabels()) {
                this.generateLinkLabelEditPart(label);
                this.generateLinkLabelViewFactory(label);
            }
        }
        this.generateEditSupport(this.myDiagram);
        this.generateViewFactory(this.myDiagram);
        this.generateDiagramEditPart();
        this.generateEditPartFactory();
        this.generateElementInitializers();
        this.generateElementTypes();
        this.generateViewProvider();
        this.generateEditPartProvider();
        if (this.myEditorGen.getPlugin().isPrintingEnabled()) {
            this.generateContributionItemProvider();
        }
        this.generateModelingAssistantProvider();
        this.generateIconProvider();
        this.generateParserProvider();
        if (this.myDiagram.isValidationEnabled() || this.myEditorGen.hasAudits()) {
            this.generateValidationProvider();
            if (this.myDiagram.getEditorGen().getApplication() == null) {
                this.generateMarkerNavigationProvider();
                if (this.myDiagram.isValidationDecorators()) {
                    this.generateValidationDecoratorProvider();
                }
            }
        }
        if (this.myEditorGen.getMetrics() != null) {
            this.generateMetricProvider();
        }
        if (this.myEditorGen.getExpressionProviders() != null) {
            this.generateExpressionProviders();
        }
        this.generatePreferenceInitializer();
        this.generateAppearancePreferencePage();
        this.generateConnectionsPreferencePage();
        this.generateGeneralPreferencePage();
        this.generatePrintingPreferencePage();
        this.generateRulersAndGridPreferencePage();
        this.generatePalette();
        this.generateDiagramEditorUtil();
        this.generateVisualIDRegistry();
        this.generateCreationWizard();
        this.generateCreationWizardPage();
        this.generateEditor();
        this.generateDocumentProvider();
        this.generateLoadResourceAction();
        if (this.myDiagram.generateInitDiagramAction() || this.myDiagram.generateCreateShortcutAction()) {
            this.generateModelElementSelectionPage();
        }
        if (this.myDiagram.generateInitDiagramAction()) {
            this.generateInitDiagramFileAction();
            this.generateNewDiagramFileWizard();
        }
        if (this.myDiagram.generateCreateShortcutAction()) {
            this.generateCreateShortcutAction();
            this.generateCreateShortcutDecorationCommand();
            if (this.myEditorGen.getApplication() == null) {
                this.generateElementChooser();
            } else {
                this.generateShortcutCreationWizard();
            }
        }
        this.generateActionBarContributor();
        this.generateMatchingStrategy();
        if (this.myEditorGen.getNavigator() != null) {
            this.generateNavigatorContentProvider();
            this.generateNavigatorLabelProvider();
            this.generateNavigatorLinkHelper();
            this.generateNavigatorSorter();
            this.generateNavigatorActionProvider();
            this.generateAbstractNavigatorItem();
            this.generateNavigatorGroup();
            this.generateNavigatorItem();
            this.generateNavigatorGroupIcons();
            if (this.myEditorGen.getDomainGenModel() != null && this.myEditorGen.getNavigator().isGenerateDomainModelNavigator()) {
                this.generateDomainNavigatorContentProvider();
                this.generateDomainNavigatorLabelProvider();
                this.generateDomainNavigatorItem();
                this.generateDomainModelElementTester();
                this.generateURIEditorInputTester();
            }
        }
        if (this.myEditorGen.getPropertySheet() != null) {
            this.generatePropertySheetSections();
        }
        this.generatePluginClass();
        this.generateBundleManifest();
        this.generatePluginProperties();
        this.generateOptionsFile();
        this.generatePluginXml();
        this.generateBuildProperties();
        if (this.myDiagram.generateShortcutIcon()) {
            this.generateShortcutIcon();
            this.generateShortcutsDecoratorProvider();
            this.generateShortcutPropertyTester();
        }
        if (Generator.isPathInsideGenerationTarget(this.myDiagram.getCreationWizardIconPathX())) {
            this.generateDiagramIcon(this.myDiagram.getCreationWizardIconPathX());
        }
        if (Generator.isPathInsideGenerationTarget(this.myEditorGen.getEditor().getIconPathX())) {
            this.generateDiagramIcon(this.myEditorGen.getEditor().getIconPathX());
        }
        this.generateWizardBanner();
        this.generateApplication();
    }

    private static boolean isPathInsideGenerationTarget(String path) {
        assert (path != null);
        Path p = new Path(path);
        return !p.isAbsolute() && !p.segment(0).equals("..");
    }

    private void generateNode(GenNode node) throws UnexpectedBehaviourException, InterruptedException {
        this.generateViewFactory(node);
        this.generateNodeItemSemanticEditPolicy(node);
        this.generateNodeCreateCommand(node);
        this.generateEditSupport(node);
        this.generateNodeEditPart(node);
        this.generateBehaviours(node);
        if (node.needsCanonicalEditPolicy()) {
            this.generateChildContainerCanonicalEditPolicy(node);
        }
        if (node.getModelFacet() != null && !node.getReorientedIncomingLinks().isEmpty()) {
            this.generateNodeGraphicalNodeEditPolicy(node);
        }
        for (GenNodeLabel label : node.getLabels()) {
            if (label instanceof GenExternalNodeLabel) {
                GenExternalNodeLabel extLabel = (GenExternalNodeLabel)label;
                this.generateExternalNodeLabelEditPart(extLabel);
                this.generateExternalNodeLabelViewFactory(extLabel);
                continue;
            }
            this.generateNodeLabelEditPart(label);
            this.generateNodeLabelViewFactory(label);
        }
    }

    private void generateChildLabelNode(GenChildLabelNode child) throws UnexpectedBehaviourException, InterruptedException {
        this.generateViewFactory(child);
        this.generateNodeItemSemanticEditPolicy(child);
        this.generateNodeCreateCommand(child);
        this.generateEditSupport(child);
        this.generateChildNodeLabelEditPart(child);
    }

    private void generateReorientConnectionViewCommand() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getReorientConnectionViewCommandEmitter(), this.myDiagram.getEditCommandsPackageName(), this.myDiagram.getReorientConnectionViewCommandClassName(), this.myDiagram);
    }

    private void generateBaseEditHelper() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getBaseEditHelperEmitter(), this.myDiagram.getEditHelpersPackageName(), this.myDiagram.getBaseEditHelperClassName(), this.myDiagram);
    }

    private void generateEditSupport(GenCommonBase diagramElement) throws UnexpectedBehaviourException, InterruptedException {
        ElementType genType = diagramElement.getElementType();
        if (genType.isDefinedExternally()) {
            return;
        }
        if (genType instanceof SpecializationType) {
            this.generateEditHelperAdvice((SpecializationType)genType);
        } else if (genType instanceof MetamodelType) {
            this.generateEditHelper((MetamodelType)genType);
        }
    }

    private void generateEditHelper(MetamodelType genType) throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getEditHelperEmitter(), this.myDiagram.getEditHelpersPackageName(), genType.getEditHelperClassName(), genType);
    }

    private void generateEditHelperAdvice(SpecializationType genType) throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getEditHelperAdviceEmitter(), this.myDiagram.getEditHelpersPackageName(), genType.getEditHelperAdviceClassName(), genType);
    }

    private void generateDiagramEditPart() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDiagramEditPartEmitter(), this.myDiagram.getEditPartQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateNodeEditPart(GenNode node) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNodeEditPartEmitter(), node.getEditPartQualifiedClassName(), new Object[]{node});
    }

    private void generateNodeLabelEditPart(GenNodeLabel label) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNodeLabelEditPartEmitter(), label.getEditPartQualifiedClassName(), new Object[]{label});
    }

    private void generateExternalNodeLabelEditPart(GenExternalNodeLabel label) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getExternalNodeLabelEditPartEmitter(), label.getEditPartQualifiedClassName(), new Object[]{label});
    }

    private void generateChildNodeLabelEditPart(GenChildLabelNode node) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getChildNodeLabelEditPartEmitter(), node.getEditPartQualifiedClassName(), new Object[]{node});
    }

    private void generateCompartmentEditPart(GenCompartment compartment) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getCompartmentEditPartEmitter(), compartment.getEditPartQualifiedClassName(), new Object[]{compartment});
    }

    private void generateLinkEditPart(GenLink link) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLinkEditPartEmitter(), link.getEditPartQualifiedClassName(), new Object[]{link});
    }

    private void generateLinkLabelEditPart(GenLinkLabel label) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLinkLabelEditPartEmitter(), label.getEditPartQualifiedClassName(), new Object[]{label});
    }

    private void generateEditPartFactory() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getEditPartFactoryEmitter(), this.myDiagram.getEditPartFactoryQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateBaseItemSemanticEditPolicy() throws InterruptedException {
        ArrayList<GenContainerBase> allSemanticElements = new ArrayList<GenContainerBase>((Collection<GenContainerBase>)this.myDiagram.getAllContainers());
        allSemanticElements.addAll((Collection<GenContainerBase>)this.myDiagram.getLinks());
        boolean isSansDomainModel = true;
        Iterator it = allSemanticElements.iterator();
        while (it.hasNext() && isSansDomainModel) {
            GenCommonBase nextCommonBase = (GenCommonBase)it.next();
            if (nextCommonBase.isSansDomain()) continue;
            isSansDomainModel = false;
        }
        if (isSansDomainModel) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getBaseItemSemanticEditPolicyEmitter(), this.myDiagram.getBaseItemSemanticEditPolicyQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateBehaviours(GenCommonBase commonBase) throws UnexpectedBehaviourException, InterruptedException {
        for (OpenDiagramBehaviour behaviour : commonBase.getBehaviour(OpenDiagramBehaviour.class)) {
            if (behaviour.getSubject() != commonBase) continue;
            this.generateOpenDiagramEditPolicy(behaviour);
        }
    }

    private void generateOpenDiagramEditPolicy(OpenDiagramBehaviour behaviour) throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getOpenDiagramEditPolicyEmitter(), behaviour.getEditPolicyQualifiedClassName(), behaviour);
    }

    private void generateDiagramCanonicalEditPolicy() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getDiagramCanonicalEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), this.myDiagram.getCanonicalEditPolicyClassName(), this.myDiagram);
    }

    private void generateChildContainerCanonicalEditPolicy(GenChildContainer genContainer) throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getChildContainerCanonicalEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), genContainer.getCanonicalEditPolicyClassName(), genContainer);
    }

    private void generateDiagramItemSemanticEditPolicy() throws UnexpectedBehaviourException, InterruptedException {
        if (this.myDiagram.isSansDomain()) {
            return;
        }
        this.internalGenerateJavaClass(this.myEmitters.getDiagramItemSemanticEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), this.myDiagram.getItemSemanticEditPolicyClassName(), this.myDiagram);
    }

    private void generateCompartmentItemSemanticEditPolicy(GenCompartment genCompartment) throws UnexpectedBehaviourException, InterruptedException {
        if (genCompartment.isSansDomain()) {
            return;
        }
        this.internalGenerateJavaClass(this.myEmitters.getCompartmentItemSemanticEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), genCompartment.getItemSemanticEditPolicyClassName(), genCompartment);
    }

    private void generateNodeGraphicalNodeEditPolicy(GenNode genNode) throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getGraphicalNodeEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), genNode.getGraphicalNodeEditPolicyClassName(), genNode);
    }

    private void generateNodeItemSemanticEditPolicy(GenNode genNode) throws InterruptedException {
        if (genNode.isSansDomain()) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getNodeItemSemanticEditPolicyEmitter(), genNode.getItemSemanticEditPolicyQualifiedClassName(), new Object[]{genNode});
    }

    private void generateNodeCreateCommand(GenNode genNode) throws InterruptedException, UnexpectedBehaviourException {
        if (genNode.getModelFacet() == null) {
            return;
        }
        this.internalGenerateJavaClass(this.myEmitters.getNodeCreateCommandEmitter(), this.myDiagram.getEditCommandsPackageName(), genNode.getCreateCommandClassName(), genNode);
    }

    private void generateLinkItemSemanticEditPolicy(GenLink genLink) throws InterruptedException {
        if (genLink.isSansDomain()) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getLinkItemSemanticEditPolicyEmitter(), genLink.getItemSemanticEditPolicyQualifiedClassName(), new Object[]{genLink});
    }

    private void generateLinkCreateCommand(GenLink genLink) throws InterruptedException, UnexpectedBehaviourException {
        if (!(genLink.getModelFacet() instanceof TypeLinkModelFacet)) {
            return;
        }
        this.internalGenerateJavaClass(this.myEmitters.getCreateTypeLinkCommandEmitter(), this.myDiagram.getEditCommandsPackageName(), genLink.getCreateCommandClassName(), genLink);
    }

    private void generateReorientLinkCommand(GenLink link) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getReorientLinkCommandEmitter(), link.getReorientCommandQualifiedClassName(), new Object[]{link});
    }

    private void generateReorientRefLinkCommand(GenLink link) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getReorientRefLinkCommandEmitter(), link.getReorientCommandQualifiedClassName(), new Object[]{link});
    }

    private void generateTextSelectionEditPolicy() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getTextSelectionEditPolicyEmitter(), this.myDiagram.getTextSelectionEditPolicyQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateTextNonResizableEditPolicy() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getTextNonResizableEditPolicyEmitter(), this.myDiagram.getTextNonResizableEditPolicyQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generatePreferenceInitializer() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getPreferenceInitializerEmitter(), this.myEmitters.getPreferenceInitializerName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateAppearancePreferencePage() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getAppearancePreferencePageEmitter(), this.myEmitters.getAppearancePreferencePageName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateConnectionsPreferencePage() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getConnectionsPreferencePageEmitter(), this.myEmitters.getConnectionsPreferencePageName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateGeneralPreferencePage() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getGeneralPreferencePageEmitter(), this.myEmitters.getGeneralPreferencePageName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generatePrintingPreferencePage() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getPrintingPreferencePageEmitter(), this.myEmitters.getPrintingPreferencePageName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateRulersAndGridPreferencePage() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getRulersAndGridPreferencePageEmitter(), this.myEmitters.getRulersAndGridPreferencePageName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateAbstractParser() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getAbstractParserEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getAbstractParserClassName(), this.myDiagram);
    }

    private void generateStructuralFeatureParser() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getStructuralFeatureParserEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getStructuralFeatureParserClassName(), this.myDiagram);
    }

    private void generateStructuralFeaturesParser() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getStructuralFeaturesParserEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getStructuralFeaturesParserClassName(), this.myDiagram);
    }

    private void generateElementInitializers() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getElementInitializersEmitter(), this.myDiagram.getProvidersPackageName(), "ElementInitializers", this.myDiagram);
    }

    private void generateElementTypes() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getElementTypesEmitter(), this.myDiagram.getElementTypesQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateViewProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getViewProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getNotationViewProviderClassName(), this.myDiagram);
    }

    private void generateEditPartProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getEditPartProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getEditPartProviderClassName(), this.myDiagram);
    }

    private void generateContributionItemProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getContributionItemProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getContributionItemProviderClassName(), this.myDiagram);
    }

    private void generateModelingAssistantProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getModelingAssistantProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getModelingAssistantProviderClassName(), this.myDiagram);
    }

    private void generateIconProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getIconProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getIconProviderClassName(), this.myDiagram);
    }

    private void generateParserProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getParserProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getParserProviderClassName(), this.myDiagram);
    }

    private void generateValidationProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getValidationProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getValidationProviderClassName(), this.myDiagram);
    }

    private void generateValidationDecoratorProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getValidationDecoratorProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getValidationDecoratorProviderClassName(), this.myDiagram);
    }

    private void generateShortcutsDecoratorProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getShortcutsDecoratorProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getShortcutsDecoratorProviderClassName(), this.myDiagram);
    }

    private void generateShortcutPropertyTester() throws InterruptedException, UnexpectedBehaviourException {
        this.internalGenerateJavaClass(this.myEmitters.getShortcutPropertyTesterEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getShortcutPropertyTesterClassName(), this.myDiagram);
    }

    private void generateMetricProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getMetricProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getMetricProviderClassName(), this.myDiagram);
    }

    private void generateMarkerNavigationProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getMarkerNavigationProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getMarkerNavigationProviderClassName(), this.myDiagram);
    }

    private void generateViewFactory(GenCommonBase genElement) throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getViewFactoryEmitter(), this.myDiagram.getNotationViewFactoriesPackageName(), genElement.getNotationViewFactoryClassName(), genElement);
    }

    private void generateLinkLabelViewFactory(GenLinkLabel label) throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getLabelViewFactoryEmitter(), this.myDiagram.getNotationViewFactoriesPackageName(), label.getNotationViewFactoryClassName(), label);
    }

    private void generateExternalNodeLabelViewFactory(GenExternalNodeLabel label) throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getLabelViewFactoryEmitter(), this.myDiagram.getNotationViewFactoriesPackageName(), label.getNotationViewFactoryClassName(), label);
    }

    private void generateNodeLabelViewFactory(GenNodeLabel label) throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getLabelTextViewFactoryEmitter(), this.myDiagram.getNotationViewFactoriesPackageName(), label.getNotationViewFactoryClassName(), label);
    }

    private void generateModelElementSelectionPage() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getModelElementSelectionPageEmitter(), this.myEmitters.getModelElementSelectionPageName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateInitDiagramFileAction() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getInitDiagramFileActionEmitter(), this.myEmitters.getInitDiagramFileActionName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateNewDiagramFileWizard() throws UnexpectedBehaviourException, InterruptedException {
        if (!this.myDiagram.isSynchronized()) {
            this.internalGenerateJavaClass(this.myEmitters.getDiagramContentsInitializerEmitter(), this.myEditorGen.getEditor().getPackageName(), "DiagramContentsInitializer", this.myDiagram);
        }
        this.doGenerateJavaClass(this.myEmitters.getNewDiagramFileWizardEmitter(), this.myEmitters.getNewDiagramFileWizardName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generatePalette() throws UnexpectedBehaviourException, InterruptedException {
        if (this.myDiagram.getPalette() == null) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getPaletteEmitter(), this.myDiagram.getPalette().getFactoryQualifiedClassName(), new Object[]{this.myDiagram.getPalette()});
    }

    private void generateDiagramEditorUtil() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getDiagramEditorUtilEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getDiagramEditorUtilClassName(), this.myDiagram);
    }

    private void generateVisualIDRegistry() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getVisualIDRegistryEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getVisualIDRegistryClassName(), this.myDiagram);
    }

    private void generateCreationWizard() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getCreationWizardEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getCreationWizardClassName(), this.myDiagram);
    }

    private void generateCreationWizardPage() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getCreationWizardPageEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getCreationWizardPageClassName(), this.myDiagram);
    }

    private void generateEditor() throws UnexpectedBehaviourException, InterruptedException {
        GenEditorView editor = this.myEditorGen.getEditor();
        this.internalGenerateJavaClass(this.myEmitters.getEditorEmitter(), editor.getPackageName(), editor.getClassName(), editor);
    }

    private void generateCreateShortcutAction() throws UnexpectedBehaviourException, InterruptedException {
        if (!this.myDiagram.generateCreateShortcutAction()) {
            return;
        }
        this.internalGenerateJavaClass(this.myEmitters.getCreateShortcutActionEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getCreateShortcutActionClassName(), this.myDiagram);
    }

    private void generateCreateShortcutDecorationCommand() throws InterruptedException, UnexpectedBehaviourException {
        if (!this.myDiagram.generateCreateShortcutAction()) {
            return;
        }
        this.internalGenerateJavaClass(this.myEmitters.getCreateShortcutDecorationCommandEmitter(), this.myDiagram.getEditCommandsPackageName(), this.myDiagram.getCreateShortcutDecorationsCommandClassName(), this.myDiagram);
    }

    private void generateLoadResourceAction() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getLoadResourceActionEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getLoadResourceActionClassName(), this.myDiagram);
    }

    private void generateElementChooser() throws UnexpectedBehaviourException, InterruptedException {
        if (!this.myDiagram.generateCreateShortcutAction()) {
            return;
        }
        this.internalGenerateJavaClass(this.myEmitters.getElementChooserEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getElementChooserClassName(), this.myDiagram);
    }

    private void generateShortcutCreationWizard() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getShortcutCreationWizardEmitter(), this.myEmitters.getShortcutCreationWizardName(this.myDiagram), new Object[]{this.myDiagram});
    }

    private void generateDocumentProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDocumentProviderEmitter(), this.myDiagram.getDocumentProviderQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateActionBarContributor() throws UnexpectedBehaviourException, InterruptedException {
        GenEditorView editor = this.myEditorGen.getEditor();
        this.internalGenerateJavaClass(this.myEmitters.getActionBarContributorEmitter(), editor.getPackageName(), editor.getActionBarContributorClassName(), editor);
    }

    private void generateMatchingStrategy() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getMatchingStrategyEmitter(), this.myDiagram.getMatchingStrategyQualifiedClassName(), new Object[]{this.myDiagram});
    }

    private void generateNavigatorContentProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNavigatorContentProviderEmitter(), this.myEditorGen.getNavigator().getContentProviderQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateDomainNavigatorContentProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDomainNavigatorContentProviderEmitter(), this.myEditorGen.getNavigator().getDomainContentProviderQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateDomainNavigatorLabelProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDomainNavigatorLabelProviderEmitter(), this.myEditorGen.getNavigator().getDomainLabelProviderQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateDomainNavigatorItem() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDomainNavigatorItemEmitter(), this.myEditorGen.getNavigator().getDomainNavigatorItemQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateDomainModelElementTester() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDomainModelElementTesterEmitter(), this.myEditorGen.getNavigator().getDomainModelElementTesterQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateURIEditorInputTester() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getURIEditorInputTesterEmitter(), this.myEditorGen.getNavigator().getUriInputTesterQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorLabelProvider() throws InterruptedException, UnexpectedBehaviourException {
        this.internalGenerateJavaClass(this.myEmitters.getNavigatorLabelProviderEmitter(), this.myEditorGen.getNavigator().getPackageName(), this.myEditorGen.getNavigator().getLabelProviderClassName(), this.myEditorGen.getNavigator());
    }

    private void generateNavigatorLinkHelper() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNavigatorLinkHelperEmitter(), this.myEditorGen.getNavigator().getLinkHelperQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorSorter() throws InterruptedException, UnexpectedBehaviourException {
        this.internalGenerateJavaClass(this.myEmitters.getNavigatorSorterEmitter(), this.myEditorGen.getNavigator().getPackageName(), this.myEditorGen.getNavigator().getSorterClassName(), this.myEditorGen.getNavigator());
    }

    private void generateNavigatorActionProvider() throws InterruptedException, UnexpectedBehaviourException {
        this.internalGenerateJavaClass(this.myEmitters.getNavigatorActionProviderEmitter(), this.myEditorGen.getNavigator().getPackageName(), this.myEditorGen.getNavigator().getActionProviderClassName(), this.myEditorGen.getNavigator());
    }

    private void generateAbstractNavigatorItem() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getAbstractNavigatorItemEmitter(), this.myEditorGen.getNavigator().getAbstractNavigatorItemQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorGroup() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNavigatorGroupEmitter(), this.myEditorGen.getNavigator().getNavigatorGroupQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorItem() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNavigatorItemEmitter(), this.myEditorGen.getNavigator().getNavigatorItemQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorGroupIcons() throws InterruptedException, UnexpectedBehaviourException {
        HashSet<String> groupIcons = new HashSet<String>();
        for (GenNavigatorChildReference nextReference : this.myEditorGen.getNavigator().getChildReferences()) {
            if (nextReference.getGroupIcon() == null || nextReference.getGroupIcon().length() <= 0) continue;
            groupIcons.add(nextReference.getGroupIcon());
        }
        for (String iconPath : groupIcons) {
            this.generateGroupIcon(new Path(iconPath));
        }
    }

    private void generatePluginClass() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getPluginClassEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myEditorGen.getPlugin().getActivatorClassName(), this.myEditorGen.getPlugin());
    }

    protected void generatePropertySheetSections() throws UnexpectedBehaviourException, InterruptedException {
        if (this.myEditorGen.getPropertySheet().isNeedsCaption()) {
            this.internalGenerateJavaClass(this.myEmitters.getPropertySheetLabelProviderEmitter(), this.myEditorGen.getPropertySheet().getLabelProviderQualifiedClassName(), this.myEditorGen.getPropertySheet());
        }
        for (GenPropertyTab tab : this.myEditorGen.getPropertySheet().getTabs()) {
            if (!(tab instanceof GenCustomPropertyTab)) continue;
            this.internalGenerateJavaClass(this.myEmitters.getPropertySectionEmitter(), ((GenCustomPropertyTab)tab).getQualifiedClassName(), tab);
        }
    }

    private void generateExpressionProviders() throws UnexpectedBehaviourException, InterruptedException {
        GenExpressionProviderContainer providerContainer = this.myEditorGen.getExpressionProviders();
        this.internalGenerateJavaClass(this.myEmitters.getAbstractExpressionEmitter(), providerContainer.getExpressionsPackageName(), providerContainer.getAbstractExpressionClassName(), this.myDiagram);
        for (GenExpressionProviderBase nextProvider : providerContainer.getProviders()) {
            if (!(nextProvider instanceof GenExpressionInterpreter)) continue;
            TextEmitter providerEmitter = null;
            if (GenLanguage.OCL_LITERAL.equals((Object)nextProvider.getLanguage())) {
                providerEmitter = this.myEmitters.getOCLExpressionFactoryEmitter();
            } else if (GenLanguage.REGEXP_LITERAL.equals((Object)nextProvider.getLanguage()) || GenLanguage.NREGEXP_LITERAL.equals((Object)nextProvider.getLanguage())) {
                providerEmitter = this.myEmitters.getRegexpExpressionFactoryEmitter();
            }
            GenExpressionInterpreter interpreter = (GenExpressionInterpreter)nextProvider;
            if (providerEmitter == null) continue;
            this.internalGenerateJavaClass(providerEmitter, providerContainer.getExpressionsPackageName(), interpreter.getClassName(), interpreter);
        }
    }

    private void generatePluginXml() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateFile(this.myEmitters.getPluginXmlEmitter(), (IPath)new Path("plugin.xml"), new Object[]{this.myDiagram.getEditorGen().getPlugin()});
    }

    private void generatePluginProperties() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateFile(this.myEmitters.getPluginPropertiesEmitter(), (IPath)new Path("plugin.properties"), new Object[]{this.myDiagram.getEditorGen().getPlugin()});
    }

    private void generateOptionsFile() throws InterruptedException, UnexpectedBehaviourException {
        this.doGenerateFile(this.myEmitters.getOptionsFileEmitter(), (IPath)new Path(".options"), new Object[]{this.myDiagram.getEditorGen().getPlugin()});
    }

    private void generateBundleManifest() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateFile(this.myEmitters.getBundleManifestEmitter(), (IPath)new Path("META-INF/MANIFEST.MF"), new Object[]{this.myDiagram.getEditorGen().getPlugin()});
    }

    private void generateBuildProperties() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateFile(this.myEmitters.getBuildPropertiesEmitter(), (IPath)new Path("build.properties"), new Object[]{this.myDiagram});
    }

    private void generateShortcutIcon() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateBinaryFile(this.myEmitters.getShortcutImageEmitter(), new Path("icons/shortcut.gif"), null);
    }

    private void generateGroupIcon(Path groupIconPath) throws InterruptedException, UnexpectedBehaviourException {
        this.doGenerateBinaryFile(this.myEmitters.getGroupIconEmitter(), groupIconPath, null);
    }

    private void generateDiagramIcon(String path) throws UnexpectedBehaviourException, InterruptedException {
        Object[] args = new Object[]{this.myDiagram.getDomainDiagramElement() == null ? this.myEditorGen.getDiagramFileExtension() : this.myDiagram.getDomainDiagramElement().getGenPackage().getPrefix()};
        this.doGenerateBinaryFile(this.myEmitters.getDiagramIconEmitter(), new Path(path), args);
    }

    private void generateWizardBanner() throws UnexpectedBehaviourException, InterruptedException {
        String stem = this.myDiagram.getDomainDiagramElement() == null ? "" : this.myDiagram.getDomainDiagramElement().getGenPackage().getPrefix();
        Object[] args = new Object[]{stem.length() == 0 ? this.myEditorGen.getDiagramFileExtension() : stem};
        this.doGenerateBinaryFile(this.myEmitters.getWizardBannerImageEmitter(), new Path("icons/wizban/New" + stem + "Wizard.gif"), args);
    }

    private void generateApplication() throws UnexpectedBehaviourException, InterruptedException {
        GenApplication application = this.myEditorGen.getApplication();
        if (application != null) {
            this.generateApplication(application);
            this.generateActionBarAdvisor(application);
            this.generatePerspective(application);
            this.generateWorkbenchAdvisor(application);
            this.generateWorkbenchWindowAdvisor(application);
            this.generateWizardNewFileCreationPage(application);
        }
    }

    private void generateApplication(GenApplication application) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getApplicationEmitter(), application.getQualifiedClassName(), new Object[]{application});
    }

    private void generateActionBarAdvisor(GenApplication application) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getActionBarAdvisorEmitter(), application.getActionBarAdvisorQualifiedClassName(), new Object[]{application});
    }

    private void generatePerspective(GenApplication application) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getPerspectiveEmitter(), application.getPerspectiveQualifiedClassName(), new Object[]{application});
    }

    private void generateWorkbenchAdvisor(GenApplication application) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getWorkbenchAdvisorEmitter(), application.getWorkbenchAdvisorQualifiedClassName(), new Object[]{application});
    }

    private void generateWorkbenchWindowAdvisor(GenApplication application) throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getWorkbenchWindowAdvisorEmitter(), application.getWorkbenchWindowAdvisorQualifiedClassName(), new Object[]{application});
    }

    private void generateWizardNewFileCreationPage(GenApplication application) throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getWizardNewFileCreationPageEmitter(), application.getPackageName(), "WizardNewFileCreationPage", application);
    }

    private void generateExternalizationSupport() throws UnexpectedBehaviourException, InterruptedException {
        String packageName = this.myEditorGen.getEditor().getPackageName();
        String messagesClassName = "Messages";
        this.doGenerateJavaClass(this.myEmitters.getExternalizeEmitter(), packageName, messagesClassName, new Object[]{this.myEditorGen});
        this.doGenerateFile(this.myEmitters.getMessagesEmitter(), (IPath)new Path(String.valueOf(messagesClassName.toLowerCase()) + ".properties"), new Object[]{this.myEditorGen});
    }

    private void internalGenerateJavaClass(TextEmitter emitter, String packageName, String className, Object argument) throws InterruptedException {
        ImportUtil importUtil = new ImportUtil(packageName, className);
        this.doGenerateJavaClass(emitter, packageName, className, new Object[]{argument, importUtil});
    }

    private void internalGenerateJavaClass(TextEmitter emitter, String qualifiedName, Object argument) throws InterruptedException {
        this.internalGenerateJavaClass(emitter, CodeGenUtil.getPackageName((String)qualifiedName), CodeGenUtil.getSimpleClassName((String)qualifiedName), argument);
    }

    private IPath guessProjectLocation(String projectName) {
        if (this.myEditorGen.getDomainGenModel() == null) {
            return null;
        }
        Path modelProjectPath = new Path(this.myEditorGen.getDomainGenModel().getModelDirectory());
        return this.guessNewProjectLocation(modelProjectPath, projectName);
    }

    protected void setupProgressMonitor() {
        GeneratorBase.Counter c = new GeneratorBase.Counter();
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenNode(), 7);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenChildLabelNode(), 5);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenLink(), 6);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenLinkLabel(), 2);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenCompartment(), 4);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenDiagram(), 40);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenEditorGenerator(), 2);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenPlugin(), 6);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenNavigator(), 3);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenNavigatorChildReference(), 1);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenCustomPropertyTab(), 1);
        c.registerFactor(GMFGenPackage.eINSTANCE.getBehaviour(), 1);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenMetricContainer(), 1);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenExpressionProviderContainer(), 1);
        c.registerFactor(GMFGenPackage.eINSTANCE.getPalette(), 1);
        this.setupProgressMonitor(null, c.getTotal((EObject)this.myEditorGen));
    }
}

