/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.controller;

import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.IRecordController;
import org.eclipse.net4j.examples.mvc.ISequenceController;
import org.eclipse.net4j.examples.mvc.binding.EnablementViewBinding;
import org.eclipse.net4j.examples.mvc.binding.SelectionViewBinding;
import org.eclipse.net4j.examples.mvc.binding.SequenceModelBinding;
import org.eclipse.net4j.examples.mvc.controller.Controller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSequenceController<SEQUENCE_TARGET, RECORD_TARGET, VIEW_TARGET>
extends Controller<Object>
implements ISequenceController<SEQUENCE_TARGET, RECORD_TARGET, VIEW_TARGET> {
    public static final String SEQUENCE_TARGET_NAME = "sequence";
    private int currentIndex = -1;
    private boolean transientCreation;
    private SequenceModelBinding<SEQUENCE_TARGET> sequenceModelBinding;
    private IRecordController<RECORD_TARGET, VIEW_TARGET> recordController;
    private SelectionViewBinding<VIEW_TARGET> newSelectionBinding;
    private EnablementViewBinding<VIEW_TARGET> deleteEnablementBinding;
    private SelectionViewBinding<VIEW_TARGET> deleteSelectionBinding;

    public AbstractSequenceController(IAdapter.Manager<Object> adapterManager, String name, String sequenceModelTargetName, IRecordController<RECORD_TARGET, VIEW_TARGET> recordController) {
        super(adapterManager, name);
        this.recordController = recordController;
        this.sequenceModelBinding = new SequenceModelBinding(this, sequenceModelTargetName){

            public void onAdd(int index, Object item) {
                AbstractSequenceController.this.onModelAdd(index, item);
            }

            public void onMove(int fromIndex, int toIndex) {
                AbstractSequenceController.this.onModelMove(fromIndex, toIndex);
            }

            public void onRemove(int index, Object item) {
                AbstractSequenceController.this.onModelRemove(index, item);
            }

            public void onSet(int index, Object newItem, Object oldItem) {
                AbstractSequenceController.this.onModelSet(index, newItem, oldItem);
            }
        };
    }

    @Override
    public EnablementViewBinding<VIEW_TARGET> getDeleteEnablementBinding() {
        return this.deleteEnablementBinding;
    }

    @Override
    public SelectionViewBinding<VIEW_TARGET> getDeleteSelectionBinding() {
        return this.deleteSelectionBinding;
    }

    @Override
    public SelectionViewBinding<VIEW_TARGET> getNewSelectionBinding() {
        return this.newSelectionBinding;
    }

    @Override
    public void setNewBinding(String newTargetName) {
        this.newSelectionBinding = new SelectionViewBinding<VIEW_TARGET>(this, newTargetName){

            @Override
            public boolean onSelection(Object item, int detail, int x, int y, int width, int height, int stateMask, boolean doit) {
                AbstractSequenceController.this.newItem();
                return true;
            }
        };
    }

    @Override
    public void setDeleteBinding(String deleteTargetName) {
        this.deleteEnablementBinding = new EnablementViewBinding<Object>(this, deleteTargetName);
        this.deleteSelectionBinding = new SelectionViewBinding<VIEW_TARGET>(this, deleteTargetName){

            @Override
            public boolean onSelection(Object item, int detail, int x, int y, int width, int height, int stateMask, boolean doit) {
                AbstractSequenceController.this.deleteItem();
                return true;
            }
        };
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    @Override
    public boolean isRecordDirty() {
        return this.getRecordController() == null ? false : this.getRecordController().isDirty();
    }

    @Override
    public void setRecordDirty(boolean on) {
        if (this.getRecordController() != null) {
            this.getRecordController().setDirty(on);
        }
    }

    @Override
    public boolean isRecordTransient() {
        return this.getRecordController() == null ? true : this.getRecordController().isDirty();
    }

    @Override
    public void setRecordTransient(boolean on) {
        if (this.getRecordController() != null) {
            this.getRecordController().setTransient(on);
        }
    }

    @Override
    public boolean isTransientCreation() {
        return this.transientCreation;
    }

    @Override
    public void setTransientCreation(boolean on) {
        this.transientCreation = on;
    }

    @Override
    public SEQUENCE_TARGET getSequenceTarget() {
        return (SEQUENCE_TARGET)this.getTarget(SEQUENCE_TARGET_NAME);
    }

    @Override
    public SEQUENCE_TARGET setSequenceTarget(SEQUENCE_TARGET target) {
        return this.putTarget(SEQUENCE_TARGET_NAME, target);
    }

    @Override
    public IRecordController<RECORD_TARGET, VIEW_TARGET> getRecordController() {
        return this.recordController;
    }

    @Override
    public void setRecordController(IRecordController<RECORD_TARGET, VIEW_TARGET> recordController) {
        this.recordController = recordController;
    }

    public SequenceModelBinding<SEQUENCE_TARGET> getSequenceModelBinding() {
        return this.sequenceModelBinding;
    }

    @Override
    public void gotoFirst() {
        int newIndex = this.getSequenceModelBinding().size() > 0 ? 0 : -1;
        this.gotoIndex(newIndex);
    }

    @Override
    public void gotoLast() {
        int newIndex = this.getSequenceModelBinding().size() - 1;
        this.gotoIndex(newIndex);
    }

    @Override
    public void gotoNext() {
        int newIndex = this.getCurrentIndex() + (this.getCurrentIndex() < this.getSequenceModelBinding().size() - 1 ? 1 : 0);
        this.gotoIndex(newIndex);
    }

    @Override
    public void gotoPrevious() {
        int newIndex = this.getCurrentIndex() - (this.getCurrentIndex() > 0 ? 1 : 0);
        this.gotoIndex(newIndex);
    }

    @Override
    public void afterTargetsSet() {
        super.afterTargetsSet();
        this.init();
    }

    @Override
    public boolean mayClose() {
        if (this.isRecordDirty()) {
            return this.leaveDirtyRecord();
        }
        return super.mayClose();
    }

    @Override
    protected void onRetarget(String name, Object newTarget, Object oldTarget) {
        if (SEQUENCE_TARGET_NAME.equals(name)) {
            this.init();
        }
    }

    protected String itemToString(Object item) {
        return item.toString();
    }

    protected boolean leaveDirtyRecord() {
        if (this.getRecordController() != null) {
            this.getRecordController().saveView();
        }
        return true;
    }

    protected boolean confirmDelete() {
        return true;
    }

    protected Object createNewItem() {
        return null;
    }

    protected void newItem() {
        if (this.getRecordController() != null && this.getRecordController().isDirty() && !this.leaveDirtyRecord()) {
            return;
        }
        Object item = this.createNewItem();
        if (item == null) {
            return;
        }
        if (this.getSequenceModelBinding().add(item)) {
            int index = this.getSequenceModelBinding().indexOf(item);
            this.gotoIndex(index);
            this.setRecordTransient(this.isTransientCreation());
        }
        this.updateEnablements();
    }

    protected void deleteItem() {
        if (!this.confirmDelete()) {
            return;
        }
        this.getSequenceModelBinding().remove(this.getCurrentIndex());
        if (this.getCurrentIndex() < this.getSequenceModelBinding().size()) {
            this.gotoIndex(this.getCurrentIndex());
        } else {
            this.gotoLast();
        }
        this.updateEnablements();
    }

    protected void updateEnablements() {
        this.getDeleteEnablementBinding().setEnabled(this.getCurrentIndex() != -1);
    }

    protected abstract void init();

    protected abstract void onModelSet(int var1, Object var2, Object var3);

    protected abstract void onModelRemove(int var1, Object var2);

    protected abstract void onModelMove(int var1, int var2);

    protected abstract void onModelAdd(int var1, Object var2);
}

