/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.epatch.recorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.epatch.AbstractEpatchBuilder;
import org.eclipse.emf.compare.epatch.AssignmentValue;
import org.eclipse.emf.compare.epatch.CreatedObject;
import org.eclipse.emf.compare.epatch.Epatch;
import org.eclipse.emf.compare.epatch.EpatchPackage;
import org.eclipse.emf.compare.epatch.ListAssignment;
import org.eclipse.emf.compare.epatch.ModelImport;
import org.eclipse.emf.compare.epatch.NamedObject;
import org.eclipse.emf.compare.epatch.NamedResource;
import org.eclipse.emf.compare.epatch.ObjectCopy;
import org.eclipse.emf.compare.epatch.ObjectNew;
import org.eclipse.emf.compare.epatch.ObjectRef;
import org.eclipse.emf.compare.epatch.SingleAssignment;
import org.eclipse.emf.compare.epatch.recorder.EmfRecorder;
import org.eclipse.emf.compare.epatch.util.EpatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EpatchRecorder
extends AbstractEpatchBuilder
implements EmfRecorder.RecorderListener {
    protected Map<EObject, String> fragMap = new HashMap<EObject, String>();
    protected EmfRecorder recorder = new EmfRecorder(this);
    protected Map<Resource, NamedResource> resMap = new HashMap<Resource, NamedResource>();

    public EpatchRecorder(Notifier notifier, String name) {
        this(name);
        this.addRootObject(notifier);
        this.recorder.beginRecording();
    }

    public EpatchRecorder(String name) {
        this.epatch = this.createEpatch(name);
    }

    protected void addListAddAssignments(ListAssignment ass, Collection<AssignmentValue> addValues) {
        boolean c = this.isCreate((NamedObject)ass.eContainer());
        EList<AssignmentValue> list = c ? ass.getLeftValues() : ass.getRightValues();
        for (AssignmentValue newV : addValues) {
            if (c) {
                newV.setIndex(0);
                continue;
            }
            for (AssignmentValue oldV : list) {
                if (oldV.getIndex() < newV.getIndex()) continue;
                oldV.setIndex(oldV.getIndex() + 1);
            }
        }
        list.addAll(addValues);
        if (!c) {
            ECollections.sort(list, (Comparator)EpatchUtil.ASS_VAL_SORTER_ASC);
        }
    }

    protected void addListRemoveAssignments(ListAssignment ass, Collection<AssignmentValue> values) {
        for (AssignmentValue newV : values) {
            int oldindex;
            for (AssignmentValue oldV : ass.getRightValues()) {
                if (oldV.getIndex() <= newV.getIndex()) continue;
                oldV.setIndex(oldV.getIndex() - 1);
            }
            ArrayList<AssignmentValue> vals = new ArrayList<AssignmentValue>((Collection<AssignmentValue>)ass.getLeftValues());
            do {
                oldindex = newV.getIndex();
                Iterator i = vals.iterator();
                while (i.hasNext()) {
                    if (((AssignmentValue)i.next()).getIndex() > newV.getIndex()) continue;
                    newV.setIndex(newV.getIndex() + 1);
                    i.remove();
                }
            } while (oldindex != newV.getIndex());
        }
        ass.getLeftValues().addAll(values);
        ECollections.sort(ass.getLeftValues(), (Comparator)EpatchUtil.ASS_VAL_SORTER_DESC);
    }

    public void addRootObject(Notifier obj) {
        this.recorder.addRootObject(obj);
        if (obj instanceof ResourceSet) {
            for (Resource r : ((ResourceSet)obj).getResources()) {
                for (EObject o : r.getContents()) {
                    this.addToFragMap(o);
                }
            }
        } else if (obj instanceof Resource) {
            for (EObject o : ((Resource)obj).getContents()) {
                this.addToFragMap(o);
            }
        } else if (obj instanceof EObject) {
            this.addToFragMap((EObject)obj);
        } else {
            throw new RuntimeException("Unknown observable type " + obj.getClass());
        }
    }

    protected void addToFragMap(EObject obj) {
        this.fragMap.put(obj, this.getFragment(obj));
        TreeIterator i = obj.eAllContents();
        while (i.hasNext()) {
            EObject o = (EObject)i.next();
            this.fragMap.put(o, this.getFragment(o));
        }
    }

    protected void consolidateChanges() {
        this.consolidateResources();
        this.consolidateObjectRefs();
        this.sortLists();
        this.generateNames();
    }

    protected void consolidateObjectRefs() {
        for (Map.Entry e : this.objMap.entrySet()) {
            if (!(e.getValue() instanceof ObjectRef)) continue;
            ObjectRef or = (ObjectRef)e.getValue();
            EObject eo = (EObject)e.getKey();
            NamedResource nres = this.getResource(eo.eResource());
            String nfrag = eo.eResource().getURIFragment(eo);
            if (nres == or.getLeftRes() && nfrag.equals(or.getLeftFrag())) continue;
            or.setRightRes(nres);
            or.setRightFrag(nfrag);
        }
        ECollections.sort(this.epatch.getObjects(), (Comparator)EpatchUtil.NAMED_OBJECT_SORTER);
    }

    protected void consolidateResources() {
        for (NamedResource r : this.epatch.getResources()) {
            if (r.getLeftUri() == null && r.getLeftRoot() == null) {
                r.setLeftUri(this.newURI(r.getRightUri()));
            }
            if (r.getRightUri() != null || r.getRightRoot() != null) continue;
            r.setRightUri(this.newURI(r.getLeftUri()));
        }
    }

    public Epatch endRecording() {
        this.recorder.endRecording();
        this.consolidateChanges();
        return this.getRecorded();
    }

    protected AssignmentValue getAssignmentMoveValue(EStructuralFeature feat, int index, int refIndex) {
        AssignmentValue ass = fc.createAssignmentValue();
        ass.setIndex(index);
        ass.setRefIndex(refIndex);
        return ass;
    }

    @Override
    protected AssignmentValue getAssignmentValueEObject(EReference ref, EObject eobj) {
        AssignmentValue ass = fc.createAssignmentValue();
        if (ref.isContainment()) {
            if (this.isRemovedValue(eobj)) {
                ass.setRefObject(this.getObjectReadded(eobj));
            } else {
                ass.setNewObject(this.getObjectNew(eobj));
            }
        } else if (this.recorder.isObserved((Notifier)eobj)) {
            ass.setRefObject(this.getObjectRef(eobj));
        } else {
            ass.setImport(this.getImportRef(eobj));
            ass.setImpFrag(this.getFragment(eobj));
        }
        return ass;
    }

    protected ObjectNew getObjectNew(EObject obj) {
        ObjectNew o = (ObjectNew)this.objMap.get(obj);
        return o == null ? this.createObjectNew(obj) : o;
    }

    protected NamedObject getObjectReadded(EObject eobj) {
        NamedObject o = (NamedObject)this.objMap.get(eobj);
        if (o instanceof ObjectRef) {
            return o;
        }
        if (o instanceof ObjectNew) {
            this.objMap.remove(eobj);
            NamedObject r = this.getObjectRef(eobj);
            if (o.eContainer() instanceof AssignmentValue) {
                AssignmentValue oldAss = (AssignmentValue)o.eContainer();
                oldAss.eUnset((EStructuralFeature)o.eContainmentFeature());
                oldAss.setRefObject(r);
            }
            this.removeIfNotNeededAnymore(((ObjectNew)o).getImport());
            this.removeUnneededObjectRefs();
            this.removeUnneededResources();
            return r;
        }
        throw new IllegalStateException();
    }

    protected NamedObject getObjectRef(EObject obj) {
        NamedObject o = (NamedObject)this.objMap.get(obj);
        if (o == null) {
            ObjectRef r = fc.createObjectRef();
            r.setLeftRes(this.getResource(obj.eResource()));
            r.setLeftFrag(this.fragMap.get(obj));
            this.epatch.getObjects().add((Object)r);
            this.objMap.put(obj, r);
            o = r;
        }
        return o;
    }

    protected Epatch getRecorded() {
        return this.epatch;
    }

    protected NamedResource getResource(Resource res) {
        NamedResource r = this.resMap.get(res);
        if (r == null) {
            r = fc.createNamedResource();
            r.setLeftUri(res.getURI().lastSegment());
            r.setName("res" + this.resMap.size());
            this.epatch.getResources().add((Object)r);
            this.resMap.put(res, r);
        }
        return r;
    }

    @Override
    public void handleFeature(EStructuralFeature feature, EReference containment, Notification notification, EObject object) {
        if (notification.isTouch() || feature.isTransient()) {
            return;
        }
        if (this.ignoreFeature(feature)) {
            return;
        }
        if (object.eResource() == null) {
            throw new IllegalArgumentException("EObject has no resource");
        }
        Object oldv = notification.getOldValue();
        Object newv = notification.getNewValue();
        int pos = notification.getPosition();
        NamedObject obj = this.getObjectRef(object);
        if (feature.isMany()) {
            ListAssignment a = this.getListAssignment(obj, feature);
            switch (notification.getEventType()) {
                case 9: {
                    break;
                }
                case 1: {
                    this.addListRemoveAssignments(a, Collections.singleton(this.getListAssignmentValue(feature, oldv, pos)));
                    this.addListAddAssignments(a, Collections.singleton(this.getListAssignmentValue(feature, newv, pos)));
                    break;
                }
                case 2: {
                    throw new RuntimeException("unhandeled Notification.UNSET for multi-features");
                }
                case 3: {
                    this.addListAddAssignments(a, Collections.singleton(this.getListAssignmentValue(feature, newv, pos)));
                    break;
                }
                case 5: {
                    throw new RuntimeException("unhandeled Notification.ADD_MANY for multi-features");
                }
                case 4: {
                    this.addListRemoveAssignments(a, Collections.singleton(this.getListAssignmentValue(feature, oldv, pos)));
                    break;
                }
                case 6: {
                    throw new RuntimeException("unhandeled Notification.REMOVE_MANY for multi-features");
                }
                case 7: {
                    int oldPos = (Integer)oldv;
                    this.addListRemoveAssignments(a, Collections.singleton(this.getAssignmentMoveValue(feature, oldPos, pos)));
                    this.addListAddAssignments(a, Collections.singleton(this.getAssignmentMoveValue(feature, pos, oldPos)));
                }
            }
        } else {
            SingleAssignment a = this.getSingleAssignment(obj, feature);
            switch (notification.getEventType()) {
                case 9: {
                    break;
                }
                case 1: {
                    if (this.isCreate(obj)) {
                        a.setLeftValue(this.getAssignmentValue(feature, newv));
                        break;
                    }
                    if (a.getLeftValue() == null) {
                        a.setLeftValue(this.getAssignmentValue(feature, oldv));
                    }
                    a.setRightValue(this.getAssignmentValue(feature, newv));
                    break;
                }
                case 2: {
                    if (this.isCreate(obj)) {
                        a.setLeftValue(this.getAssignmentValue(feature, null));
                        break;
                    }
                    a.setLeftValue(this.getAssignmentValue(feature, oldv));
                    a.setRightValue(this.getAssignmentValue(feature, null));
                    break;
                }
                case 3: {
                    throw new RuntimeException("unhandeled Notification.ADD for single-features");
                }
                case 5: {
                    throw new RuntimeException("unhandeled Notification.ADD_MANY for single-features");
                }
                case 4: {
                    throw new RuntimeException("unhandeled Notification.REMOVE for single-features");
                }
                case 6: {
                    throw new RuntimeException("unhandeled Notification.REMOVE_MANY for single-features");
                }
                case 7: {
                    throw new RuntimeException("unhandeled Notification.MOVE for single-features");
                }
            }
        }
    }

    protected boolean isCreate(NamedObject obj) {
        return obj instanceof CreatedObject;
    }

    protected boolean isRemovedValue(EObject obj) {
        EpatchPackage p;
        NamedObject o = (NamedObject)this.objMap.get(obj);
        if (o == null) {
            return false;
        }
        EReference r = o.eContainer().eContainmentFeature();
        return r == (p = EpatchPackage.eINSTANCE).getSingleAssignment_LeftValue() || r == p.getListAssignment_LeftValues();
    }

    protected String newURI(String uri) {
        int p = uri.lastIndexOf(46);
        if (p < 0) {
            return String.valueOf(uri) + "1";
        }
        return String.valueOf(uri.substring(0, p)) + "1" + uri.substring(p);
    }

    protected void removeIfNotNeededAnymore(ModelImport imp) {
        TreeIterator i = this.epatch.eAllContents();
        while (i.hasNext()) {
            EObject o = (EObject)i.next();
            if (o instanceof ObjectNew && ((ObjectNew)o).getImport() == imp) {
                return;
            }
            if (!(o instanceof AssignmentValue) || ((AssignmentValue)o).getImport() != imp) continue;
            return;
        }
        this.epatch.getModelImports().remove((Object)imp);
    }

    protected void removeUnneededObjectRefs() {
        EObject o;
        HashSet<NamedObject> refs = new HashSet<NamedObject>();
        Object i = this.epatch.eAllContents();
        while (i.hasNext()) {
            NamedObject n;
            o = (EObject)i.next();
            if (!(o instanceof AssignmentValue) || (n = ((AssignmentValue)o).getRefObject()) == null) continue;
            refs.add(n);
        }
        i = this.epatch.getObjects().iterator();
        while (i.hasNext()) {
            o = (ObjectRef)i.next();
            if (o.getAssignments().size() != 0 || refs.contains(o)) continue;
            i.remove();
        }
    }

    protected void removeUnneededResources() {
        EObject o;
        HashSet<NamedResource> refs = new HashSet<NamedResource>();
        Object i = this.epatch.eAllContents();
        while (i.hasNext()) {
            o = (EObject)i.next();
            if (o instanceof ObjectRef) {
                ObjectRef r = (ObjectRef)o;
                if (r.getLeftRes() != null) {
                    refs.add(r.getLeftRes());
                }
                if (r.getRightRes() == null) continue;
                refs.add(r.getRightRes());
                continue;
            }
            if (!(o instanceof ObjectCopy)) continue;
            refs.add(((ObjectCopy)o).getResource());
        }
        i = this.epatch.getResources().iterator();
        while (i.hasNext()) {
            o = (NamedResource)i.next();
            if (o.getLeftRoot() != null || o.getRightRoot() != null || refs.contains(o)) continue;
            i.remove();
        }
    }
}

