/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.epatch;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.epatch.Assignment;
import org.eclipse.emf.compare.epatch.AssignmentValue;
import org.eclipse.emf.compare.epatch.EPackageImport;
import org.eclipse.emf.compare.epatch.Epatch;
import org.eclipse.emf.compare.epatch.EpatchFactory;
import org.eclipse.emf.compare.epatch.ListAssignment;
import org.eclipse.emf.compare.epatch.ModelImport;
import org.eclipse.emf.compare.epatch.NamedObject;
import org.eclipse.emf.compare.epatch.ObjectNew;
import org.eclipse.emf.compare.epatch.ObjectRef;
import org.eclipse.emf.compare.epatch.ResourceImport;
import org.eclipse.emf.compare.epatch.SingleAssignment;
import org.eclipse.emf.compare.epatch.util.EpatchUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public abstract class AbstractEpatchBuilder {
    protected static EpatchFactory fc = EpatchFactory.eINSTANCE;
    protected static String NULL = "null";
    protected Epatch epatch;
    protected Map<URI, ModelImport> importMap = new HashMap<URI, ModelImport>();
    protected Map<EObject, NamedObject> objMap = new HashMap<EObject, NamedObject>();

    protected Epatch createEpatch(String name) {
        Epatch patch = fc.createEpatch();
        patch.setName(name);
        Resource r = new ResourceSetImpl().createResource(URI.createURI((String)(String.valueOf(name) + ".epatch")));
        if (r == null) {
            r = new ResourceImpl(URI.createURI((String)(String.valueOf(name) + ".xmi")));
            new ResourceSetImpl().getResources().add((Object)r);
        }
        r.getContents().add((Object)patch);
        return patch;
    }

    protected ObjectNew createObjectNew(EObject obj) {
        ObjectNew o = fc.createObjectNew();
        this.objMap.put(obj, o);
        o.setImpFrag(this.getFragment((EObject)obj.eClass()));
        o.setImport(this.getImportRef((EObject)obj.eClass()));
        for (EStructuralFeature f : obj.eClass().getEAllStructuralFeatures()) {
            Assignment ass;
            if (f.isTransient() || !obj.eIsSet(f)) continue;
            if (f.isMany()) {
                ass = this.getListAssignment(o, f);
                for (Object v : (List)obj.eGet(f)) {
                    ass.getLeftValues().add((Object)this.getAssignmentValue(f, v));
                }
                continue;
            }
            ass = this.getSingleAssignment(o, f);
            ass.setLeftValue(this.getAssignmentValue(f, obj.eGet(f)));
        }
        return o;
    }

    protected void generateNames() {
        HashSet<NamedObject> needName = new HashSet<NamedObject>();
        TreeIterator i = this.epatch.eAllContents();
        while (i.hasNext()) {
            AssignmentValue la;
            EObject eObject = (EObject)i.next();
            if (!(eObject instanceof AssignmentValue) || (la = (AssignmentValue)eObject).getRefObject() == null) continue;
            needName.add(la.getRefObject());
        }
        NamingTool<EObject> nt = new NamingTool<EObject>("obj");
        for (Map.Entry<EObject, NamedObject> entry : this.objMap.entrySet()) {
            if (!needName.contains(entry.getValue())) continue;
            nt.put(this.getNameForObj(entry.getKey()), entry.getKey());
        }
        for (List list : nt.getConflicts()) {
            for (EObject o : list) {
                if (o.eContainer() == null) continue;
                nt.put(String.valueOf(this.getNameForObj(o.eContainer())) + nt.getName(o), o);
            }
        }
        nt.fixRemainingConflicts();
        for (Map.Entry entry : nt.getMap().entrySet()) {
            this.objMap.get(entry.getKey()).setName((String)entry.getValue());
        }
    }

    protected AssignmentValue getAssignmentValue(EStructuralFeature feat, Object value) {
        if (value == null) {
            return this.getAssignmentValueNull();
        }
        if (feat instanceof EAttribute) {
            return this.getAssignmentValueDataType((EAttribute)feat, value);
        }
        if (feat instanceof EReference) {
            return this.getAssignmentValueEObject((EReference)feat, (EObject)value);
        }
        throw new RuntimeException("UnknownfFeature type:" + feat);
    }

    protected AssignmentValue getAssignmentValueDataType(EAttribute attr, Object value) {
        AssignmentValue ass = fc.createAssignmentValue();
        EFactory f = attr.getEType().getEPackage().getEFactoryInstance();
        String strVal = f.convertToString(attr.getEAttributeType(), value);
        ass.setValue(strVal);
        return ass;
    }

    protected abstract AssignmentValue getAssignmentValueEObject(EReference var1, EObject var2);

    protected AssignmentValue getAssignmentValueNull() {
        AssignmentValue ass = fc.createAssignmentValue();
        ass.setKeyword(NULL);
        return ass;
    }

    protected String getFragment(EObject obj) {
        if (obj.eIsProxy()) {
            return ((InternalEObject)obj).eProxyURI().fragment();
        }
        return obj.eResource().getURIFragment(obj);
    }

    protected String getImportName(String base) {
        String name;
        boolean found;
        base = (base = base.replaceAll("[^a-zA-Z]", " ").trim().replace(' ', '_')).length() == 0 ? "obj" : base;
        int counter = -1;
        block0: do {
            name = counter++ == -1 ? base : String.valueOf(base) + counter;
            found = false;
            for (ModelImport i : this.epatch.getModelImports()) {
                if (!(i instanceof ModelImport) || !i.getName().equals(name)) continue;
                found = true;
                continue block0;
            }
        } while (found);
        return name;
    }

    protected ListAssignment getListAssignment(NamedObject obj, EStructuralFeature feat) {
        Assignment a2;
        for (Assignment a2 : obj.getAssignments()) {
            if (!(a2 instanceof ListAssignment) || !a2.getFeature().equals(feat.getName())) continue;
            return (ListAssignment)a2;
        }
        a2 = fc.createListAssignment();
        a2.setFeature(feat.getName());
        obj.getAssignments().add((Object)a2);
        return a2;
    }

    protected AssignmentValue getListAssignmentValue(EStructuralFeature feat, Object value, int index) {
        AssignmentValue ass = this.getAssignmentValue(feat, value);
        ass.setIndex(index);
        return ass;
    }

    protected String getNameForObj(EObject obj) {
        EStructuralFeature f = obj.eClass().getEStructuralFeature("name");
        if (f instanceof EAttribute && obj.eIsSet(f)) {
            return "" + obj.eGet(f);
        }
        return null;
    }

    protected ModelImport getImportRef(EObject obj) {
        URI uri = obj.eIsProxy() ? ((InternalEObject)obj).eProxyURI().trimFragment() : obj.eResource().getURI();
        ModelImport imp = this.importMap.get(uri);
        if (imp != null) {
            return imp;
        }
        if (obj.eIsProxy()) {
            ResourceImport ri = fc.createResourceImport();
            ri.setName(this.getImportName(uri.lastSegment()));
            ri.setUri(uri.toString());
            imp = ri;
        } else {
            EObject p = (EObject)obj.eResource().getContents().get(0);
            if (p instanceof EPackage && ("file".equals(uri.scheme()) || ((EPackage)p).getNsURI().equals(uri.toString()))) {
                EPackageImport ei = fc.createEPackageImport();
                EPackage ep = (EPackage)p;
                ei.setName(this.getImportName(ep.getNsPrefix()));
                ei.setNsURI(ep.getNsURI());
                imp = ei;
            } else {
                ResourceImport ri = fc.createResourceImport();
                ri.setName(this.getImportName(uri.lastSegment()));
                ri.setUri(obj.eResource().getURI().toString());
                imp = ri;
            }
        }
        this.importMap.put(uri, imp);
        this.epatch.getModelImports().add((Object)imp);
        return imp;
    }

    protected SingleAssignment getSingleAssignment(NamedObject obj, EStructuralFeature feat) {
        Assignment a2;
        for (Assignment a2 : obj.getAssignments()) {
            if (!(a2 instanceof SingleAssignment) || !a2.getFeature().equals(feat.getName())) continue;
            return (SingleAssignment)a2;
        }
        a2 = fc.createSingleAssignment();
        a2.setFeature(feat.getName());
        obj.getAssignments().add((Object)a2);
        return a2;
    }

    protected boolean ignoreFeature(EStructuralFeature feat) {
        return feat == EcorePackage.eINSTANCE.getEClass_EGenericSuperTypes() || feat == EcorePackage.eINSTANCE.getETypedElement_EGenericType();
    }

    protected void sortAssignmentValue(AssignmentValue av) {
        if (av != null && av.getNewObject() != null) {
            this.sortNamedObject(av.getNewObject());
        }
    }

    protected void sortLists() {
        ECollections.sort(this.epatch.getObjects(), (Comparator)EpatchUtil.NAMED_OBJECT_SORTER);
        for (ObjectRef r : this.epatch.getObjects()) {
            this.sortNamedObject(r);
        }
    }

    protected void sortNamedObject(NamedObject obj) {
        ECollections.sort(obj.getAssignments(), (Comparator)EpatchUtil.ASS_SORTER);
        for (Assignment a : obj.getAssignments()) {
            if (a instanceof ListAssignment) {
                ListAssignment la = (ListAssignment)a;
                ECollections.sort(la.getLeftValues(), (Comparator)EpatchUtil.ASS_VAL_SORTER_DESC);
                ECollections.sort(la.getRightValues(), (Comparator)EpatchUtil.ASS_VAL_SORTER_ASC);
                for (AssignmentValue av : la.getLeftValues()) {
                    this.sortAssignmentValue(av);
                }
                for (AssignmentValue av : la.getRightValues()) {
                    this.sortAssignmentValue(av);
                }
                continue;
            }
            SingleAssignment sa = (SingleAssignment)a;
            this.sortAssignmentValue(sa.getLeftValue());
            this.sortAssignmentValue(sa.getRightValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NamingTool<T> {
        private String def;
        private Map<String, List<T>> nameMap = new HashMap<String, List<T>>();
        private Map<T, String> objMap = new HashMap<T, String>();

        public NamingTool(String def) {
            this.def = def;
        }

        public void fixRemainingConflicts() {
            List<List<T>> c = this.getConflicts();
            while (c.size() > 0) {
                for (List<T> cl : c) {
                    int i = 0;
                    while (i < cl.size()) {
                        this.put(String.valueOf(this.objMap.get(cl.get(i))) + i, cl.get(i));
                        ++i;
                    }
                }
                c = this.getConflicts();
            }
        }

        public List<List<T>> getConflicts() {
            ArrayList<List<T>> r = new ArrayList<List<T>>();
            for (List<T> l : this.nameMap.values()) {
                if (l.size() <= 1) continue;
                r.add(new ArrayList<T>(l));
            }
            return r;
        }

        public Map<T, String> getMap() {
            return this.objMap;
        }

        public String getName(T obj) {
            return this.objMap.get(obj);
        }

        public void put(String name, T obj) {
            List<T> lst;
            String oldName;
            if (name == null || "".equals(name)) {
                name = this.def;
            }
            if ((oldName = this.objMap.get(obj)) != null) {
                this.nameMap.get(oldName).remove(obj);
            }
            if ((lst = this.nameMap.get(name)) == null) {
                lst = new ArrayList<T>();
                this.nameMap.put(name, lst);
            }
            lst.add(obj);
            this.objMap.put(obj, name);
        }
    }
}

