/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dbgen.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.eclipse.emf.cdo.dbgen.Column;
import org.eclipse.emf.cdo.dbgen.Database;
import org.eclipse.emf.cdo.dbgen.Index;
import org.eclipse.emf.cdo.dbgen.IndexType;
import org.eclipse.emf.cdo.dbgen.SQLDialect;
import org.eclipse.emf.cdo.dbgen.Table;
import org.eclipse.emf.cdo.dbgen.TableCreationException;
import org.eclipse.emf.cdo.dbgen.UnknownSQLTypeException;
import org.eclipse.emf.cdo.dbgen.internal.DBGenActivator;
import org.eclipse.net4j.util.Argument;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.StringHelper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public class SQLDialectImpl
implements SQLDialect {
    private static final Logger logger = Logger.getLogger(SQLDialectImpl.class);
    private DBGenActivator.DialectElement dialectElement;
    private String stringBIGINT = "BIGINT";
    private String stringBINARY = "BINARY";
    private String stringBIT = "BIT";
    private String stringBLOB = "LONG VARBINARY";
    private String stringBOOLEAN = "BIT";
    private String stringCHAR = "CHAR";
    private String stringCLOB = "LONG VARCHAR";
    private String stringDATE = "DATE";
    private String stringDECIMAL = "DECIMAL";
    private String stringDOUBLE = "DOUBLEPRECISION";
    private String stringFLOAT = "FLOAT";
    private String stringINTEGER = "INTEGER";
    private String stringLONGVARBINARY = "LONG VARBINARY";
    private String stringLONGVARCHAR = "LONG VARCHAR";
    private String stringNUMERIC = "NUMERIC";
    private String stringREAL = "REAL";
    private String stringSMALLINT = "SMALLINT";
    private String stringTIME = "TIME";
    private String stringTIMESTAMP = "TIMESTAMP";
    private String stringTINYINT = "TINYINT";
    private String stringVARBINARY = "VARBINARY";
    private String stringVARCHAR = "VARCHAR";

    public SQLDialectImpl(DBGenActivator.DialectElement dialectElement) {
        Argument.isNotNull((Object)((Object)dialectElement));
        this.dialectElement = dialectElement;
        this.initTypeMappings();
    }

    public DBGenActivator.DialectElement getDialectElement() {
        return this.dialectElement;
    }

    public String toDBType(int sqlType) {
        switch (sqlType) {
            case -5: {
                return this.stringBIGINT;
            }
            case -2: {
                return this.stringBINARY;
            }
            case -7: {
                return this.stringBIT;
            }
            case 2004: {
                return this.stringBLOB;
            }
            case 16: {
                return this.stringBOOLEAN;
            }
            case 1: {
                return this.stringCHAR;
            }
            case 2005: {
                return this.stringCLOB;
            }
            case 91: {
                return this.stringDATE;
            }
            case 3: {
                return this.stringDECIMAL;
            }
            case 8: {
                return this.stringDOUBLE;
            }
            case 6: {
                return this.stringFLOAT;
            }
            case 4: {
                return this.stringINTEGER;
            }
            case -4: {
                return this.stringLONGVARBINARY;
            }
            case -1: {
                return this.stringLONGVARCHAR;
            }
            case 2: {
                return this.stringNUMERIC;
            }
            case 7: {
                return this.stringREAL;
            }
            case 5: {
                return this.stringSMALLINT;
            }
            case 92: {
                return this.stringTIME;
            }
            case 93: {
                return this.stringTIMESTAMP;
            }
            case -6: {
                return this.stringTINYINT;
            }
            case -3: {
                return this.stringVARBINARY;
            }
            case 12: {
                return this.stringVARCHAR;
            }
        }
        throw new UnknownSQLTypeException("Unkown SQL type " + sqlType);
    }

    public void save(DataSource dataSource, Database database, boolean clean) {
        Map existingTables = this.getExistingTables(dataSource);
        for (Table table : database.getTables()) {
            boolean exists;
            String key = table.getName().toUpperCase();
            boolean bl = exists = existingTables.get(key) != null;
            if (exists) {
                if (!clean) continue;
                this.dropTable(dataSource, table);
                this.createTable(dataSource, table);
                continue;
            }
            this.createTable(dataSource, table);
        }
    }

    protected String composeIndexCreationString(Index index) {
        String template;
        Table table = index.getTable();
        switch (index.getType().getValue()) {
            case 0: {
                template = this.dialectElement.getCreateIndexTemplate();
                break;
            }
            case 1: {
                template = this.dialectElement.getCreateUniqueIndexTemplate();
                break;
            }
            case 2: {
                template = this.dialectElement.getCreatePrimaryIndexTemplate();
                break;
            }
            default: {
                throw new ImplementationError("invalid index type: " + (Object)((Object)index.getType()));
            }
        }
        Object[] args = new String[]{this.composeColumnsString(index), index.getName(), table.getName()};
        String result = StringHelper.replaceString((String)template, (Object[])args);
        return result;
    }

    protected String composeTableCreationString(Table table) {
        Index pk = table.getPrimaryIndex();
        String template = pk == null ? this.dialectElement.getCreateTableTemplate() : this.dialectElement.getCreateTablePrimaryTemplate();
        String pkConstraint = pk == null ? null : this.composeColumnsString(pk);
        Object[] args = new String[]{this.composeColumnsString(table, false), table.getName(), pkConstraint};
        String result = StringHelper.replaceString((String)template, (Object[])args);
        return result;
    }

    protected String composeTableDropString(Table table) {
        Object[] args = new String[]{table.getName()};
        String result = StringHelper.replaceString((String)this.dialectElement.getDropTableTemplate(), (Object[])args);
        return result;
    }

    protected String composeColumnsString(Table table, boolean onlyNames) {
        if (onlyNames) {
            return this.composeColumnsString((List)table.getColumns());
        }
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Column column : table.getColumns()) {
            String type = this.composeTypeString(column);
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(column.getName());
            buffer.append(" ");
            buffer.append(type);
            if (column.getLength() > 0) {
                buffer.append("(");
                buffer.append(column.getLength());
                buffer.append(")");
            }
            if (column.getConstraint() == null) continue;
            buffer.append(" " + column.getConstraint());
        }
        return buffer.toString();
    }

    protected String composeColumnsString(Index index) {
        return this.composeColumnsString((List)index.getColumns());
    }

    protected String composeColumnsString(List columns) {
        Iterator iter = columns.iterator();
        StringBuffer result = new StringBuffer(((Column)iter.next()).getName());
        while (iter.hasNext()) {
            result.append(", ");
            result.append(((Column)iter.next()).getName());
        }
        return result.toString();
    }

    protected String composeTypeString(Column column) {
        return this.toDBType(column.getType().getValue());
    }

    protected Map getExistingTables(DataSource dataSource) {
        final HashMap result = new HashMap();
        try {
            JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (DatabaseMetaDataCallback)new DatabaseMetaDataCallback(){

                public Object processMetaData(DatabaseMetaData dbmd) throws SQLException {
                    ResultSet tables = dbmd.getTables(null, null, "%", new String[]{"TABLE"});
                    while (tables.next()) {
                        String table = tables.getString(3);
                        String key = table.toUpperCase();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Found existing table " + key));
                        }
                        result.put(key, table);
                    }
                    return null;
                }
            });
        }
        catch (MetaDataAccessException ex) {
            logger.error((Object)"Error while retrieving JDBC metadata", (Throwable)ex);
        }
        return result;
    }

    private void createTable(DataSource dataSource, Table table) {
        JdbcTemplate template = new JdbcTemplate(dataSource);
        String tableSQL = this.composeTableCreationString(table);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)tableSQL);
        }
        template.execute(tableSQL);
        for (Index index : table.getIndices()) {
            if (((Object)((Object)index.getType())).equals((Object)IndexType.PRIMARY_LITERAL)) continue;
            if (index.getColumns().size() == 0) {
                throw new TableCreationException("Index " + index.getName() + " has no columns");
            }
            String indexSQL = this.composeIndexCreationString(index);
            if (indexSQL == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)indexSQL);
            }
            template.execute(indexSQL);
        }
    }

    private void dropTable(DataSource dataSource, Table table) {
        try {
            JdbcTemplate template = new JdbcTemplate(dataSource);
            String sql = this.composeTableDropString(table);
            template.execute(sql);
        }
        catch (Throwable t) {
            logger.warn((Object)("Error while dropping table " + table), t);
        }
    }

    private void initTypeMappings() {
        DBGenActivator.TypeMappingElement[] elements = this.dialectElement.getTypeMappings();
        int i = 0;
        while (i < elements.length) {
            DBGenActivator.TypeMappingElement element = elements[i];
            if ("BIGINT".equals(element.getSqlType())) {
                this.stringBIGINT = element.getVendorString();
            } else if ("BINARY".equals(element.getSqlType())) {
                this.stringBINARY = element.getVendorString();
            } else if ("BIT".equals(element.getSqlType())) {
                this.stringBIT = element.getVendorString();
            } else if ("BLOB".equals(element.getSqlType())) {
                this.stringBLOB = element.getVendorString();
            } else if ("BOOLEAN".equals(element.getSqlType())) {
                this.stringBOOLEAN = element.getVendorString();
            } else if ("CHAR".equals(element.getSqlType())) {
                this.stringCHAR = element.getVendorString();
            } else if ("CLOB".equals(element.getSqlType())) {
                this.stringCLOB = element.getVendorString();
            } else if ("DATE".equals(element.getSqlType())) {
                this.stringDATE = element.getVendorString();
            } else if ("DECIMAL".equals(element.getSqlType())) {
                this.stringDECIMAL = element.getVendorString();
            } else if ("DOUBLE".equals(element.getSqlType())) {
                this.stringDOUBLE = element.getVendorString();
            } else if ("FLOAT".equals(element.getSqlType())) {
                this.stringFLOAT = element.getVendorString();
            } else if ("INTEGER".equals(element.getSqlType())) {
                this.stringINTEGER = element.getVendorString();
            } else if ("LONGVARBINARY".equals(element.getSqlType())) {
                this.stringLONGVARBINARY = element.getVendorString();
            } else if ("LONGVARCHAR".equals(element.getSqlType())) {
                this.stringLONGVARCHAR = element.getVendorString();
            } else if ("NUMERIC".equals(element.getSqlType())) {
                this.stringNUMERIC = element.getVendorString();
            } else if ("REAL".equals(element.getSqlType())) {
                this.stringREAL = element.getVendorString();
            } else if ("SMALLINT".equals(element.getSqlType())) {
                this.stringSMALLINT = element.getVendorString();
            } else if ("TIME".equals(element.getSqlType())) {
                this.stringTIME = element.getVendorString();
            } else if ("TIMESTAMP".equals(element.getSqlType())) {
                this.stringTIMESTAMP = element.getVendorString();
            } else if ("TINYINT".equals(element.getSqlType())) {
                this.stringTINYINT = element.getVendorString();
            } else if ("VARBINARY".equals(element.getSqlType())) {
                this.stringVARBINARY = element.getVendorString();
            } else if ("VARCHAR".equals(element.getSqlType())) {
                this.stringVARCHAR = element.getVendorString();
            }
            ++i;
        }
    }
}

