/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.client.AttributeConverter;
import org.eclipse.emf.cdo.client.AttributeInfo;
import org.eclipse.emf.cdo.client.CDOPersistable;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ClassInfo;
import org.eclipse.emf.cdo.client.PackageManager;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.client.impl.ResourceManagerImpl;
import org.eclipse.emf.cdo.client.protocol.AbstractCDOClientRequest;
import org.eclipse.emf.cdo.client.protocol.ClientCDOProtocolImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeFactory;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.change.impl.EObjectToChangesMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.ImplementationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTransactionRequest
extends AbstractCDOClientRequest {
    private static final int CAPACITY_eClassToAttributeChangesMap = 53;
    private static final int CAPACITY_referenceRecords = 1009;
    private static final int INVALID_FEATURE = -1;
    private static final int TRANSIENT_FEATURE = 0;
    private static final int ATTRIBUTE_FEATURE = 1;
    private static final int OBJECT_FEATURE = 2;
    private static final int COLLECTION_FEATURE = 3;
    private Set<ReferenceRecord> referenceRecords = new HashSet<ReferenceRecord>(1009);
    private ChangeDescription changeDescription;
    private boolean firstChange;
    private List<EObject> changedObjects = new ArrayList<EObject>();
    private AttributeInfo attributeInfo;
    private List<EObject> objectsToAttach = new ArrayList<EObject>();
    private PackageManager packageManager;

    public CommitTransactionRequest(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public short getSignalId() {
        return 7;
    }

    public void request() {
        this.packageManager = ((ClientCDOProtocolImpl)this.getProtocol()).getPackageManager();
        this.commitObjectsToDetach();
        this.commitObjectsToAttach();
        this.commitObjectChanges();
        this.announceNewResources();
    }

    public Object confirm() {
        if (this.changeDescription == null) {
            throw new ImplementationError("changeDescription == null");
        }
        boolean ok = this.receiveBoolean();
        if (!ok) {
            this.changeDescription.apply();
            return Boolean.FALSE;
        }
        ResourceManager resourceManager = this.getResourceManager();
        ResourceSet resourceSet = resourceManager.getResourceSet();
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            if (!(resource instanceof CDOResource)) continue;
            CDOResource cdoResource = (CDOResource)resource;
            cdoResource.setExisting(true);
        }
        int attachedCount = this.receiveInt();
        if (attachedCount != this.objectsToAttach.size()) {
            throw new ImplementationError("attachedCount != attached.size()");
        }
        for (EObject object : this.objectsToAttach) {
            long oid = this.receiveLong();
            resourceManager.reRegisterObject(object, oid);
            int rid = this.packageManager.getOidEncoder().getRID(oid);
            CDOResource cdoResource = resourceManager.getResource(rid);
            ResourceManagerImpl.initPersistable(object, cdoResource, oid, 1);
        }
        int changedCount = this.receiveInt();
        if (changedCount != this.changedObjects.size()) {
            throw new ImplementationError("changedCount != changedObjects.size()");
        }
        for (EObject object : this.changedObjects) {
            long oid = this.receiveLong();
            int oca = this.receiveInt();
            if (ResourceManagerImpl.getOID(object) != oid) {
                throw new ImplementationError("getOID(object) != oid");
            }
            if (ResourceManagerImpl.getOCA(object) != oca - 1) {
                throw new ImplementationError("getOCA(object) != oca - 1");
            }
            ResourceManagerImpl.incOCA(object);
        }
        return Boolean.TRUE;
    }

    private void announceNewResources() {
        ResourceManager resourceManager = this.getResourceManager();
        ResourceSet resourceSet = resourceManager.getResourceSet();
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            CDOResource cdoResource;
            if (!(resource instanceof CDOResource) || (cdoResource = (CDOResource)resource).isExisting()) continue;
            this.transmitInt(cdoResource.getRID());
            this.transmitString(cdoResource.getPath());
        }
        this.transmitInt(0);
    }

    private void commitObjectsToDetach() {
        EList attached = this.changeDescription.getObjectsToAttach();
        if (this.isDebugEnabled()) {
            this.debug("commitObjectsToDetach(" + attached.size() + " object" + (attached.size() != 1 ? "s" : "") + ")");
        }
        TreeIterator it = EcoreUtil.getAllContents((Collection)attached);
        while (it.hasNext()) {
            EObject object = (EObject)it.next();
            this.changeDescription.getObjectChanges().removeKey((Object)object);
            long oid = ResourceManagerImpl.getOID(object);
            int oca = ((CDOPersistable)object).cdoGetOCA();
            if (oid == 0L || oca == -1) continue;
            if (this.isDebugEnabled()) {
                this.debug(ResourceManagerImpl.getLabel(object));
            }
            this.transmitLong(oid);
        }
        this.transmitLong(0L);
    }

    private void commitObjectsToAttach() {
        for (EObject eObject : this.changeDescription.getObjectsToDetach()) {
            this.objectsToAttach.add(eObject);
            TreeIterator tree = eObject.eAllContents();
            while (tree.hasNext()) {
                EObject child = (EObject)tree.next();
                this.objectsToAttach.add(child);
            }
        }
        this.transmitInt(this.objectsToAttach.size());
        if (this.isDebugEnabled()) {
            this.debug("commitObjectsToAttach(" + this.objectsToAttach.size() + " object" + (this.objectsToAttach.size() != 1 ? "s" : "") + ")");
        }
        for (EObject eObject : this.objectsToAttach) {
            boolean isContent;
            ClassInfo classInfo = this.packageManager.getClassInfo(eObject);
            if (classInfo == null) {
                throw new ImplementationError("Class not registered as CDO persistent: " + eObject.eClass());
            }
            this.changeDescription.getObjectChanges().removeKey((Object)eObject);
            long oid = ResourceManagerImpl.getOID(eObject);
            if (oid == 0L) {
                throw new ImplementationError("oid == 0");
            }
            int cid = classInfo.getCID();
            if (cid <= 0) {
                throw new ImplementationError("cid <= 0");
            }
            boolean bl = isContent = eObject.eContainer() == null;
            if (this.isDebugEnabled()) {
                this.debug("Transmitting object to attach: oid=" + this.packageManager.getOidEncoder().toString(oid) + ", cid=" + cid + ", isContent=" + isContent);
            }
            this.transmitLong(oid);
            this.transmitInt(cid);
            this.transmitBoolean(isContent);
            this.commitObjectsToAttachAttributes(eObject);
            this.rememberObjectsToAttachReferences(eObject, classInfo);
        }
        this.commitReferencesToAdd();
    }

    /*
     * Unable to fully structure code
     */
    private void commitObjectsToAttachAttributes(EObject eObject) {
        classInfo = this.packageManager.getClassInfo(eObject);
        if (classInfo != null) ** GOTO lbl17
        throw new ImplementationError("Class not registered as CDO persistent: " + eObject.eClass());
lbl-1000:
        // 1 sources

        {
            if (this.isDebugEnabled()) {
                this.debug("Transmitting attributeSegment " + classInfo.getFullName());
            }
            attributeInfos = classInfo.getAttributeInfos();
            i = 0;
            while (i < attributeInfos.length) {
                attributeInfo = attributeInfos[i];
                if (this.isDebugEnabled()) {
                    this.debug("Transmitting attribute " + attributeInfo.getName());
                }
                converter = this.packageManager.getAttributeConverter();
                converter.toChannel(eObject, attributeInfo.getEAttribute(), this.getChannel());
                ++i;
            }
            classInfo = classInfo.getParent();
lbl17:
            // 2 sources

            ** while (classInfo != null)
        }
lbl18:
        // 1 sources

    }

    private void rememberObjectsToAttachReferences(EObject object, ClassInfo classInfo) {
        EReference[] references = classInfo.getAllReferences();
        int i = 0;
        while (i < references.length) {
            EReference reference = references[i];
            if (reference.isMany()) {
                int ordinal = 0;
                EList values = (EList)object.eGet((EStructuralFeature)reference);
                for (EObject value : values) {
                    long oid = ResourceManagerImpl.getOID(value);
                    this.rememberReferenceToAdd(ResourceManagerImpl.getOID(object), reference, ++ordinal, oid);
                }
            } else {
                EObject value = (EObject)object.eGet((EStructuralFeature)reference);
                if (value != null) {
                    long id = ResourceManagerImpl.getOID(value);
                    this.rememberReferenceToAdd(ResourceManagerImpl.getOID(object), reference, 0, id);
                }
            }
            ++i;
        }
    }

    private void commitReferencesToAdd() {
        this.transmitInt(this.referenceRecords.size());
        for (ReferenceRecord record : this.referenceRecords) {
            long oid = record.getOID();
            EReference feature = record.getFeature();
            int ordinal = record.getOrdinal();
            long target = record.getTarget();
            boolean containment = feature.isContainment();
            if (this.isDebugEnabled()) {
                this.debug("Transmitting reference to add: oid=" + this.packageManager.getOidEncoder().toString(oid) + ", feature=" + feature.getFeatureID() + ", ordinal=" + ordinal + ", target=" + this.packageManager.getOidEncoder().toString(target) + ", containment=" + containment);
            }
            this.transmitLong(oid);
            this.transmitInt(feature.getFeatureID());
            this.transmitInt(ordinal);
            this.transmitLong(target);
            this.transmitBoolean(containment);
        }
    }

    private void commitObjectChanges() {
        EMap objectChanges = this.changeDescription.getObjectChanges();
        if (this.isDebugEnabled()) {
            this.debug("commitObjectChanges(" + objectChanges.size() + " objects)");
        }
        for (EObjectToChangesMapEntryImpl entry : objectChanges) {
            EObject eObject = (EObject)entry.getKey();
            EList featureChanges = (EList)entry.getValue();
            this.transmitObjectChange(eObject, featureChanges);
        }
        this.transmitLong(0L);
    }

    private void transmitObjectChange(EObject eObject, EList featureChanges) {
        ClassInfo classInfo = this.packageManager.getClassInfo(eObject);
        if (classInfo == null) {
            throw new ImplementationError("Class not registered as CDO persistent: " + eObject.eClass());
        }
        HashMap<EClass, List<AttributeInfo>> eClassToAttributeChangesMap = new HashMap<EClass, List<AttributeInfo>>(53);
        this.firstChange = true;
        for (FeatureChange featureChange : featureChanges) {
            EStructuralFeature feature = featureChange.getFeature();
            int type = this.featureType(feature, classInfo);
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    this.tryObjectChangeHeader(eObject);
                    this.rememberAttributeChange(feature, eClassToAttributeChangesMap);
                    break;
                }
                case 2: {
                    this.tryObjectChangeHeader(eObject);
                    this.commitObjectChangeReferenceOne(eObject, (EReference)feature);
                    break;
                }
                case 3: {
                    this.tryObjectChangeHeader(eObject);
                    this.commitObjectChangeReferenceMany(eObject, featureChange, (EReference)feature);
                    break;
                }
                default: {
                    throw new ImplementationError("Invalid feature type: " + type);
                }
            }
        }
        if (this.firstChange) {
            return;
        }
        this.transmitByte((byte)0);
        this.transmitAttributeChanges(eObject, eClassToAttributeChangesMap);
        this.changedObjects.add(eObject);
    }

    private void transmitAttributeChanges(EObject eObject, Map<EClass, List<AttributeInfo>> eClassToAttributeChangesMap) {
        Set<Map.Entry<EClass, List<AttributeInfo>>> entrySet = eClassToAttributeChangesMap.entrySet();
        for (Map.Entry<EClass, List<AttributeInfo>> entry : entrySet) {
            EClass eClass = entry.getKey();
            List<AttributeInfo> attributeChangesOfClassifierList = entry.getValue();
            ClassInfo classInfo = this.packageManager.getClassInfo(eClass);
            if (classInfo == null) {
                throw new ImplementationError("Class not registered as CDO persistent: " + entry.getKey());
            }
            int cid = classInfo.getCID();
            int count = attributeChangesOfClassifierList.size();
            if (this.isDebugEnabled()) {
                this.debug("Transmitting segment " + classInfo.getFullName() + ": count=" + count);
            }
            this.transmitInt(cid);
            this.transmitInt(count);
            for (AttributeInfo attributeInfo : attributeChangesOfClassifierList) {
                this.transmitAttributeChange(eObject, attributeInfo);
            }
        }
        this.transmitInt(0);
    }

    private void rememberAttributeChange(EStructuralFeature feature, Map<EClass, List<AttributeInfo>> eClassToAttributeChangesMap) {
        EClass eClass = feature.getEContainingClass();
        List<AttributeInfo> attributeChangesOfEClass = eClassToAttributeChangesMap.get(eClass);
        if (attributeChangesOfEClass == null) {
            attributeChangesOfEClass = new ArrayList<AttributeInfo>();
            eClassToAttributeChangesMap.put(eClass, attributeChangesOfEClass);
        }
        attributeChangesOfEClass.add(this.attributeInfo);
    }

    private int featureType(EStructuralFeature feature, ClassInfo classInfo) {
        this.attributeInfo = null;
        if (feature instanceof EReference && feature.isTransient()) {
            return 0;
        }
        if (feature instanceof EAttribute) {
            this.attributeInfo = classInfo.getAttributeInfo((EAttribute)feature);
            if (this.attributeInfo == null) {
                return 0;
            }
            return 1;
        }
        if (feature instanceof EReference) {
            if (feature.isMany()) {
                return 3;
            }
            return 2;
        }
        return -1;
    }

    private void tryObjectChangeHeader(EObject eObject) {
        if (this.firstChange) {
            this.firstChange = false;
            long oid = ResourceManagerImpl.getOID(eObject);
            int oca = ResourceManagerImpl.getOCA(eObject);
            if (this.isDebugEnabled()) {
                this.debug("Transmitting object to change: " + ResourceManagerImpl.getLabel(eObject) + ")");
            }
            this.transmitLong(oid);
            this.transmitInt(oca);
        }
    }

    private void transmitAttributeChange(EObject eObject, AttributeInfo attributeInfo) {
        if (this.isDebugEnabled()) {
            this.debug("commitObjectChangeAttribute(" + attributeInfo.getName() + ")");
        }
        EAttribute attribute = attributeInfo.getEAttribute();
        this.transmitInt(attribute.getFeatureID());
        AttributeConverter converter = this.packageManager.getAttributeConverter();
        converter.toChannel(eObject, attribute, this.getChannel());
    }

    private void commitObjectChangeReferenceMany(EObject object, FeatureChange featureChange, EReference reference) {
        if (this.isDebugEnabled()) {
            this.debug("commitObjectChangeReferenceMany(" + reference.getName() + ")");
        }
        long oid = ResourceManagerImpl.getOID(object);
        if (featureChange.isSet()) {
            EList currentObjects = (EList)object.eGet((EStructuralFeature)reference);
            BasicEList originalObjects = new BasicEList((Collection)currentObjects);
            BasicEList listChanges = new BasicEList(featureChange.getListChanges().size());
            for (ListChange listChange : featureChange.getListChanges()) {
                ListChange changeCopy = ChangeFactory.eINSTANCE.createListChange();
                changeCopy.setKind(listChange.getKind());
                changeCopy.setFeature(listChange.getFeature());
                changeCopy.setIndex(listChange.getIndex());
                changeCopy.setMoveToIndex(listChange.getMoveToIndex());
                changeCopy.getValues().addAll((Collection)listChange.getValues());
                changeCopy.applyAndReverse((EList)originalObjects);
                listChanges.add((Object)changeCopy);
            }
            ECollections.reverse((EList)listChanges);
            block6: for (ListChange listChange : listChanges) {
                ChangeKind changeKind = listChange.getKind();
                switch (changeKind.getValue()) {
                    case 2: {
                        int index = listChange.getIndex();
                        int moveToIndex = listChange.getMoveToIndex();
                        this.transmitReferenceChange((byte)5, oid, reference, index, 0L, moveToIndex);
                        break;
                    }
                    case 0: {
                        int index = listChange.getIndex();
                        EList values = listChange.getValues();
                        for (EObject value : values) {
                            long target = ResourceManagerImpl.getOID(value);
                            this.transmitReferenceChange((byte)3, oid, reference, index, target, 0);
                        }
                        continue block6;
                    }
                    case 1: {
                        int index = listChange.getIndex();
                        this.transmitReferenceChange((byte)4, oid, reference, index, 0L, 0);
                        break;
                    }
                    default: {
                        throw new ImplementationError("Unexpected change kind: " + changeKind.getName());
                    }
                }
            }
        } else {
            int ordinal = 0;
            EList values = (EList)object.eGet((EStructuralFeature)reference);
            for (EObject value : values) {
                long target = ResourceManagerImpl.getOID(value);
                this.transmitReferenceChange((byte)3, oid, reference, ordinal++, target, 0);
            }
        }
    }

    private void commitObjectChangeReferenceOne(EObject object, EReference reference) {
        if (this.isDebugEnabled()) {
            this.debug("commitObjectChangeReferenceOne()");
        }
        EObject refObject = (EObject)object.eGet((EStructuralFeature)reference);
        long oid = ResourceManagerImpl.getOID(object);
        long target = refObject == null ? 0L : ResourceManagerImpl.getOID(refObject);
        byte changeKind = refObject == null ? (byte)2 : 1;
        this.transmitReferenceChange(changeKind, oid, reference, 0, target, 0);
        if (this.isDebugEnabled() && refObject != null) {
            this.debug("--> " + reference.getName() + ": " + ResourceManagerImpl.getLabel(refObject));
        }
    }

    private void transmitReferenceChange(byte changeKind, long sourceId, EReference feature, int sourceOrdinal, long targetId, int moveToIndex) {
        this.transmitByte(changeKind);
        this.transmitLong(sourceId);
        this.transmitInt(feature.getFeatureID());
        switch (changeKind) {
            case 1: {
                if (this.isDebugEnabled()) {
                    this.debug("transmitReferenceChange(SET, oid=" + this.packageManager.getOidEncoder().toString(sourceId) + ", featureId=" + feature.getFeatureID() + ", target=" + this.packageManager.getOidEncoder().toString(targetId) + ", containment=" + feature.isContainment() + ")");
                }
                this.transmitLong(targetId);
                this.transmitBoolean(feature.isContainment());
                break;
            }
            case 2: {
                if (!this.isDebugEnabled()) break;
                this.debug("transmitReferenceChange(UNSET, oid=" + this.packageManager.getOidEncoder().toString(sourceId) + ", featureId=" + feature.getFeatureID() + ")");
                break;
            }
            case 3: {
                if (this.isDebugEnabled()) {
                    this.debug("transmitReferenceChange(ADD, oid=" + this.packageManager.getOidEncoder().toString(sourceId) + ", featureId=" + feature.getFeatureID() + ", ordinal=" + sourceOrdinal + ", target=" + this.packageManager.getOidEncoder().toString(targetId) + ", containment=" + feature.isContainment() + ")");
                }
                this.transmitInt(sourceOrdinal);
                this.transmitLong(targetId);
                this.transmitBoolean(feature.isContainment());
                break;
            }
            case 4: {
                if (this.isDebugEnabled()) {
                    this.debug("transmitReferenceChange(REMOVE, oid=" + this.packageManager.getOidEncoder().toString(sourceId) + ", featureId=" + feature.getFeatureID() + ", ordinal=" + sourceOrdinal + ")");
                }
                this.transmitInt(sourceOrdinal);
                break;
            }
            case 5: {
                if (this.isDebugEnabled()) {
                    this.debug("transmitReferenceChange(MOVE, oid=" + this.packageManager.getOidEncoder().toString(sourceId) + ", featureId=" + feature.getFeatureID() + ", ordinal=" + sourceOrdinal + ", moveToIndex=" + moveToIndex + ")");
                }
                this.transmitInt(sourceOrdinal);
                this.transmitInt(moveToIndex);
            }
        }
    }

    private void rememberReferenceToAdd(long oid, EReference feature, int ordinal, long target) {
        ReferenceRecord record = new ReferenceRecord(oid, feature, ordinal, target);
        this.referenceRecords.add(record);
    }

    private static class ReferenceRecord {
        private long oid;
        private EReference feature;
        private int ordinal;
        private long target;

        public ReferenceRecord(long oid, EReference feature, int ordinal, long target) {
            this.oid = oid;
            this.feature = feature;
            this.ordinal = ordinal;
            this.target = target;
        }

        public long getOID() {
            return this.oid;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public EReference getFeature() {
            return this.feature;
        }

        public int getFeatureId() {
            return this.feature.getFeatureID();
        }

        public long getTarget() {
            return this.target;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ReferenceRecord)) {
                return false;
            }
            ReferenceRecord that = (ReferenceRecord)obj;
            return this.oid == that.oid && this.getFeatureId() == that.getFeatureId() && this.ordinal == that.ordinal && this.target == that.target;
        }

        public int hashCode() {
            return (int)(this.oid >> 32) ^ (int)(this.oid & 0xFFFFFFFFFFFFFFFFL) ^ (int)(this.target >> 32) ^ (int)(this.target & 0xFFFFFFFFFFFFFFFFL) ^ this.getFeatureId() ^ this.ordinal;
        }
    }
}

