/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import org.eclipse.net4j.util.concurrent.ExecutorServiceFactory;
import org.eclipse.net4j.util.concurrent.TimerLifecycle;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.ManagedContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.security.FileUserManagerFactory;
import org.eclipse.net4j.util.security.RandomizerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContainerUtil {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final IContainer<Object> EMPTY = new IContainer<Object>(){

        @Override
        public Object[] getElements() {
            return NO_ELEMENTS;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void addListener(IListener listener) {
        }

        @Override
        public void removeListener(IListener listener) {
        }

        public String toString() {
            return "EMPTY_CONTAINER";
        }
    };

    private ContainerUtil() {
    }

    public static void prepareContainer(IManagedContainer container) {
        container.registerFactory(new TimerLifecycle.DaemonFactory());
        container.registerFactory(new ExecutorServiceFactory());
        container.registerFactory(new RandomizerFactory());
        container.registerFactory(new FileUserManagerFactory());
    }

    public static IContainer<Object> emptyContainer() {
        return EMPTY;
    }

    public static IManagedContainer createContainer() {
        return new ManagedContainer();
    }

    public static boolean isEmpty(Object container) {
        if (container instanceof IContainer) {
            return ((IContainer)container).isEmpty();
        }
        return true;
    }

    public static Object[] getElements(Object container) {
        if (container instanceof IContainer) {
            return ((IContainer)container).getElements();
        }
        return NO_ELEMENTS;
    }
}

