/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.nio.ByteBuffer;
import org.eclipse.net4j.util.fsm.ITransition;
import org.eclipse.net4j.util.security.IChallengeResponse;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.net4j.util.security.Negotiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChallengeResponseNegotiator
extends Negotiator<IChallengeResponse.State, IChallengeResponse.Event>
implements IChallengeResponse {
    public static final String DEFAULT_ALGORITHM_NAME = "PBEWithMD5AndDES";
    private String algorithmName = "PBEWithMD5AndDES";

    public ChallengeResponseNegotiator(boolean initiator) {
        super(IChallengeResponse.State.class, IChallengeResponse.Event.class, IChallengeResponse.State.INITIAL, IChallengeResponse.State.SUCCESS, IChallengeResponse.State.FAILURE, IChallengeResponse.Event.START, IChallengeResponse.Event.BUFFER, initiator);
        this.init(IChallengeResponse.State.INITIAL, IChallengeResponse.Event.START, new Transition(){

            protected void execute(INegotiationContext context, ByteBuffer NULL) {
                ByteBuffer challenge = context.getBuffer();
                ChallengeResponseNegotiator.this.createChallenge(context, challenge);
                context.transmitBuffer(challenge);
                ChallengeResponseNegotiator.this.changeState(context, IChallengeResponse.State.CHALLENGE);
            }
        });
        this.init(IChallengeResponse.State.INITIAL, IChallengeResponse.Event.BUFFER, new Transition(){

            protected void execute(INegotiationContext context, ByteBuffer challenge) {
                ByteBuffer response = context.getBuffer();
                ChallengeResponseNegotiator.this.handleChallenge(context, challenge, response);
                context.transmitBuffer(response);
                ChallengeResponseNegotiator.this.changeState(context, IChallengeResponse.State.RESPONSE);
            }
        });
        this.init(IChallengeResponse.State.CHALLENGE, IChallengeResponse.Event.BUFFER, new Transition(){

            protected void execute(INegotiationContext context, ByteBuffer response) {
                boolean success = ChallengeResponseNegotiator.this.handleResponse(context, response);
                ByteBuffer acknowledgement = context.getBuffer();
                acknowledgement.put(success ? (byte)1 : 0);
                context.transmitBuffer(acknowledgement);
                ChallengeResponseNegotiator.this.changeState(context, success ? IChallengeResponse.State.SUCCESS : IChallengeResponse.State.FAILURE);
            }
        });
        this.init(IChallengeResponse.State.RESPONSE, IChallengeResponse.Event.BUFFER, new Transition(){

            protected void execute(INegotiationContext context, ByteBuffer acknowledgement) {
                boolean success = acknowledgement.get() == 1;
                ChallengeResponseNegotiator.this.changeState(context, success ? IChallengeResponse.State.SUCCESS : IChallengeResponse.State.FAILURE);
            }
        });
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.algorithmName == null) {
            throw new IllegalStateException("algorithmName == null");
        }
    }

    @Override
    protected IChallengeResponse.State getState(INegotiationContext subject) {
        return (IChallengeResponse.State)subject.getState();
    }

    @Override
    protected void setState(INegotiationContext subject, IChallengeResponse.State state) {
        subject.setState(state);
    }

    protected abstract void createChallenge(INegotiationContext var1, ByteBuffer var2);

    protected abstract void handleChallenge(INegotiationContext var1, ByteBuffer var2, ByteBuffer var3);

    protected abstract boolean handleResponse(INegotiationContext var1, ByteBuffer var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class Transition
    implements ITransition<IChallengeResponse.State, IChallengeResponse.Event, INegotiationContext, ByteBuffer> {
        protected Transition() {
        }

        @Override
        public final void execute(INegotiationContext context, IChallengeResponse.State state, IChallengeResponse.Event event, ByteBuffer buffer) {
            this.execute(context, buffer);
        }

        protected abstract void execute(INegotiationContext var1, ByteBuffer var2);
    }
}

