/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.trace;

import java.io.PrintStream;
import java.text.MessageFormat;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.trace.OMTraceHandler;
import org.eclipse.net4j.util.om.trace.OMTraceHandlerEvent;
import org.eclipse.net4j.util.om.trace.OMTracer;

public class PrintTraceHandler
implements OMTraceHandler {
    public static final PrintTraceHandler CONSOLE = new PrintTraceHandler();
    private PrintStream stream;
    private String pattern;
    private boolean shortContext;

    public PrintTraceHandler(PrintStream stream) {
        this.stream = stream;
    }

    protected PrintTraceHandler() {
        this(IOUtil.OUT());
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean isShortContext() {
        return this.shortContext;
    }

    public void setShortContext(boolean shortContext) {
        this.shortContext = shortContext;
    }

    public void traced(OMTraceHandlerEvent event) {
        String line = this.pattern == null ? PrintTraceHandler.format(this.shortContext, event) : PrintTraceHandler.format(this.pattern, event);
        this.stream.println(line);
        if (event.getThrowable() != null) {
            IOUtil.print(event.getThrowable(), this.stream);
        }
    }

    public static String format(boolean shortContext, OMTraceHandlerEvent event) {
        Class<?> context = event.getContext();
        String contextName = shortContext ? context.getSimpleName() : context.getName();
        return String.valueOf(Thread.currentThread().getName()) + " [" + contextName + "] " + event.getMessage();
    }

    public static String format(String pattern, OMTraceHandlerEvent event) {
        OMTracer tracer = event.getTracer();
        String tracerName = tracer.getFullName();
        String tracerShort = tracer.getName();
        Class<?> context = event.getContext();
        String contextName = context.getName();
        String contextShort = context.getName();
        long timeStamp = event.getTimeStamp();
        String message = event.getMessage();
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        long threadID = thread.getId();
        int threadPriority = thread.getPriority();
        Thread.State threadState = thread.getState();
        return MessageFormat.format(pattern, new Object[]{tracerName, tracerShort, contextName, contextShort, timeStamp, message, threadName, threadID, threadPriority, threadState});
    }
}

