/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.monitor.MonitorUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitorHandler;
import org.eclipse.net4j.util.ui.widgets.MonitorLogDialog;
import org.eclipse.swt.widgets.Shell;

public class MonitorDialog
extends ProgressMonitorDialog {
    public static final int DEFAULT_SHELL_STYLE = 1264;
    private String title;
    private IDialogSettings settings;
    private MonitorLogDialog log;

    public MonitorDialog(Shell parentShell, int shellStyle, String title, IDialogSettings settings) {
        super(parentShell);
        this.setShellStyle(shellStyle);
        this.title = title;
        this.settings = settings;
    }

    public MonitorDialog(Shell parentShell, String title, IDialogSettings settings) {
        this(parentShell, 1264, title, settings);
    }

    public void run(boolean fork, boolean cancelable, final Runnable runnable) {
        try {
            this.log = new MonitorLogDialog(this.getShell(), this.getShellStyle(), "Log of " + this.title, "See the log for details.", this.settings);
            this.log.setEmphasizePrefix("Woven class ", "Mixed in ", "Reversioned ");
            super.run(fork, cancelable, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    MonitorUtil.Eclipse.startMonitoring((IProgressMonitor)monitor, (OMMonitorHandler)MonitorDialog.this.log);
                    try {
                        try {
                            runnable.run();
                        }
                        catch (RuntimeException ex) {
                            MonitorDialog.this.log.append(ex);
                            throw ex;
                        }
                    }
                    finally {
                        MonitorUtil.Eclipse.stopMonitoring();
                    }
                }
            });
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    protected void finishedRun() {
        super.finishedRun();
        if (this.log != null) {
            this.log.open();
        }
    }

    @Deprecated
    public final void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        if (this.settings == null) {
            return null;
        }
        IDialogSettings section = this.settings.getSection(this.title);
        if (section == null) {
            section = this.settings.addNewSection(this.title);
        }
        return section;
    }
}

