/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j;

import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.net4j.CDOSessionConfiguration;
import org.eclipse.emf.internal.cdo.net4j.CDONet4jSessionImpl;
import org.eclipse.emf.internal.cdo.session.CDOSessionConfigurationImpl;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.failover.IFailOverStrategy;
import org.eclipse.net4j.signal.failover.NOOPFailOverStrategy;
import org.eclipse.net4j.util.CheckUtil;

public class CDONet4jSessionConfigurationImpl
extends CDOSessionConfigurationImpl
implements CDOSessionConfiguration {
    private IConnector connector;
    private IFailOverStrategy failOverStrategy;

    public IConnector getConnector() {
        return this.connector;
    }

    public void setConnector(IConnector connector) {
        this.checkNotOpen();
        this.connector = connector;
    }

    public IFailOverStrategy getFailOverStrategy() {
        return this.failOverStrategy;
    }

    public void setFailOverStrategy(IFailOverStrategy failOverStrategy) {
        this.checkNotOpen();
        this.failOverStrategy = failOverStrategy;
    }

    public CDOSession openSession() {
        return (CDOSession)super.openSession();
    }

    protected InternalCDOSession createSession() {
        if (this.isActivateOnOpen()) {
            CheckUtil.checkState((boolean)(this.connector != null ^ this.failOverStrategy != null), (String)"Specify exactly one of connector or failOverStrategy");
        }
        CDONet4jSessionImpl session = new CDONet4jSessionImpl();
        if (this.connector != null) {
            session.setFailOverStrategy((IFailOverStrategy)new NOOPFailOverStrategy(this.connector));
        } else if (this.failOverStrategy != null) {
            session.setFailOverStrategy(this.failOverStrategy);
        }
        return session;
    }
}

