/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageTypeRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.internal.ui.SharedIcons;
import org.eclipse.emf.cdo.internal.ui.actions.CloseSessionAction;
import org.eclipse.emf.cdo.internal.ui.actions.CloseViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.CommitTransactionAction;
import org.eclipse.emf.cdo.internal.ui.actions.CreateResourceAction;
import org.eclipse.emf.cdo.internal.ui.actions.ExportResourceAction;
import org.eclipse.emf.cdo.internal.ui.actions.ImportResourceAction;
import org.eclipse.emf.cdo.internal.ui.actions.LoadResourceAction;
import org.eclipse.emf.cdo.internal.ui.actions.ManagePackagesAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenAuditAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenTransactionAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenViewEditorAction;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterFilesystemPackagesAction;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterSinglePackageAction;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterWorkspacePackagesAction;
import org.eclipse.emf.cdo.internal.ui.actions.ReloadViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.RollbackTransactionAction;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOAudit;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOItemProvider
extends ContainerItemProvider<IContainer<Object>> {
    private IWorkbenchPage page;

    public CDOItemProvider(IWorkbenchPage page, IElementFilter rootElementFilter) {
        super(rootElementFilter);
        this.page = page;
    }

    public CDOItemProvider(IWorkbenchPage page) {
        this(page, null);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof CDOView) {
            return NO_ELEMENTS;
        }
        return super.getChildren(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof CDOView) {
            return false;
        }
        return super.hasChildren(element);
    }

    public Object getParent(Object element) {
        return super.getParent(element);
    }

    public String getText(Object obj) {
        if (obj instanceof CDOSession) {
            return CDOItemProvider.getSessionLabel((CDOSession)obj);
        }
        if (obj instanceof CDOView) {
            return CDOItemProvider.getViewLabel((CDOView)obj);
        }
        return super.getText(obj);
    }

    public Image getImage(Object obj) {
        if (obj instanceof CDOSession) {
            return SharedIcons.getImage("obj16/cdo_session");
        }
        if (obj instanceof CDOView) {
            CDOView view = (CDOView)obj;
            switch (view.getViewType()) {
                case TRANSACTION: {
                    return SharedIcons.getImage("obj16/cdo_editor");
                }
                case READONLY: {
                    return SharedIcons.getImage("obj16/cdo_editor_readonly");
                }
                case AUDIT: {
                    return SharedIcons.getImage("obj16/cdo_editor_historical");
                }
            }
        }
        return super.getImage(obj);
    }

    public static String getSessionLabel(CDOSession session) {
        return MessageFormat.format(Messages.getString("CDOItemProvider.0"), session.repository().getName(), session.getSessionID());
    }

    public static String getViewLabel(CDOView view) {
        if (view instanceof CDOTransaction) {
            CDOTransaction transaction = (CDOTransaction)view;
            return MessageFormat.format(Messages.getString("CDOItemProvider.3"), transaction.isDirty() ? "*" : "", transaction.getViewID());
        }
        if (view instanceof CDOAudit) {
            CDOAudit audit = (CDOAudit)view;
            return MessageFormat.format(Messages.getString("CDOItemProvider.6"), audit.getTimeStamp());
        }
        return MessageFormat.format(Messages.getString("CDOItemProvider.7"), view.getViewID());
    }

    protected void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
        super.fillContextMenu(manager, selection);
        if (selection.size() == 1) {
            Object object = selection.getFirstElement();
            if (object instanceof CDOSession) {
                this.fillSession(manager, (CDOSession)object);
            } else if (object instanceof CDOView) {
                this.fillView(manager, (CDOView)object);
            }
        }
    }

    protected void fillSession(IMenuManager manager, CDOSession session) {
        manager.add((IAction)new OpenTransactionAction(this.page, session));
        manager.add((IAction)new OpenViewAction(this.page, session));
        manager.add((IAction)new OpenAuditAction(this.page, session));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ManagePackagesAction(this.page, session));
        MenuManager generatedManager = new MenuManager(Messages.getString("CDOItemProvider.8"));
        if (this.fillGenerated(generatedManager, session)) {
            manager.add((IContributionItem)generatedManager);
        }
        RegisterWorkspacePackagesAction a1 = new RegisterWorkspacePackagesAction(this.page, session);
        a1.setText(String.valueOf(a1.getText()) + SafeAction.INTERACTIVE);
        manager.add((IAction)a1);
        RegisterFilesystemPackagesAction a2 = new RegisterFilesystemPackagesAction(this.page, session);
        a2.setText(String.valueOf(a2.getText()) + SafeAction.INTERACTIVE);
        manager.add((IAction)a2);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new CloseSessionAction(this.page, session));
    }

    protected boolean fillGenerated(MenuManager manager, CDOSession session) {
        ArrayList registeredURIs = new ArrayList(EPackage.Registry.INSTANCE.keySet());
        Collections.sort(registeredURIs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        boolean added = false;
        CDOPackageRegistry packageRegistry = session.getPackageRegistry();
        for (String packageURI : registeredURIs) {
            CDOPackageUnit.Type type;
            if (packageRegistry.containsKey((Object)packageURI) || (type = CDOPackageTypeRegistry.INSTANCE.lookup(packageURI)) != CDOPackageUnit.Type.NATIVE) continue;
            EPackage ePackage = packageRegistry.getEPackage(packageURI);
            if (ePackage == null) {
                ePackage = EPackage.Registry.INSTANCE.getEPackage(packageURI);
            }
            if (ePackage == null) continue;
            manager.add((IAction)new RegisterSinglePackageAction(this.page, session, packageURI));
            added = true;
        }
        return added;
    }

    protected void fillView(IMenuManager manager, CDOView view) {
        manager.add((IAction)new OpenViewEditorAction(this.page, view));
        manager.add((IAction)new LoadResourceAction(this.page, view));
        manager.add((IAction)new ExportResourceAction(this.page, view));
        manager.add((IContributionItem)new Separator());
        if (view.getViewType() == CDOCommonView.Type.TRANSACTION) {
            manager.add((IAction)new CreateResourceAction(this.page, view));
            manager.add((IAction)new ImportResourceAction(this.page, view));
            manager.add((IAction)new CommitTransactionAction(this.page, view));
            manager.add((IAction)new RollbackTransactionAction(this.page, view));
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ReloadViewAction(this.page, view));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new CloseViewAction(this.page, view));
    }

    protected void elementAdded(Object element, Object parent) {
        super.elementAdded(element, parent);
        boolean cfr_ignored_0 = element instanceof CDOView;
    }

    protected void elementRemoved(Object element, Object parent) {
        super.elementRemoved(element, parent);
        boolean cfr_ignored_0 = element instanceof CDOView;
    }
}

