/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.internal.server.protocol.LoadRevisionIndication;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class LoadRevisionByVersionIndication
extends LoadRevisionIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadRevisionByVersionIndication.class);
    private int version;

    public LoadRevisionByVersionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)9);
    }

    protected void indicating(CDODataInput in) throws IOException {
        super.indicating(in);
        this.version = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read version: {0}", new Object[]{this.version});
        }
    }

    protected InternalCDORevision getRevision(CDOID id) {
        return this.getRepository().getRevisionManager().getRevisionByVersion(id, this.referenceChunk, this.version);
    }
}

