/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui;

import java.util.List;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.ui.security.InteractiveCredentialsProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UIUtil {
    private UIUtil() {
    }

    public static void dispose(Font font) {
        if (font != null) {
            font.dispose();
        }
    }

    public static void dispose(Color color) {
        if (color != null) {
            color.dispose();
        }
    }

    public static void dispose(Widget widget) {
        if (widget != null) {
            widget.dispose();
        }
    }

    public static Font getBoldFont(Control control) {
        FontData[] datas = (FontData[])control.getFont().getFontData().clone();
        datas[0].setStyle(1);
        Display display = control.getShell().getDisplay();
        Font font = new Font((Device)display, datas);
        return font;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            try {
                display = PlatformUI.getWorkbench().getDisplay();
            }
            catch (RuntimeException runtimeException) {}
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (display == null) {
            display = new Display();
        }
        if (display == null) {
            throw new IllegalStateException("No display available");
        }
        return display;
    }

    public static IWorkbench getWorkbench() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            throw new IllegalStateException("No workbench available");
        }
        return workbench;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow window = UIUtil.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            throw new IllegalStateException("No active window available");
        }
        return window;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchPage page = UIUtil.getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            throw new IllegalStateException("No active page available");
        }
        return page;
    }

    public static IWorkbenchPart getActiveWorkbenchPart() {
        IWorkbenchPart part = UIUtil.getActiveWorkbenchPage().getActivePart();
        if (part == null) {
            throw new IllegalStateException("No active part available");
        }
        return part;
    }

    public static Object getElement(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            return ssel.getFirstElement();
        }
        return null;
    }

    public static <T> T getElement(ISelection selection, Class<T> type) {
        Object element = UIUtil.getElement(selection);
        if (element != null && type.isInstance(element)) {
            Object result = element;
            return (T)result;
        }
        return null;
    }

    public static <T> List<T> getElements(ISelection selection, Class<T> type) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            return ssel.toList();
        }
        return null;
    }

    public static IPasswordCredentialsProvider createInteractiveCredentialsProvider() {
        return new InteractiveCredentialsProvider();
    }

    public static Composite createGridComposite(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)UIUtil.createGridLayout(columns));
        return composite;
    }

    public static GridLayout createGridLayout(int columns) {
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        return layout;
    }

    public static GridData createGridData() {
        return new GridData(4, 4, true, true);
    }

    public static GridData createGridData(boolean grabHorizontal, boolean grabVertical) {
        return new GridData(4, 4, grabHorizontal, grabVertical);
    }

    public static void addDecorationMargin(Control control) {
        Object data = control.getLayoutData();
        if (data instanceof GridData) {
            GridData gd = (GridData)data;
            FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
            FieldDecoration dec = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
            gd.horizontalIndent = dec.getImage().getBounds().width;
        }
    }

    public static void setIndentation(Control control, int horizontalIndent, int verticalIndent) {
        if (control == null) {
            throw new IllegalArgumentException("control == null");
        }
        Object data = control.getLayoutData();
        if (data instanceof GridData) {
            GridData gd = (GridData)data;
            if (verticalIndent >= 0) {
                gd.verticalIndent = verticalIndent;
            }
            if (horizontalIndent >= 0) {
                gd.horizontalIndent = horizontalIndent;
            }
        }
    }

    public static void refreshViewer(final Viewer viewer) {
        try {
            viewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        viewer.refresh();
                    }
                    catch (RuntimeException runtimeException) {}
                }
            });
        }
        catch (RuntimeException runtimeException) {}
    }

    public static void setStatusBarMessage(final String message, final Image image) {
        UIUtil.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    IViewSite site = (IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
                    if (image == null) {
                        site.getActionBars().getStatusLineManager().setMessage(message);
                    } else {
                        site.getActionBars().getStatusLineManager().setMessage(image, message);
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }
}

