/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jvm;

import org.eclipse.net4j.connector.ConnectorLocation;
import org.eclipse.net4j.internal.jvm.JVMAcceptor;
import org.eclipse.net4j.internal.jvm.JVMAcceptorManager;
import org.eclipse.net4j.internal.jvm.JVMConnector;
import org.eclipse.net4j.internal.jvm.JVMServerConnector;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class JVMClientConnector
extends JVMConnector {
    private JVMAcceptor acceptor;
    private IListener peerLifecycleListener = new LifecycleEventAdapter(){

        protected void onAboutToDeactivate(ILifecycle lifecycle) {
            JVMClientConnector.this.setPeer(null);
            JVMClientConnector.this.deactivate();
        }
    };

    public ConnectorLocation getLocation() {
        return ConnectorLocation.CLIENT;
    }

    public JVMAcceptor getAcceptor() {
        return this.acceptor;
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.acceptor = JVMAcceptorManager.INSTANCE.getAcceptor(this.getName());
        if (this.acceptor == null) {
            throw new IllegalStateException("acceptor == null");
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        JVMServerConnector peer = this.acceptor.handleAccept(this);
        peer.addListener(this.peerLifecycleListener);
        this.setPeer(peer);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivateNoisy((Object)this.getPeer());
        super.doDeactivate();
    }
}

