/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.net4j.buddies.common.ICollaboration;
import org.eclipse.net4j.buddies.common.ICollaborationContainer;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollaborationContainer
extends Lifecycle
implements ICollaborationContainer,
IListener {
    private Map<Long, ICollaboration> collaborations = new HashMap<Long, ICollaboration>();

    public CollaborationContainer(Collection<ICollaboration> collaborations) {
        if (collaborations != null) {
            for (ICollaboration collaboration : collaborations) {
                this.collaborations.put(collaboration.getID(), collaboration);
                collaboration.addListener(this);
            }
        }
    }

    public CollaborationContainer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCollaboration(ICollaboration collaboration) {
        long id = collaboration.getID();
        Map<Long, ICollaboration> map = this.collaborations;
        synchronized (map) {
            if (!this.collaborations.containsKey(id)) {
                this.collaborations.put(id, collaboration);
            }
        }
        this.fireEvent((IEvent)new SingleDeltaContainerEvent((IContainer)this, (Object)collaboration, IContainerDelta.Kind.ADDED));
        collaboration.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICollaboration removeCollaboration(long id) {
        ICollaboration collaboration;
        Map<Long, ICollaboration> map = this.collaborations;
        synchronized (map) {
            collaboration = this.collaborations.remove(id);
        }
        if (collaboration != null) {
            collaboration.removeListener(this);
            this.fireEvent((IEvent)new SingleDeltaContainerEvent((IContainer)this, (Object)collaboration, IContainerDelta.Kind.REMOVED));
        }
        return collaboration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICollaboration[] getCollaborations() {
        Map<Long, ICollaboration> map = this.collaborations;
        synchronized (map) {
            return this.collaborations.values().toArray(new ICollaboration[this.collaborations.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICollaboration getCollaboration(long id) {
        Map<Long, ICollaboration> map = this.collaborations;
        synchronized (map) {
            return this.collaborations.get(id);
        }
    }

    public ICollaboration[] getElements() {
        return this.getCollaborations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<Long, ICollaboration> map = this.collaborations;
        synchronized (map) {
            return this.collaborations.isEmpty();
        }
    }

    public void notifyEvent(IEvent event) {
        if (event.getSource() instanceof ICollaboration) {
            LifecycleEvent e;
            this.notifyCollaborationEvent(event);
            if (event instanceof LifecycleEvent && (e = (LifecycleEvent)event).getKind() == ILifecycleEvent.Kind.DEACTIVATED) {
                this.removeCollaboration(((ICollaboration)e.getSource()).getID());
            }
        }
    }

    protected void notifyCollaborationEvent(IEvent event) {
    }

    protected void doDeactivate() throws Exception {
        ICollaboration[] iCollaborationArray = this.getCollaborations();
        int n = iCollaborationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICollaboration collaboration = iCollaborationArray[n2];
            collaboration.removeListener(this);
            ++n2;
        }
        super.doDeactivate();
    }
}

