/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.mapping.strategy.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.mapping.strategy.StrategyUtil;
import org.eclipse.emf.teneo.mapping.strategy.impl.ClassicSQLNameStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeneoSQLNameStrategy
extends ClassicSQLNameStrategy {
    protected static final Log log = LogFactory.getLog(TeneoSQLNameStrategy.class);
    private static String[] removables = new String[]{"u", "o", "a", "e", "i"};

    @Override
    public List<String> getManyToOneJoinColumnNames(PAnnotatedEReference aReference) {
        EReference eref = aReference.getModelEReference();
        assert (eref.isTransient() || !eref.isMany());
        PAnnotatedEClass aClass = eref.getEOpposite() == null ? aReference.getAReferenceType() : aReference.getPaEClass();
        String typeName = aClass.getModelEClass().getName();
        String featureName = eref.getName();
        ArrayList<String> result = new ArrayList<String>();
        List<String> names = StrategyUtil.getIDFeaturesNames(aReference.getAReferenceType(), this.persistenceOptions.getDefaultIDFeatureName());
        boolean simpleNaming = this.optionJoinColumnNamingStrategy.compareTo("simple") == 0;
        for (String name : names) {
            String postFix = names.size() == 1 && simpleNaming ? "" : "_" + name;
            String jcName = simpleNaming ? String.valueOf(featureName) + postFix : String.valueOf(typeName) + "_" + featureName + postFix;
            result.add(this.convert(jcName, true));
        }
        return result;
    }

    @Override
    public String trunc(int maxSqlLength, String truncName, boolean truncPrefix) {
        String correctedName = truncName.replace('.', '_');
        if (maxSqlLength == -1) {
            return correctedName;
        }
        if (correctedName.length() <= maxSqlLength) {
            return correctedName;
        }
        if ((correctedName = correctedName.replaceAll("__", "_")).startsWith("_")) {
            correctedName = correctedName.substring(1);
        }
        if (correctedName.length() <= maxSqlLength) {
            return correctedName;
        }
        if ((correctedName = correctedName.replaceAll("e_id", "id")).length() <= maxSqlLength) {
            return correctedName;
        }
        char correctedNameFirstChar = correctedName.charAt(0);
        String correctedNameTail = correctedName.substring(1);
        String[] stringArray = this.getRemovableCharacters();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String vowel = stringArray[n2];
            while (correctedNameTail.indexOf(vowel) != -1 || correctedNameTail.indexOf(vowel.toUpperCase()) != -1) {
                correctedNameTail = correctedNameTail.indexOf(vowel) != -1 ? correctedNameTail.replaceFirst(vowel, "") : correctedNameTail.replaceFirst(vowel.toUpperCase(), "");
                if ((correctedNameTail = correctedNameTail.replaceAll("__", "_")).length() + 1 > maxSqlLength) continue;
                return String.valueOf(correctedNameFirstChar) + correctedNameTail;
            }
            ++n2;
        }
        return this.doLengthTruncation(maxSqlLength, String.valueOf(correctedNameFirstChar) + correctedNameTail);
    }

    private String doLengthTruncation(int maxSqlLength, String correctedName) {
        int underscore = correctedName.lastIndexOf(95);
        if (underscore == -1) {
            return correctedName.substring(0, maxSqlLength);
        }
        String[] parts = correctedName.split("_");
        int maxLength = -1;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.length() > maxLength && part.length() > 0) {
                maxLength = part.length();
            }
            ++n2;
        }
        int totalLength = correctedName.length();
        while (maxLength > 1 && totalLength > maxSqlLength) {
            totalLength = 0;
            int newMax = 0;
            int i = 0;
            while (i < parts.length) {
                if (parts[i].length() == maxLength) {
                    parts[i] = parts[i].substring(0, maxLength - 1);
                }
                if (parts[i].length() > newMax) {
                    newMax = parts[i].length();
                }
                totalLength += parts[i].length();
                ++i;
            }
            totalLength += parts.length - 1;
            maxLength = newMax;
        }
        StringBuffer result = new StringBuffer();
        String[] stringArray2 = parts;
        int n3 = parts.length;
        int n4 = 0;
        while (n4 < n3) {
            String part = stringArray2[n4];
            if (result.length() > 0) {
                result.append("_");
            }
            result.append(part);
            ++n4;
        }
        return result.toString();
    }

    protected String[] getRemovableCharacters() {
        return removables;
    }
}

