/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.identifier;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.eclipse.emf.teneo.classloader.ClassLoaderResolver;
import org.eclipse.emf.teneo.classloader.StoreClassLoadException;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.mapping.identifier.IdentifierCacheHandler;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.SessionImpl;
import org.hibernate.type.NullableType;
import org.hibernate.type.Type;

public class IdentifierUtil {
    private static final String ENCODING_SEPARATOR = ";";
    private static final Hashtable<String, Type> identifierTypeCache = new Hashtable();
    private static final Hashtable<String, Constructor<?>> constructorCache = new Hashtable();

    public static Type getIdentifierType(String className, SessionImplementor session) {
        Type type = identifierTypeCache.get(className);
        if (type != null) {
            return type;
        }
        Type identifierType = ((SessionImpl)session).getFactory().getClassMetadata(className).getIdentifierType();
        identifierTypeCache.put(className, identifierType);
        return identifierType;
    }

    public static String idToString(Object object, SessionImplementor session) {
        return IdentifierUtil.createIDString(IdentifierUtil.getIdentifierType(object.getClass().getName(), session), IdentifierUtil.getID(object, session));
    }

    public static Serializable stringToId(String className, SessionImplementor Session2, String idStr) {
        return IdentifierUtil.extractID(IdentifierUtil.getIdentifierType(className, Session2), idStr);
    }

    private static Serializable extractID(Type type, String idString) {
        if (type instanceof NullableType) {
            NullableType ntype = (NullableType)type;
            return (Serializable)ntype.fromStringValue(idString);
        }
        String className = idString.substring(0, idString.indexOf(ENCODING_SEPARATOR));
        String strValue = idString.substring(1 + idString.indexOf(ENCODING_SEPARATOR));
        Constructor<Object> constructor = constructorCache.get(className);
        if (constructor == null) {
            try {
                Class clazz = ClassLoaderResolver.classForName((String)className);
                constructor = clazz.getConstructor(String.class);
            }
            catch (StoreClassLoadException storeClassLoadException) {
                throw new HbMapperException("Class " + className + " not found");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new HbMapperException("Class " + className + " does not have a constructor with a String parameter!");
            }
        }
        if (constructor == null) {
            throw new HbMapperException("Class " + className + " does not have a constructor with a String parameter!");
        }
        try {
            return (Serializable)constructor.newInstance(strValue);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new HbMapperException("Can not instantiate: " + className + " using value " + strValue);
        }
        catch (InstantiationException instantiationException) {
            throw new HbMapperException("Can not instantiate: " + className + " using value " + strValue);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new HbMapperException("Can not instantiate: " + className + " using value " + strValue);
        }
    }

    public static Serializable getID(Object object, SessionImplementor session) {
        Serializable id = session.getContextEntityIdentifier(object);
        if (id != null) {
            return id;
        }
        String entityName = session.bestGuessEntityName(object);
        id = ForeignKeys.getEntityIdentifierIfNotUnsaved((String)entityName, (Object)object, (SessionImplementor)session);
        if (id != null) {
            return id;
        }
        return (Serializable)IdentifierCacheHandler.getInstance().getID(object);
    }

    private static String createIDString(Type type, Serializable id) {
        if (type instanceof NullableType) {
            NullableType ntype = (NullableType)type;
            return ntype.toString((Object)id);
        }
        return String.valueOf(id.getClass().getName()) + ENCODING_SEPARATOR + id.toString();
    }
}

