/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.namespace.QName;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QNameUserType
implements UserType {
    private static final int[] SQL_TYPES = new int[]{12};

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null && y == null) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.getClass() != y.getClass()) {
            return false;
        }
        QName q1 = (QName)x;
        QName q2 = (QName)y;
        return q1.toString().compareTo(q2.toString()) == 0;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.toString().hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String str = rs.getString(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        return this.convertFromString(str);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
        } else {
            st.setString(index, this.convertToString((QName)value));
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Class<?> returnedClass() {
        return QName.class;
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    protected String convertToString(QName qName) {
        return "{" + qName.getNamespaceURI() + "}" + qName.getPrefix() + ":" + qName.getLocalPart();
    }

    protected QName convertFromString(String str) {
        if (str.indexOf("{") == -1) {
            throw new HbStoreException("String " + str + " can not be converted to a QName, missing starting {");
        }
        int endIndexNS = str.indexOf("}");
        if (endIndexNS == -1) {
            throw new HbStoreException("String " + str + " can not be converted to a QName, missing end ns delimiter } ");
        }
        int prefixIndex = str.indexOf(":", endIndexNS);
        if (prefixIndex == -1) {
            throw new HbStoreException("String " + str + " can not be converted to a QName, missing prefix delimiter :");
        }
        String ns = str.substring(1, endIndexNS);
        String prefix = str.substring(endIndexNS + 1, prefixIndex);
        String localPart = str.substring(prefixIndex + 1);
        return new QName(ns, localPart, prefix);
    }
}

