/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.CDOTransaction;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.ui.actions.ViewAction;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class ImportResourceAction
extends ViewAction {
    public static final String ID = "import-resource";
    private static final String TITLE = "Import Resource";
    private URI sourceURI;
    private String targetPath;

    public ImportResourceAction(IWorkbenchPage page, CDOView view) {
        super(page, "Import Resource...", "Import a CDO resource", null, view);
        this.setId(ID);
    }

    protected void preRun() throws Exception {
        ImportResourceDialog dialog = new ImportResourceDialog(this.getShell(), TITLE, 4096);
        if (dialog.open() == 0) {
            List uris = dialog.getURIs();
            if (uris.size() == 1) {
                this.sourceURI = (URI)uris.get(0);
                this.targetPath = dialog.getTargetPath();
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)"A single URI must be entered!");
                this.cancel();
            }
        } else {
            this.cancel();
        }
    }

    protected void doRun() throws Exception {
        CDOTransaction transaction = this.getTransaction();
        ResourceSetImpl sourceSet = new ResourceSetImpl();
        Map map = sourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        map.put("*", new XMIResourceFactoryImpl());
        sourceSet.setPackageRegistry((EPackage.Registry)transaction.getSession().getPackageRegistry());
        Resource source = sourceSet.getResource(this.sourceURI, true);
        ArrayList sourceContents = new ArrayList(source.getContents());
        CDOResource target = transaction.createResource(this.targetPath);
        EList targetContents = target.getContents();
        for (EObject root : sourceContents) {
            targetContents.add((Object)root);
        }
    }

    public static class ImportResourceDialog
    extends ResourceDialog {
        private String targetPath = "/";
        private Text targetText;

        public ImportResourceDialog(Shell parent, String title, int style) {
            super(parent, title, style);
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public void setTargetPath(String targetPath) {
            this.targetPath = targetPath;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label separatorLabel1 = new Label(composite, 258);
            FormData data = new FormData();
            data.top = new FormAttachment((Control)this.uriField, 15);
            data.left = new FormAttachment(0, -10);
            data.right = new FormAttachment(100, 10);
            separatorLabel1.setLayoutData((Object)data);
            Label label = new Label(composite, 0);
            label.setText("Target path:");
            FormData data2 = new FormData();
            data2.top = new FormAttachment((Control)separatorLabel1, 10);
            data2.left = new FormAttachment(0, 10);
            data2.right = new FormAttachment(100, -10);
            label.setLayoutData((Object)data2);
            this.targetText = new Text(composite, 2048);
            data2 = new FormData();
            data2.top = new FormAttachment((Control)label, 10);
            data2.left = new FormAttachment(0, 10);
            data2.right = new FormAttachment(100, -10);
            this.targetText.setLayoutData((Object)data2);
            this.targetText.setText(this.targetPath);
            this.targetText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ImportResourceDialog.this.targetPath = ImportResourceDialog.this.targetText.getText();
                }
            });
            Label separatorLabel2 = new Label(composite, 258);
            FormData data3 = new FormData();
            data3.top = new FormAttachment((Control)this.targetText, 15);
            data3.left = new FormAttachment(0, -10);
            data3.right = new FormAttachment(100, 10);
            separatorLabel2.setLayoutData((Object)data3);
            return composite;
        }
    }
}

