/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import org.eclipse.emf.cdo.internal.server.Store;
import org.eclipse.emf.cdo.internal.server.StoreAccessor;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStoreAccessor;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.PersistableListHolder;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class HibernateStoreAccessor
extends StoreAccessor
implements IHibernateStoreAccessor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernateStoreAccessor.class);
    private Session hibernateSession;
    private boolean errorOccured = false;

    protected HibernateStoreAccessor(HibernateStore store, ISession session) {
        super((Store)store, session);
        if (TRACER.isEnabled()) {
            TRACER.trace("Created " + this.getClass().getName() + " for repository " + store.getRepository().getName());
        }
    }

    protected HibernateStoreAccessor(HibernateStore store, IView view) {
        super((Store)store, view);
        if (TRACER.isEnabled()) {
            TRACER.trace("Created " + this.getClass().getName() + " for repository " + store.getRepository().getName());
        }
    }

    protected void doRelease() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Committing/rollback and closing hibernate session");
        }
        this.endHibernateSession();
        PersistableListHolder.getInstance().clearListMapping();
    }

    public void resetHibernateSession() {
        this.endHibernateSession();
        this.beginHibernateSession();
    }

    public HibernateStore getStore() {
        return (HibernateStore)super.getStore();
    }

    public void beginHibernateSession() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Creating hibernate session and transaction");
        }
        assert (this.hibernateSession == null);
        SessionFactory sessionFactory = this.getStore().getHibernateSessionFactory();
        this.hibernateSession = sessionFactory.openSession();
        this.hibernateSession.beginTransaction();
    }

    public void endHibernateSession() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Closing hibernate session");
        }
        if (this.hibernateSession != null && this.hibernateSession.isOpen()) {
            try {
                if (this.isErrorOccured()) {
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Rolling back hb transaction");
                    }
                    this.hibernateSession.getTransaction().rollback();
                } else {
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Committing hb transaction");
                    }
                    this.hibernateSession.getTransaction().commit();
                }
            }
            finally {
                this.hibernateSession.close();
            }
        }
        this.hibernateSession = null;
    }

    public Session getHibernateSession() {
        if (this.hibernateSession == null) {
            this.beginHibernateSession();
        }
        return this.hibernateSession;
    }

    public boolean isErrorOccured() {
        return this.errorOccured;
    }

    public void setErrorOccured(boolean errorOccured) {
        this.errorOccured = errorOccured;
    }
}

