/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.Closeable;
import java.io.InputStream;
import org.eclipse.emf.cdo.server.hibernate.IHibernateMappingProvider;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.cfg.Configuration;

public class HibernateFileMappingProvider
implements IHibernateMappingProvider {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernateFileMappingProvider.class);
    private IHibernateStore hibernateStore;
    private final String[] mappingFileLocations;

    public HibernateFileMappingProvider(String location) {
        this(new String[]{location});
    }

    public HibernateFileMappingProvider(String[] locations) {
        this.mappingFileLocations = locations;
    }

    public IHibernateStore getHibernateStore() {
        return this.hibernateStore;
    }

    public void setHibernateStore(IHibernateStore hibernateStore) {
        this.hibernateStore = hibernateStore;
    }

    public void addMapping(Configuration configuration) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Adding hibernate mapping from location(s):");
        }
        String[] stringArray = this.mappingFileLocations;
        int n = this.mappingFileLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            if (TRACER.isEnabled()) {
                TRACER.trace(location);
            }
            InputStream is = null;
            try {
                try {
                    is = this.getClass().getResourceAsStream(location);
                    configuration.addInputStream(is);
                }
                catch (Exception e) {
                    throw WrappedException.wrap((Exception)e);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close((Closeable)is);
            ++n2;
        }
    }
}

