/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.migrator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenDelegationKind;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;

public abstract class CDOMigrator {
    public static final String ROOT_EXTENDS_CLASS = "org.eclipse.emf.internal.cdo.CDOObjectImpl";
    public static final String ROOT_EXTENDS_INTERFACE = "org.eclipse.emf.cdo.CDOObject";
    public static final String PLUGIN_VARIABLE = "CDO=org.eclipse.emf.cdo";
    public static final String CDO_MF_CONTENTS = "This is a marker file for bundles with CDO native models.\n";

    private CDOMigrator() {
    }

    public static String adjustGenModel(GenModel genModel, IProject project) {
        IFile file;
        IFolder folder;
        IWorkspaceRoot root;
        IFolder modelFolder;
        IProject modelProject;
        EList pluginVariables;
        StringBuilder builder = new StringBuilder();
        if (genModel.getFeatureDelegation() != GenDelegationKind.REFLECTIVE_LITERAL) {
            genModel.setFeatureDelegation(GenDelegationKind.REFLECTIVE_LITERAL);
            builder.append("Set Feature Delegation = ");
            builder.append(GenDelegationKind.REFLECTIVE_LITERAL);
            builder.append("\n");
        }
        if (!ROOT_EXTENDS_CLASS.equals(genModel.getRootExtendsClass())) {
            genModel.setRootExtendsClass(ROOT_EXTENDS_CLASS);
            builder.append("Set Root Extends Class = ");
            builder.append(ROOT_EXTENDS_CLASS);
            builder.append("\n");
        }
        if (!ROOT_EXTENDS_INTERFACE.equals(genModel.getRootExtendsInterface())) {
            genModel.setRootExtendsInterface(ROOT_EXTENDS_INTERFACE);
            builder.append("Set Root Extends Interface = ");
            builder.append(ROOT_EXTENDS_INTERFACE);
            builder.append("\n");
        }
        if (!(pluginVariables = genModel.getModelPluginVariables()).contains((Object)PLUGIN_VARIABLE)) {
            pluginVariables.add((Object)PLUGIN_VARIABLE);
            builder.append("Added Model Plugin Variables = ");
            builder.append(PLUGIN_VARIABLE);
            builder.append("\n");
        }
        if (!(modelProject = (modelFolder = (root = ResourcesPlugin.getWorkspace().getRoot()).getFolder((IPath)new Path(genModel.getModelDirectory()))).getProject()).exists()) {
            try {
                modelProject.create((IProgressMonitor)new NullProgressMonitor());
                builder.append("Created target model project\n");
            }
            catch (CoreException ex) {
                throw new WrappedException((Exception)((Object)ex));
            }
        }
        if (!modelProject.isOpen()) {
            try {
                modelProject.open((IProgressMonitor)new NullProgressMonitor());
                builder.append("Opened target model project\n");
            }
            catch (CoreException ex) {
                throw new WrappedException((Exception)((Object)ex));
            }
        }
        if (!(folder = modelProject.getFolder("META-INF")).exists()) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                builder.append("Created META-INF folder\n");
            }
            catch (CoreException ex) {
                throw new WrappedException((Exception)((Object)ex));
            }
        }
        if (!(file = folder.getFile("CDO.MF")).exists()) {
            try {
                ByteArrayInputStream contents = new ByteArrayInputStream(CDO_MF_CONTENTS.getBytes());
                file.create((InputStream)contents, true, (IProgressMonitor)new NullProgressMonitor());
                builder.append("Created CDO.MF marker file\n");
            }
            catch (CoreException ex) {
                throw new WrappedException((Exception)((Object)ex));
            }
        }
        return builder.length() == 0 ? null : builder.toString();
    }
}

