/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionResolver;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.revision.DLRevisionHolder;
import org.eclipse.emf.cdo.internal.common.revision.LRURevisionHolder;
import org.eclipse.emf.cdo.internal.common.revision.LRURevisionList;
import org.eclipse.emf.cdo.internal.common.revision.RevisionHolder;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDORevisionResolverImpl
extends Lifecycle
implements CDORevisionResolver {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, CDORevisionResolverImpl.class);
    private Map<CDOID, RevisionHolder> revisions = new HashMap<CDOID, RevisionHolder>();
    private int currentLRUCapacity;
    private int revisedLRUCapacity;
    private LRU currentLRU;
    private LRU revisedLRU;

    public int getCurrentLRUCapacity() {
        return this.currentLRUCapacity;
    }

    public void setCurrentLRUCapacity(int capacity) {
        this.currentLRUCapacity = capacity;
        if (this.currentLRU != null) {
            this.currentLRU.capacity(capacity);
        }
    }

    public int getRevisedLRUCapacity() {
        return this.revisedLRUCapacity;
    }

    public void setRevisedLRUCapacity(int capacity) {
        this.revisedLRUCapacity = capacity;
        if (this.revisedLRU != null) {
            this.revisedLRU.capacity(capacity);
        }
    }

    @Override
    public CDOClass getObjectType(CDOID id) {
        RevisionHolder holder = this.revisions.get(id);
        if (holder == null) {
            return null;
        }
        InternalCDORevision revision = (InternalCDORevision)holder.getRevision(true);
        return revision.getCDOClass();
    }

    @Override
    public boolean containsRevision(CDOID id) {
        return this.revisions.containsKey(id);
    }

    @Override
    public boolean containsRevisionByTime(CDOID id, long timeStamp) {
        return this.getRevisionByTime(id, 0, timeStamp, false) != null;
    }

    @Override
    public boolean containsRevisionByVersion(CDOID id, int version) {
        return this.getRevisionByVersion(id, 0, version, false) != null;
    }

    @Override
    public InternalCDORevision getRevision(CDOID id, int referenceChunk) {
        return this.getRevision(id, referenceChunk, true);
    }

    @Override
    public List<CDORevision> getRevisions(Collection<CDOID> ids, int referenceChunk) {
        ArrayList<CDOID> missingIDs = new ArrayList<CDOID>(0);
        ArrayList<CDORevision> revisions = new ArrayList<CDORevision>(ids.size());
        for (CDOID id : ids) {
            InternalCDORevision revision = this.getRevision(id, referenceChunk, false);
            revisions.add(revision);
            if (revision != null) continue;
            missingIDs.add(id);
        }
        if (!missingIDs.isEmpty()) {
            List<InternalCDORevision> missingRevisions = this.loadRevisions(missingIDs, referenceChunk);
            this.handleMissingRevisions(revisions, missingRevisions);
        }
        return revisions;
    }

    @Override
    public InternalCDORevision getRevisionByTime(CDOID id, int referenceChunk, long timeStamp) {
        return this.getRevisionByTime(id, referenceChunk, timeStamp, true);
    }

    @Override
    public List<CDORevision> getRevisionsByTime(Collection<CDOID> ids, int referenceChunk, long timeStamp) {
        ArrayList<CDOID> missingIDs = new ArrayList<CDOID>(0);
        ArrayList<CDORevision> revisions = new ArrayList<CDORevision>(ids.size());
        for (CDOID id : ids) {
            InternalCDORevision revision = this.getRevisionByTime(id, referenceChunk, timeStamp, false);
            revisions.add(revision);
            if (revision != null) continue;
            missingIDs.add(id);
        }
        if (!missingIDs.isEmpty()) {
            List<InternalCDORevision> missingRevisions = this.loadRevisions(missingIDs, referenceChunk);
            this.handleMissingRevisions(revisions, missingRevisions);
        }
        return revisions;
    }

    @Override
    public synchronized InternalCDORevision getRevisionByVersion(CDOID id, int referenceChunk, int version) {
        return this.getRevisionByVersion(id, referenceChunk, version, true);
    }

    @Override
    public synchronized InternalCDORevision getRevisionByVersion(CDOID id, int referenceChunk, int version, boolean loadOnDemand) {
        InternalCDORevision revision;
        for (RevisionHolder holder = this.revisions.get(id); holder != null; holder = holder.getNext()) {
            int holderVersion = holder.getVersion();
            if (holderVersion > version) {
                continue;
            }
            if (holderVersion != version) break;
            return (InternalCDORevision)holder.getRevision(true);
        }
        if (loadOnDemand && (revision = this.loadRevisionByVersion(id, referenceChunk, version)) != null) {
            this.addRevision(revision);
            return revision;
        }
        return null;
    }

    public boolean addRevision(InternalCDORevision revision) {
        RevisionHolder holder;
        if (TRACER.isEnabled()) {
            TRACER.format("Adding revision: {0}, created={1,date} {1,time}, revised={2,date} {2,time}, current={3}", new Object[]{revision, revision.getCreated(), revision.getRevised(), revision.isCurrent()});
        }
        RevisionHolder newHolder = this.createHolder(revision);
        LRU list = revision.isCurrent() ? this.currentLRU : this.revisedLRU;
        list.add((DLRevisionHolder)newHolder);
        int version = revision.getVersion();
        RevisionHolder lastHolder = null;
        for (holder = this.revisions.get(revision.getID()); holder != null; holder = holder.getNext()) {
            int holderVersion = holder.getVersion();
            if (holderVersion > version) {
                lastHolder = holder;
                continue;
            }
            if (holderVersion != version) break;
            return false;
        }
        this.adjustHolder(revision, newHolder, lastHolder, holder);
        return true;
    }

    @Override
    public InternalCDORevision getRevision(CDOID id, int referenceChunk, boolean loadOnDemand) {
        InternalCDORevision revision;
        RevisionHolder holder = this.revisions.get(id);
        InternalCDORevision internalCDORevision = revision = holder == null ? null : (InternalCDORevision)holder.getRevision(true);
        if (revision == null || !revision.isCurrent()) {
            if (loadOnDemand) {
                revision = this.loadRevision(id, referenceChunk);
                if (revision == null) {
                    throw new IllegalStateException("Could not load revision for " + id);
                }
                this.addRevision(revision);
            } else {
                revision = null;
            }
        } else {
            InternalCDORevision oldRevision = revision;
            if ((revision = this.verifyRevision(oldRevision, referenceChunk)) != oldRevision) {
                this.addRevision(revision);
            }
        }
        return revision;
    }

    @Override
    public synchronized InternalCDORevision getRevisionByTime(CDOID id, int referenceChunk, long timeStamp, boolean loadOnDemand) {
        InternalCDORevision revision;
        for (RevisionHolder holder = this.revisions.get(id); holder != null; holder = holder.getNext()) {
            int indicator = holder.compareTo(timeStamp);
            if (indicator == 1) {
                continue;
            }
            if (indicator != 0) break;
            InternalCDORevision oldRevision = (InternalCDORevision)holder.getRevision(true);
            InternalCDORevision revision2 = this.verifyRevision(oldRevision, referenceChunk);
            if (revision2 != oldRevision) {
                this.addRevision(revision2);
            }
            return revision2;
        }
        if (loadOnDemand && (revision = this.loadRevisionByTime(id, referenceChunk, timeStamp)) != null) {
            this.addRevision(revision);
            return revision;
        }
        return null;
    }

    protected abstract InternalCDORevision loadRevision(CDOID var1, int var2);

    protected abstract InternalCDORevision loadRevisionByTime(CDOID var1, int var2, long var3);

    protected abstract InternalCDORevision loadRevisionByVersion(CDOID var1, int var2, int var3);

    protected abstract List<InternalCDORevision> loadRevisions(Collection<CDOID> var1, int var2);

    protected abstract List<InternalCDORevision> loadRevisionsByTime(Collection<CDOID> var1, int var2, long var3);

    protected void handleMissingRevisions(List<CDORevision> revisions, List<InternalCDORevision> missingRevisions) {
        Iterator<InternalCDORevision> it = missingRevisions.iterator();
        int i = 0;
        while (i < revisions.size()) {
            CDORevision revision = revisions.get(i);
            if (revision == null) {
                InternalCDORevision missingRevision = it.next();
                revisions.set(i, missingRevision);
                this.addRevision(missingRevision);
            }
            ++i;
        }
    }

    protected synchronized void removeRevision(CDOID id, int version) {
        RevisionHolder holder = this.revisions.get(id);
        while (holder != null) {
            int holderVersion = holder.getVersion();
            if (holderVersion > version) {
                holder = holder.getNext();
                continue;
            }
            if (holderVersion == version) {
                this.removeHolder(holder);
            }
            holder = null;
        }
    }

    protected InternalCDORevision verifyRevision(InternalCDORevision revision, int referenceChunk) {
        return revision;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.currentLRU = new LRU(this.currentLRUCapacity);
        this.revisedLRU = new LRU(this.revisedLRUCapacity);
    }

    protected void doDeactivate() throws Exception {
        this.currentLRU = null;
        this.revisedLRU = null;
        super.doDeactivate();
    }

    private void adjustHolder(InternalCDORevision revision, RevisionHolder holder, RevisionHolder prevHolder, RevisionHolder nextHolder) {
        if (prevHolder != null) {
            if (nextHolder == null) {
                nextHolder = prevHolder.getNext();
            }
            holder.setPrev(prevHolder);
            holder.setNext(nextHolder);
            prevHolder.setNext(holder);
        } else {
            holder.setNext(nextHolder);
            this.revisions.put(revision.getID(), holder);
        }
        this.reviseHolder(holder, nextHolder);
    }

    private void reviseHolder(RevisionHolder holder, RevisionHolder nextHolder) {
        if (nextHolder != null) {
            nextHolder.setPrev(holder);
            if (holder.isCurrent() && nextHolder.isCurrent()) {
                this.currentLRU.remove((DLRevisionHolder)nextHolder);
                this.revisedLRU.add((DLRevisionHolder)nextHolder);
                InternalCDORevision oldRevision = (InternalCDORevision)nextHolder.getRevision(false);
                if (oldRevision != null) {
                    oldRevision.setRevised(holder.getCreated() - 1L);
                }
            }
        }
    }

    private synchronized void removeHolder(RevisionHolder holder) {
        CDOID id = holder.getID();
        RevisionHolder prev = holder.getPrev();
        RevisionHolder next = holder.getNext();
        if (next != null) {
            next.setPrev(prev);
        }
        if (prev != null) {
            prev.setNext(next);
        } else if (next != null) {
            this.revisions.put(id, next);
        } else {
            this.revisions.remove(id);
        }
        holder.setPrev(null);
        holder.setNext(null);
    }

    private RevisionHolder createHolder(InternalCDORevision revision) {
        LRU list = revision.isCurrent() ? this.currentLRU : this.revisedLRU;
        return new LRURevisionHolder(list, (CDORevision)revision);
    }

    private final class LRU
    extends LRURevisionList {
        public LRU(int capacity) {
            super(capacity);
        }

        public String toString() {
            return MessageFormat.format("LRU[size={0}, capacity={1}]", this.size(), this.capacity());
        }

        protected void evict(LRURevisionHolder holder) {
            if (TRACER.isEnabled()) {
                TRACER.format("Evicting revision {0}v{1}", new Object[]{holder.getID(), holder.getVersion()});
            }
            super.evict(holder);
            CDORevisionResolverImpl.this.removeHolder(holder);
        }
    }
}

