/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.mapping.elist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.teneo.mapping.elist.PersistableDelegateList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistableEMap<K, V>
extends EcoreEMap<K, V>
implements PersistableDelegateList<BasicEMap.Entry<K, V>> {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(PersistableEMap.class);
    protected String logString;
    private final int featureID;
    private boolean isLoaded = false;
    private boolean isLoading = false;
    private InternalEObject owner;
    protected Map<K, V> ormMapDelegate = null;

    public PersistableEMap(EClass entryEClass, EList<BasicEMap.Entry<K, V>> delegateEList) {
        super(entryEClass, Map.Entry.class, delegateEList);
        throw new UnsupportedOperationException("Explicitly passing delegate list is not supported!");
    }

    public PersistableEMap(EClass entryEClass, Class<?> entryClass, InternalEObject owner, EStructuralFeature feature) {
        super(entryEClass, Map.Entry.class, owner, owner.eClass().getFeatureID(feature));
        this.setDelegateEList(owner, feature, new ArrayList<BasicEMap.Entry<K, V>>());
        this.owner = owner;
        this.featureID = owner.eClass().getFeatureID(feature);
        log.debug((Object)("Created persistable emap for entry eclass " + entryEClass.getName()));
    }

    public PersistableEMap(EClass entryEClass, InternalEObject owner, EStructuralFeature feature, List<BasicEMap.Entry<K, V>> list) {
        super(entryEClass, Map.Entry.class, owner, owner.eClass().getFeatureID(feature));
        this.owner = owner;
        this.featureID = owner.eClass().getFeatureID(feature);
        this.setDelegateEList(owner, feature, list);
        log.debug((Object)("Created persistable emap for entry eclass " + entryEClass.getName()));
    }

    protected void setDelegateEList(InternalEObject owner, EStructuralFeature feature, List<BasicEMap.Entry<K, V>> delegateORMList) {
        assert (owner.eClass().getFeatureID(feature) == this.featureID);
        this.delegateEList = this.createDelegateEList(owner, feature, delegateORMList);
        this.logString = "EMap with entry eclass: " + this.entryEClass.getName() + " of member " + feature.getName() + " owned by " + owner.getClass().getName() + " with delegate list " + delegateORMList.getClass().getName();
        log.debug((Object)("Created/reset elist " + this.logString));
        if (delegateORMList instanceof EList) {
            this.setLoaded(true);
        } else if (delegateORMList instanceof ArrayList) {
            this.setLoaded(delegateORMList.size() > 0);
        }
    }

    protected abstract EList<BasicEMap.Entry<K, V>> createDelegateEList(InternalEObject var1, EStructuralFeature var2, List<BasicEMap.Entry<K, V>> var3);

    public void replaceDelegate(Object newDelegate) {
        this.setDelegateEList(this.owner, this.getEStructuralFeature(), (List)newDelegate);
        this.setLoaded(false);
    }

    protected void load() {
        if (this.isLoaded) {
            this.size = this.delegateEList.size();
            return;
        }
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        log.debug((Object)("Loading " + this.getLogString()));
        this.size = this.size();
        boolean eDeliver = this.getOwner().eDeliver();
        boolean setDeliver = false;
        try {
            if (eDeliver) {
                log.debug((Object)("Owner " + this.getOwner().getClass() + " set eDeliver to false"));
                this.getOwner().eSetDeliver(false);
                setDeliver = true;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            this.doLoad();
            this.size = this.size();
        }
        finally {
            this.isLoaded = true;
            this.isLoading = false;
            if (setDeliver) {
                this.owner.eSetDeliver(eDeliver);
            }
        }
    }

    protected abstract void doLoad();

    @Override
    public Object getDelegate() {
        return this;
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    protected void ensureEntryDataExists() {
        this.load();
        super.ensureEntryDataExists();
    }

    public int size() {
        if (!this.isLoaded()) {
            this.load();
        }
        this.size = this.delegateEList.size();
        return super.size();
    }

    public boolean isEmpty() {
        this.size();
        if (!this.isLoaded()) {
            return this.size == 0;
        }
        return super.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.load();
        return super.containsKey(key);
    }

    public Set<K> keySet() {
        this.load();
        return super.keySet();
    }

    public Collection<V> values() {
        this.load();
        return super.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        this.load();
        return super.entrySet();
    }

    public boolean containsValue(Object value) {
        this.load();
        return super.containsValue(value);
    }

    public V get(Object key) {
        this.load();
        return (V)super.get(key);
    }

    public Map<K, V> map() {
        this.load();
        if (this.view == null) {
            this.view = new BasicEMap.View();
        }
        if (this.view.map == null) {
            this.view.map = new PersistableDelegatingMap();
        }
        return this.view.map;
    }

    protected boolean isLoading() {
        return this.isLoading;
    }

    protected void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    protected void setLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
        log.debug((Object)("Isloaded is " + isLoaded));
    }

    protected String getLogString() {
        return this.logString;
    }

    protected InternalEObject getOwner() {
        return this.owner;
    }

    public NotificationChain basicAdd(Map.Entry<K, V> object, NotificationChain notifications) {
        this.load();
        return super.basicAdd(object, notifications);
    }

    public BasicEMap.Entry<K, V> basicGet(int index) {
        this.load();
        return super.basicGet(index);
    }

    public Iterator<Map.Entry<K, V>> basicIterator() {
        this.load();
        return super.basicIterator();
    }

    public List<Map.Entry<K, V>> basicList() {
        this.load();
        return super.basicList();
    }

    public ListIterator<Map.Entry<K, V>> basicListIterator() {
        this.load();
        return super.basicListIterator();
    }

    public ListIterator<Map.Entry<K, V>> basicListIterator(int index) {
        this.load();
        return super.basicListIterator(index);
    }

    public NotificationChain basicRemove(Object object, NotificationChain notifications) {
        this.load();
        return super.basicRemove(object, notifications);
    }

    public void addUnique(Map.Entry<K, V> object) {
        this.load();
        super.addUnique(object);
    }

    public void addUnique(int index, Map.Entry<K, V> object) {
        this.load();
        super.addUnique(index, object);
    }

    public Map.Entry<K, V> setUnique(int index, Map.Entry<K, V> object) {
        this.load();
        return super.setUnique(index, object);
    }

    public boolean add(Map.Entry<K, V> object) {
        this.load();
        return super.add(object);
    }

    public void add(int index, Map.Entry<K, V> object) {
        this.load();
        super.add(index, object);
    }

    public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
        this.load();
        return super.addAll(collection);
    }

    public boolean addAll(int index, Collection<? extends Map.Entry<K, V>> collection) {
        this.load();
        return super.addAll(index, collection);
    }

    public void clear() {
        this.isLoaded = false;
        super.clear();
    }

    public BasicEMap.Entry<K, V> get(int index) {
        this.load();
        return super.get(index);
    }

    protected int indexOf(int hash) {
        this.load();
        return super.indexOf(hash);
    }

    public int indexOf(Object object) {
        this.load();
        return super.indexOf(object);
    }

    public int indexOfKey(Object key) {
        this.load();
        return super.indexOfKey(key);
    }

    public Iterator<Map.Entry<K, V>> iterator() {
        this.load();
        return super.iterator();
    }

    public int lastIndexOf(Object object) {
        this.load();
        return super.lastIndexOf(object);
    }

    public ListIterator<Map.Entry<K, V>> listIterator() {
        this.load();
        return super.listIterator();
    }

    public ListIterator<Map.Entry<K, V>> listIterator(int index) {
        this.load();
        return super.listIterator(index);
    }

    public void move(int index, Map.Entry<K, V> object) {
        this.load();
        super.move(index, object);
    }

    public Map.Entry<K, V> move(int targetIndex, int sourceIndex) {
        this.load();
        return super.move(targetIndex, sourceIndex);
    }

    public V put(K key, V value) {
        this.load();
        return (V)super.put(key, value);
    }

    public void putAll(EMap<? extends K, ? extends V> map) {
        this.load();
        super.putAll(map);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.load();
        super.putAll(map);
    }

    protected V putEntry(BasicEMap.Entry<K, V> entry, V value) {
        this.load();
        return (V)super.putEntry(entry, value);
    }

    public Map.Entry<K, V> remove(int index) {
        this.load();
        return super.remove(index);
    }

    public boolean remove(Object object) {
        this.load();
        return super.remove(object);
    }

    public boolean removeAll(Collection<?> collection) {
        this.load();
        return super.removeAll(collection);
    }

    protected V removeEntry(int index, int entryIndex) {
        this.load();
        return (V)super.removeEntry(index, entryIndex);
    }

    public V removeKey(Object key) {
        this.load();
        return (V)super.removeKey(key);
    }

    protected V resolve(K key, V value) {
        this.load();
        return (V)super.resolve(key, value);
    }

    public boolean retainAll(Collection<?> collection) {
        this.load();
        return super.retainAll(collection);
    }

    public Map.Entry<K, V> set(int index, Map.Entry<K, V> object) {
        this.load();
        return super.set(index, object);
    }

    public List<Map.Entry<K, V>> subList(int start, int end) {
        this.load();
        return super.subList(start, end);
    }

    public Object[] toArray() {
        this.load();
        return super.toArray();
    }

    public <T> T[] toArray(T[] array) {
        this.load();
        return super.toArray((Object[])array);
    }

    public void set(Object value) {
        this.load();
        super.set(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PersistableDelegatingMap
    extends BasicEMap.DelegatingMap {
        public PersistableDelegatingMap() {
            super((BasicEMap)PersistableEMap.this);
        }

        public PersistableEMap<K, V> getOwner() {
            return PersistableEMap.this;
        }
    }
}

