/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.classloader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.TeneoException;
import org.eclipse.emf.teneo.classloader.ClassClassLoaderStrategy;
import org.eclipse.emf.teneo.classloader.ClassLoaderStrategy;
import org.eclipse.emf.teneo.classloader.ContextClassLoaderStrategy;
import org.eclipse.emf.teneo.classloader.StoreClassLoadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderResolver {
    private static Log log = LogFactory.getLog(ClassClassLoaderStrategy.class);
    private static ClassLoaderStrategy classLoaderStrategy;

    static {
        try {
            ClassLoaderResolver.setClassLoaderStrategy(new ContextClassLoaderStrategy());
        }
        catch (Exception e) {
            throw new TeneoException("Exception when setting default class loader strategy", e);
        }
    }

    public static Class<?> classForName(String name) {
        try {
            return Class.forName(name, true, ClassLoaderResolver.getClassLoader());
        }
        catch (Exception e) {
            throw new StoreClassLoadException("Class for name exception ", e);
        }
    }

    public static ClassLoader getClassLoader() {
        return classLoaderStrategy.getClassLoader();
    }

    public static ClassLoaderStrategy getClassLoaderStrategy() {
        return classLoaderStrategy;
    }

    public static void setClassLoaderStrategy(ClassLoaderStrategy classLoaderStrategy) {
        ClassLoaderResolver.classLoaderStrategy = classLoaderStrategy;
        log.info((Object)("Class loader strategy set to: " + classLoaderStrategy.getClass().getName()));
    }
}

