/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.classloader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.classloader.ClassLoaderStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassClassLoaderStrategy
implements ClassLoaderStrategy {
    private static Log log = LogFactory.getLog(ClassClassLoaderStrategy.class);
    private static CallerResolver callerResolver;

    static {
        try {
            callerResolver = new CallerResolver();
        }
        catch (SecurityException se) {
            log.error((Object)("Class class loader resolver could not be created because of SecurityException  just using the class loader of the classclassloader class, error msg: " + se.getMessage()), (Throwable)se);
            callerResolver = null;
        }
    }

    private static Class<?> getCallerClass(int callerOffset) {
        if (callerResolver == null) {
            return ClassClassLoaderStrategy.class;
        }
        return callerResolver.getClassContext()[callerOffset];
    }

    @Override
    public ClassLoader getClassLoader() {
        Class<?> clazz = ClassClassLoaderStrategy.getCallerClass(5);
        return clazz.getClassLoader();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            Class<?>[] clsContext = super.getClassContext();
            return clsContext;
        }
    }
}

