/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.teneo.annotations.mapper.BaseEFeatureAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.StoreMappingException;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.FetchType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.JoinTable;
import org.eclipse.emf.teneo.annotations.pannotation.OneToMany;
import org.eclipse.emf.teneo.annotations.pannotation.PAnnotation;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;
import org.eclipse.emf.teneo.util.StoreUtil;

public class OneToManyReferenceAnnotator
extends BaseEFeatureAnnotator
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(OneToManyReferenceAnnotator.class);

    public void annotate(PAnnotatedEReference aReference) {
        boolean isEObject;
        boolean otmWasSet;
        String logStr = String.valueOf(aReference.getModelEReference().getName()) + "/" + aReference.getModelEReference().getEContainingClass().getName();
        if (aReference.getManyToMany() != null || aReference.getOneToOne() != null || aReference.getManyToOne() != null) {
            throw new StoreMappingException("The feature/eclass " + logStr + " should be a OneToMany but " + "it already has a ManyToMany, OneToOne or ManyToOne annotation");
        }
        EReference eReference = (EReference)aReference.getModelElement();
        OneToMany otm = aReference.getOneToMany();
        boolean bl = otmWasSet = otm != null;
        if (otm == null) {
            log.debug((Object)("EReference + " + logStr + " does not have a onetomany annotation, adding one"));
            otm = this.getFactory().createOneToMany();
            aReference.setOneToMany(otm);
            otm.setEModelElement((EModelElement)eReference);
            if (eReference.isContainment() && this.getPersistenceOptions().isFetchContainmentEagerly()) {
                otm.setFetch(FetchType.EAGER);
            }
        } else {
            log.debug((Object)("EReference + " + logStr + " has onetomany, check if defaults should be set"));
        }
        if (this.getPersistenceOptions().isMapEmbeddableAsEmbedded() && aReference.getAReferenceType().getEmbeddable() != null) {
            aReference.setEmbedded(this.getFactory().createEmbedded());
        }
        if (this.getPersistenceOptions().isSetForeignKeyNames() && aReference.getForeignKey() == null) {
            if (eReference.getEOpposite() != null && !eReference.getEOpposite().isMany() && !eReference.getEOpposite().isTransient()) {
                PAnnotatedEReference aOpposite = aReference.getPaModel().getPAnnotated(eReference.getEOpposite());
                if (aOpposite == null || aOpposite.getTransient() != null) {
                    aReference.setForeignKey(this.createFK((PAnnotatedEStructuralFeature)aReference));
                }
            } else {
                aReference.setForeignKey(this.createFK((PAnnotatedEStructuralFeature)aReference));
            }
        }
        if (eReference.isContainment() || this.getPersistenceOptions().isSetDefaultCascadeOnNonContainment()) {
            this.setCascade((List<CascadeType>)otm.getCascade(), eReference.isContainment());
        }
        if (otm.getTargetEntity() == null) {
            otm.setTargetEntity(this.getEntityName(eReference.getEReferenceType()));
        }
        if (!otmWasSet) {
            log.debug((Object)"Setting indexed and unique from ereference because otm was not set manually!");
            otm.setIndexed(!this.getPersistenceOptions().alwaysMapListAsBag() && !this.getPersistenceOptions().alwaysMapListAsIdBag() && eReference.isOrdered() && aReference.getOrderBy() == null);
            otm.setUnique(eReference.isContainment() || !this.getPersistenceOptions().alwaysMapListAsIdBag() && eReference.isUnique());
            if (aReference.getModelEReference().getEOpposite() != null) {
                log.debug((Object)"Setting unique because is bidirectional (has eopposite) otm");
                otm.setUnique(true);
            }
        } else if (!otm.isUnique() && !eReference.isUnique() && aReference.getModelEReference().getEOpposite() != null) {
            log.warn((Object)("The EReference " + logStr + " is not unique (allows duplicates) but it is bi-directional, this is not logical"));
        }
        boolean bl2 = isEObject = EntityNameStrategy.EOBJECT_ECLASS_NAME.compareTo(otm.getTargetEntity()) == 0;
        if (aReference.getJoinTable() != null || isEObject || this.getPersistenceOptions().isJoinTableForNonContainedAssociations() && !eReference.isContainment() || !otm.isUnique()) {
            List<String> names;
            JoinTable joinTable = aReference.getJoinTable();
            if (joinTable == null) {
                joinTable = this.getFactory().createJoinTable();
                aReference.setJoinTable(joinTable);
            }
            joinTable.setEModelElement((EModelElement)eReference);
            if (joinTable.getName() == null) {
                joinTable.setName(this.getSqlNameStrategy().getJoinTableName(aReference));
            }
            if (joinTable.getJoinColumns().size() == 0) {
                names = this.getSqlNameStrategy().getJoinTableJoinColumns(aReference, false);
                joinTable.getJoinColumns().addAll(this.getJoinColumns(names, false, true, (PAnnotation)otm));
            }
            if (joinTable.getInverseJoinColumns().size() == 0 && aReference.getAReferenceType() != null) {
                names = this.getSqlNameStrategy().getJoinTableJoinColumns(aReference, true);
                joinTable.getInverseJoinColumns().addAll(this.getJoinColumns(names, false, true, (PAnnotation)otm));
            }
        } else if (aReference.getJoinColumns() == null || aReference.getJoinColumns().isEmpty()) {
            boolean borrowJoinColumnsOtherSide = false;
            EReference eOther = this.getOpposite(aReference);
            if (eOther != null) {
                PAnnotatedEReference aOther = aReference.getPaModel().getPAnnotated(eOther);
                this.getEFeatureAnnotator().getManyToOneReferenceAnnotator().annotate(aOther);
                if (aOther.getJoinColumns() != null && !aOther.getJoinColumns().isEmpty()) {
                    borrowJoinColumnsOtherSide = true;
                    for (JoinColumn jc : aOther.getJoinColumns()) {
                        aReference.getJoinColumns().add((Object)((JoinColumn)EcoreUtil.copy((EObject)jc)));
                    }
                    for (JoinColumn jc : aReference.getJoinColumns()) {
                        jc.setUpdatable(true);
                        jc.setInsertable(true);
                    }
                }
            }
            if (!borrowJoinColumnsOtherSide) {
                List<String> names = this.getSqlNameStrategy().getOneToManyEReferenceJoinColumns(aReference);
                aReference.getJoinColumns().addAll(this.getJoinColumns(names, aReference.getEmbedded() == null, true, (PAnnotation)otm));
            }
            if (otm.isList() && eOther != null) {
                PAnnotatedEReference aOpposite = this.getAnnotatedModel().getPAnnotated(eOther);
                if (aReference.getTransient() == null && aOpposite.getJoinColumns().size() > 0) {
                    for (JoinColumn jc : aOpposite.getJoinColumns()) {
                        jc.setInsertable(false);
                        jc.setUpdatable(false);
                    }
                }
            }
        }
    }

    protected EReference getOpposite(PAnnotatedEReference aReference) {
        EReference eReference = (EReference)aReference.getModelElement();
        if (eReference.getEOpposite() != null) {
            return eReference.getEOpposite();
        }
        if (aReference.getOneToMany() == null || aReference.getOneToMany().getMappedBy() == null) {
            return null;
        }
        EClass eclass = eReference.getEReferenceType();
        if (this.getPersistenceOptions().isMapEMapAsTrueMap() && StoreUtil.isMapEntry(eclass)) {
            EStructuralFeature feature = eclass.getEStructuralFeature("value");
            if (feature instanceof EReference) {
                String mappedBy = aReference.getOneToMany().getMappedBy();
                EReference valueERef = (EReference)feature;
                EClass valueEClass = valueERef.getEReferenceType();
                EStructuralFeature ef = valueEClass.getEStructuralFeature(mappedBy);
                if (ef == null || ef instanceof EAttribute) {
                    return null;
                }
                return (EReference)ef;
            }
            return null;
        }
        return null;
    }
}

