/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffPackage;
import org.eclipse.emf.compare.match.metamodel.MatchPackage;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.compare.ui.internal.ModelComparator;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeViewer;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureMergeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ModelCompareEditorInput
extends CompareEditorInput {
    protected ModelContentMergeViewer contentMergeViewer;
    protected final ComparisonSnapshot inputSnapshot;
    protected ModelCompareInput preparedInput;
    protected ModelStructureMergeViewer structureMergeViewer;
    private final ICompareInputChangeListener inputListener;

    public ModelCompareEditorInput(ComparisonSnapshot snapshot) {
        super(new CompareConfiguration());
        this.inputSnapshot = snapshot;
        this.inputListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput source) {
                ModelCompareEditorInput.this.structureMergeViewer.setInput(source);
                ModelCompareEditorInput.this.contentMergeViewer.setInput(source);
                ModelCompareEditorInput.this.setDirty(true);
            }
        };
    }

    public void saveChanges(IProgressMonitor monitor) {
        try {
            if (this.preparedInput.getLeftResource() != null) {
                this.preparedInput.getLeftResource().save(Collections.EMPTY_MAP);
            }
            if (this.preparedInput.getRightResource() != null) {
                this.preparedInput.getRightResource().save(Collections.EMPTY_MAP);
            }
        }
        catch (IOException e) {
            EMFComparePlugin.log((String)e.getMessage(), (boolean)false);
        }
    }

    public Control createContents(Composite parent) {
        Splitter fComposite = new Splitter(parent, 512);
        this.createOutlineContents((Composite)fComposite, 256);
        CompareViewerPane pane = new CompareViewerPane((Composite)fComposite, 0);
        CompareConfiguration compareConfig = this.getCompareConfiguration();
        this.contentMergeViewer = this.createMergeViewer(pane, compareConfig);
        pane.setContent(this.contentMergeViewer.getControl());
        this.contentMergeViewer.setInput(this.preparedInput);
        fComposite.setWeights(new int[]{30, 70});
        return fComposite;
    }

    protected ModelContentMergeViewer createMergeViewer(CompareViewerPane pane, CompareConfiguration config) {
        return new ModelContentMergeViewer((Composite)pane, config);
    }

    public Control createOutlineContents(Composite parent, int direction) {
        Splitter splitter = new Splitter(parent, direction);
        CompareViewerPane pane = new CompareViewerPane((Composite)splitter, 0);
        this.structureMergeViewer = new ModelStructureMergeViewer((Composite)pane, this.getCompareConfiguration());
        pane.setContent((Control)this.structureMergeViewer.getTree());
        this.structureMergeViewer.setInput(this.preparedInput);
        return splitter;
    }

    protected Object prepareInput(IProgressMonitor monitor) {
        this.resolveAll(this.inputSnapshot);
        this.preparedInput = this.createModelCompareInput(this.inputSnapshot);
        ModelComparator comparator = ModelComparator.getComparator(this.getCompareConfiguration(), this.preparedInput);
        comparator.setComparisonResult(this.inputSnapshot);
        this.preparedInput.addCompareInputChangeListener(this.inputListener);
        return this.preparedInput;
    }

    protected ModelCompareInput createModelCompareInput(ComparisonSnapshot snap) {
        if (snap instanceof ComparisonResourceSetSnapshot) {
            return new ModelCompareInput(((ComparisonResourceSetSnapshot)snap).getMatchResourceSet(), ((ComparisonResourceSetSnapshot)snap).getDiffResourceSet());
        }
        return new ModelCompareInput(((ComparisonResourceSnapshot)snap).getMatch(), ((ComparisonResourceSnapshot)snap).getDiff());
    }

    private void resolveAll(ComparisonSnapshot snapshot) {
        ResourceSetImpl left = new ResourceSetImpl();
        ResourceSetImpl right = new ResourceSetImpl();
        ResourceSetImpl ancestor = new ResourceSetImpl();
        new DispatchingCrossReferencer((EObject)snapshot, (ResourceSet)left, (ResourceSet)right, (ResourceSet)ancestor);
    }

    final class DispatchingCrossReferencer
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = -1062288900965446469L;
        private final ResourceSet leftRS;
        private final ResourceSet rightRS;
        private final ResourceSet ancestorRS;

        public DispatchingCrossReferencer(EObject snapshot, ResourceSet left, ResourceSet right, ResourceSet ancestor) {
            super(snapshot);
            this.leftRS = left;
            this.rightRS = right;
            this.ancestorRS = ancestor;
            this.crossReference();
        }

        protected boolean resolve() {
            return false;
        }

        protected boolean crossReference(EObject object, EReference reference, EObject crossReferencedEObject) {
            boolean result;
            if (crossReferencedEObject.eIsProxy()) {
                URI proxyURI = ((InternalEObject)crossReferencedEObject).eProxyURI();
                EObject leftReference = this.leftRS.getEObject(proxyURI, false);
                EObject rightReference = this.rightRS.getEObject(proxyURI, false);
                EObject ancestorReference = this.ancestorRS.getEObject(proxyURI, false);
                if (reference == MatchPackage.eINSTANCE.getMatchModel_LeftRoots() || reference == DiffPackage.eINSTANCE.getDiffModel_LeftRoots()) {
                    leftReference = this.leftRS.getEObject(proxyURI, true);
                } else if (reference == MatchPackage.eINSTANCE.getMatchModel_RightRoots() || reference == DiffPackage.eINSTANCE.getDiffModel_RightRoots()) {
                    rightReference = this.rightRS.getEObject(proxyURI, true);
                } else if (reference == MatchPackage.eINSTANCE.getMatchModel_AncestorRoots() || reference == DiffPackage.eINSTANCE.getDiffModel_AncestorRoots()) {
                    ancestorReference = this.ancestorRS.getEObject(proxyURI, true);
                }
                EObject resolvedReferencedObject = leftReference != null ? leftReference : (rightReference != null ? rightReference : ancestorReference);
                if (resolvedReferencedObject != null) {
                    if (reference.isMany()) {
                        ArrayList<EObject> values = new ArrayList<EObject>();
                        values.add(resolvedReferencedObject);
                        object.eSet((EStructuralFeature)reference, values);
                    } else {
                        object.eSet((EStructuralFeature)reference, (Object)resolvedReferencedObject);
                    }
                    result = false;
                    this.add((InternalEObject)object, reference, resolvedReferencedObject);
                } else {
                    result = super.crossReference(object, reference, crossReferencedEObject);
                }
            } else {
                result = super.crossReference(object, reference, crossReferencedEObject);
            }
            return result;
        }
    }
}

