/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.identifier;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.hibernate.mapping.identifier.IdentifierCacheCleaningRunnable;
import org.eclipse.emf.teneo.hibernate.mapping.identifier.LoggingThreadFactory;

public class IdentifierCacheHandler {
    private static final Log LOG = LogFactory.getLog(IdentifierCacheHandler.class);
    private static final int DEFAULT_PURGING_PERIOD = 60;
    private static final String PURGING_PROPERTY = "org.eclipse.teneo.hibernate.identifierPurgingPeriod";
    private static final int PURGING_PERIOD = Integer.parseInt(System.getProperty("org.eclipse.teneo.hibernate.identifierPurgingPeriod", "60"));
    private static final IdentifierCacheHandler INSTANCE = new IdentifierCacheHandler();
    private Map<Key, Object> idMap = new ConcurrentHashMap<Key, Object>();
    private Map<Key, Object> versionMap = new ConcurrentHashMap<Key, Object>();
    private IdentifierCacheCleaningRunnable idCacheCleaner;
    private IdentifierCacheCleaningRunnable versionCacheCleaner;

    public static IdentifierCacheHandler getInstance() {
        return INSTANCE;
    }

    private IdentifierCacheHandler() {
        this.startPurgingThreads();
    }

    private void startPurgingThreads() {
        this.idCacheCleaner = this.startPurgingThread(this.idMap, "teneoHibernateIdMapPurging", PURGING_PERIOD, PURGING_PERIOD);
        this.versionCacheCleaner = this.startPurgingThread(this.versionMap, "teneoHibernateVersionMapPurging", PURGING_PERIOD / 2, PURGING_PERIOD);
        LOG.info((Object)("Started teneo purging threads with period " + PURGING_PERIOD));
    }

    private IdentifierCacheCleaningRunnable startPurgingThread(Map<Key, Object> map, String name, int initialDelay, int period) {
        ScheduledExecutorService ex = Executors.newSingleThreadScheduledExecutor(new LoggingThreadFactory(name));
        IdentifierCacheCleaningRunnable runnable = new IdentifierCacheCleaningRunnable(map, name);
        ex.scheduleAtFixedRate(runnable, initialDelay, period, TimeUnit.SECONDS);
        return runnable;
    }

    public void clear() {
        this.idMap.clear();
        this.versionMap.clear();
    }

    public Map<Key, Object> getIdMap() {
        return this.idMap;
    }

    public Map<Key, Object> getVersionMap() {
        return this.versionMap;
    }

    public Object getID(Object obj) {
        Object id = this.idMap.get(new Key(obj));
        if (id == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ID for object " + obj.getClass().getName() + " not found in id cache"));
            }
            return null;
        }
        if (id instanceof WeakReference) {
            return ((WeakReference)id).get();
        }
        return id;
    }

    public void setID(Object obj, Object id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting id: " + id + " for object " + obj.getClass().getName() + " in idcache "));
        }
        if (id == null) {
            this.idMap.remove(new Key(obj));
        } else if (this.useWeakReference(id)) {
            this.idMap.put(new Key(obj), new WeakReference<Object>(id));
        } else {
            this.idMap.put(new Key(obj), id);
        }
    }

    public Object getVersion(Object obj) {
        Object version = this.versionMap.get(new Key(obj));
        if (version == null) {
            return version;
        }
        return version;
    }

    private boolean useWeakReference(Object id) {
        if (Number.class.isAssignableFrom(id.getClass())) {
            return false;
        }
        return !String.class.isAssignableFrom(id.getClass());
    }

    public void setVersion(Object obj, Object version) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting version: " + version + " for object " + obj.getClass().getName() + " in idcache "));
        }
        if (version == null) {
            this.versionMap.remove(new Key(obj));
        } else {
            this.versionMap.put(new Key(obj), version);
        }
    }

    public void dumpID() {
        this.dumpContents(this.idMap);
    }

    private void dumpContents(Map<Key, Object> map) {
        for (Key key : map.keySet()) {
            key.weakRef.get();
        }
    }

    public IdentifierCacheCleaningRunnable getIdCacheCleaner() {
        return this.idCacheCleaner;
    }

    public IdentifierCacheCleaningRunnable getVersionCacheCleaner() {
        return this.versionCacheCleaner;
    }

    protected static class Key {
        private final WeakReference<Object> weakRef;
        private final int hashcode;

        Key(Object keyObject) {
            this.weakRef = new WeakReference<Object>(keyObject);
            this.hashcode = keyObject.hashCode();
        }

        public boolean equals(Object arg0) {
            assert (arg0 != null);
            assert (arg0 instanceof Key);
            Key key0 = (Key)arg0;
            Object obj0 = key0.weakRef.get();
            Object obj1 = this.weakRef.get();
            if (obj0 == null || obj1 == null) {
                return this == key0;
            }
            return obj0 == obj1;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean isValid() {
            return this.weakRef.get() != null;
        }
    }
}

